/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.geometry;

import org.geotools.referencing.GeodeticCalculator;
import org.locationtech.geomesa.utils.geotools.GeometryUtils$;
import org.locationtech.jts.geom.Point;
import scala.MatchError;
import scala.Product;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\t\u001dg\u0001B\u0001\u0003\u00015\u0011!\u0003R5ti\u0006t7-Z\"bY\u000e,H.\u0019;pe*\u00111\u0001B\u0001\tO\u0016|W.\u001a;ss*\u0011QAB\u0001\u0006kRLGn\u001d\u0006\u0003\u000f!\tqaZ3p[\u0016\u001c\u0018M\u0003\u0002\n\u0015\u0005aAn\\2bi&|g\u000e^3dQ*\t1\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001\u001dA\u0011qBE\u0007\u0002!)\t\u0011#A\u0003tG\u0006d\u0017-\u0003\u0002\u0014!\t1\u0011I\\=SK\u001aDQ!\u0006\u0001\u0005\u0002Y\ta\u0001P5oSRtD#A\f\u0011\u0005a\u0001Q\"\u0001\u0002\t\u000fi\u0001!\u0019!C\u00057\u0005!1-\u00197d+\u0005a\u0002CA\u000f#\u001b\u0005q\"BA\u0010!\u0003-\u0011XMZ3sK:\u001c\u0017N\\4\u000b\u0005\u0005R\u0011\u0001C4f_R|w\u000e\\:\n\u0005\rr\"AE$f_\u0012,G/[2DC2\u001cW\u000f\\1u_JDa!\n\u0001!\u0002\u0013a\u0012!B2bY\u000e\u0004\u0003\"B\u0014\u0001\t\u0003A\u0013AB7fi\u0016\u00148\u000fF\u0002*YY\u0002\"a\u0004\u0016\n\u0005-\u0002\"A\u0002#pk\ndW\rC\u0003.M\u0001\u0007a&A\u0001b!\tyC'D\u00011\u0015\t\t$'\u0001\u0003hK>l'BA\u001a\t\u0003\rQGo]\u0005\u0003kA\u0012Q\u0001U8j]RDQa\u000e\u0014A\u00029\n\u0011A\u0019\u0005\u0006s\u0001!\tAO\u0001\tI&\u001cH/\u00198dKR)1H!$\u0003\u0010B\u0011A(\u0015\b\u0003{)s!AP%\u000f\u0005}BeB\u0001!H\u001d\t\teI\u0004\u0002C\u000b6\t1I\u0003\u0002E\u0019\u00051AH]8pizJ\u0011aC\u0005\u0003\u0013)I!a\u0002\u0005\n\u0005\u00151\u0011BA\u0002\u0005\u000f\u0015Y%\u0001#\u0001M\u0003I!\u0015n\u001d;b]\u000e,7)\u00197dk2\fGo\u001c:\u0011\u0005aie!B\u0001\u0003\u0011\u0003q5CA'\u000f\u0011\u0015)R\n\"\u0001Q)\u0005ae\u0001\u0002*N\u0001N\u0013\u0001\u0002R5ti\u0006t7-Z\n\u0005#:!v\u000b\u0005\u0002\u0010+&\u0011a\u000b\u0005\u0002\b!J|G-^2u!\ty\u0001,\u0003\u0002Z!\ta1+\u001a:jC2L'0\u00192mK\"Aq%\u0015BK\u0002\u0013\u00051,F\u0001*\u0011!i\u0016K!E!\u0002\u0013I\u0013aB7fi\u0016\u00148\u000f\t\u0005\t?F\u0013)\u001a!C\u00017\u0006QQ.\u001b8EK\u001e\u0014X-Z:\t\u0011\u0005\f&\u0011#Q\u0001\n%\n1\"\\5o\t\u0016<'/Z3tA!A1-\u0015BK\u0002\u0013\u00051,\u0001\u0006nCb$Um\u001a:fKND\u0001\"Z)\u0003\u0012\u0003\u0006I!K\u0001\f[\u0006DH)Z4sK\u0016\u001c\b\u0005C\u0003\u0016#\u0012\u0005q\r\u0006\u0003iU.d\u0007CA5R\u001b\u0005i\u0005\"B\u0014g\u0001\u0004I\u0003\"B0g\u0001\u0004I\u0003\"B2g\u0001\u0004I\u0003b\u00028R\u0003\u0003%\ta\\\u0001\u0005G>\u0004\u0018\u0010\u0006\u0003iaF\u0014\bbB\u0014n!\u0003\u0005\r!\u000b\u0005\b?6\u0004\n\u00111\u0001*\u0011\u001d\u0019W\u000e%AA\u0002%Bq\u0001^)\u0012\u0002\u0013\u0005Q/\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0003YT#!K<,\u0003a\u0004\"!\u001f@\u000e\u0003iT!a\u001f?\u0002\u0013Ut7\r[3dW\u0016$'BA?\u0011\u0003)\tgN\\8uCRLwN\\\u0005\u0003\u007fj\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011!\t\u0019!UI\u0001\n\u0003)\u0018AD2paf$C-\u001a4bk2$HE\r\u0005\t\u0003\u000f\t\u0016\u0013!C\u0001k\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u001a\u0004\"CA\u0006#\u0006\u0005I\u0011IA\u0007\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011q\u0002\t\u0005\u0003#\tY\"\u0004\u0002\u0002\u0014)!\u0011QCA\f\u0003\u0011a\u0017M\\4\u000b\u0005\u0005e\u0011\u0001\u00026bm\u0006LA!!\b\u0002\u0014\t11\u000b\u001e:j]\u001eD\u0011\"!\tR\u0003\u0003%\t!a\t\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005\u0015\u0002cA\b\u0002(%\u0019\u0011\u0011\u0006\t\u0003\u0007%sG\u000fC\u0005\u0002.E\u000b\t\u0011\"\u0001\u00020\u0005q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA\u0019\u0003o\u00012aDA\u001a\u0013\r\t)\u0004\u0005\u0002\u0004\u0003:L\bBCA\u001d\u0003W\t\t\u00111\u0001\u0002&\u0005\u0019\u0001\u0010J\u0019\t\u0013\u0005u\u0012+!A\u0005B\u0005}\u0012a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005\u0005\u0003CBA\"\u0003\u0013\n\t$\u0004\u0002\u0002F)\u0019\u0011q\t\t\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002L\u0005\u0015#\u0001C%uKJ\fGo\u001c:\t\u0013\u0005=\u0013+!A\u0005\u0002\u0005E\u0013\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005M\u0013\u0011\f\t\u0004\u001f\u0005U\u0013bAA,!\t9!i\\8mK\u0006t\u0007BCA\u001d\u0003\u001b\n\t\u00111\u0001\u00022!I\u0011QL)\u0002\u0002\u0013\u0005\u0013qL\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u0011Q\u0005\u0005\n\u0003G\n\u0016\u0011!C!\u0003K\n\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003\u001fA\u0011\"!\u001bR\u0003\u0003%\t%a\u001b\u0002\r\u0015\fX/\u00197t)\u0011\t\u0019&!\u001c\t\u0015\u0005e\u0012qMA\u0001\u0002\u0004\t\tdB\u0005\u0002r5\u000b\t\u0011#\u0001\u0002t\u0005AA)[:uC:\u001cW\rE\u0002j\u0003k2\u0001BU'\u0002\u0002#\u0005\u0011qO\n\u0006\u0003k\nIh\u0016\t\t\u0003w\n\t)K\u0015*Q6\u0011\u0011Q\u0010\u0006\u0004\u0003\u007f\u0002\u0012a\u0002:v]RLW.Z\u0005\u0005\u0003\u0007\u000biHA\tBEN$(/Y2u\rVt7\r^5p]NBq!FA;\t\u0003\t9\t\u0006\u0002\u0002t!Q\u00111MA;\u0003\u0003%)%!\u001a\t\u0015\u00055\u0015QOA\u0001\n\u0003\u000by)A\u0003baBd\u0017\u0010F\u0004i\u0003#\u000b\u0019*!&\t\r\u001d\nY\t1\u0001*\u0011\u0019y\u00161\u0012a\u0001S!11-a#A\u0002%B!\"!'\u0002v\u0005\u0005I\u0011QAN\u0003\u001d)h.\u00199qYf$B!!(\u0002*B)q\"a(\u0002$&\u0019\u0011\u0011\u0015\t\u0003\r=\u0003H/[8o!\u0019y\u0011QU\u0015*S%\u0019\u0011q\u0015\t\u0003\rQ+\b\u000f\\34\u0011%\tY+a&\u0002\u0002\u0003\u0007\u0001.A\u0002yIAB!\"a,\u0002v\u0005\u0005I\u0011BAY\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005M\u0006\u0003BA\t\u0003kKA!a.\u0002\u0014\t1qJ\u00196fGR4a!a/N\u0001\u0006u&aC'j]\u0012K7\u000f^1oG\u0016\u001cR!!/\u000f)^C\u0011bJA]\u0005+\u0007I\u0011A.\t\u0013u\u000bIL!E!\u0002\u0013I\u0003BCAc\u0003s\u0013)\u001a!C\u00017\u00069A-Z4sK\u0016\u001c\bBCAe\u0003s\u0013\t\u0012)A\u0005S\u0005AA-Z4sK\u0016\u001c\b\u0005C\u0004\u0016\u0003s#\t!!4\u0015\r\u0005=\u0017\u0011[Aj!\rI\u0017\u0011\u0018\u0005\u0007O\u0005-\u0007\u0019A\u0015\t\u000f\u0005\u0015\u00171\u001aa\u0001S!Ia.!/\u0002\u0002\u0013\u0005\u0011q\u001b\u000b\u0007\u0003\u001f\fI.a7\t\u0011\u001d\n)\u000e%AA\u0002%B\u0011\"!2\u0002VB\u0005\t\u0019A\u0015\t\u0011Q\fI,%A\u0005\u0002UD\u0011\"a\u0001\u0002:F\u0005I\u0011A;\t\u0015\u0005-\u0011\u0011XA\u0001\n\u0003\ni\u0001\u0003\u0006\u0002\"\u0005e\u0016\u0011!C\u0001\u0003GA!\"!\f\u0002:\u0006\u0005I\u0011AAt)\u0011\t\t$!;\t\u0015\u0005e\u0012Q]A\u0001\u0002\u0004\t)\u0003\u0003\u0006\u0002>\u0005e\u0016\u0011!C!\u0003\u007fA!\"a\u0014\u0002:\u0006\u0005I\u0011AAx)\u0011\t\u0019&!=\t\u0015\u0005e\u0012Q^A\u0001\u0002\u0004\t\t\u0004\u0003\u0006\u0002^\u0005e\u0016\u0011!C!\u0003?B!\"a\u0019\u0002:\u0006\u0005I\u0011IA3\u0011)\tI'!/\u0002\u0002\u0013\u0005\u0013\u0011 \u000b\u0005\u0003'\nY\u0010\u0003\u0006\u0002:\u0005]\u0018\u0011!a\u0001\u0003c9\u0011\"a@N\u0003\u0003E\tA!\u0001\u0002\u00175Kg\u000eR5ti\u0006t7-\u001a\t\u0004S\n\ra!CA^\u001b\u0006\u0005\t\u0012\u0001B\u0003'\u0015\u0011\u0019Aa\u0002X!!\tYH!\u0003*S\u0005=\u0017\u0002\u0002B\u0006\u0003{\u0012\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c83\u0011\u001d)\"1\u0001C\u0001\u0005\u001f!\"A!\u0001\t\u0015\u0005\r$1AA\u0001\n\u000b\n)\u0007\u0003\u0006\u0002\u000e\n\r\u0011\u0011!CA\u0005+!b!a4\u0003\u0018\te\u0001BB\u0014\u0003\u0014\u0001\u0007\u0011\u0006C\u0004\u0002F\nM\u0001\u0019A\u0015\t\u0015\u0005e%1AA\u0001\n\u0003\u0013i\u0002\u0006\u0003\u0003 \t\u001d\u0002#B\b\u0002 \n\u0005\u0002#B\b\u0003$%J\u0013b\u0001B\u0013!\t1A+\u001e9mKJB!\"a+\u0003\u001c\u0005\u0005\t\u0019AAh\u0011)\tyKa\u0001\u0002\u0002\u0013%\u0011\u0011\u0017\u0004\u0007\u0005[i\u0005Ia\f\u0003\u00175\u000b\u0007\u0010R5ti\u0006t7-Z\n\u0006\u0005WqAk\u0016\u0005\nO\t-\"Q3A\u0005\u0002mC\u0011\"\u0018B\u0016\u0005#\u0005\u000b\u0011B\u0015\t\u0015\u0005\u0015'1\u0006BK\u0002\u0013\u00051\f\u0003\u0006\u0002J\n-\"\u0011#Q\u0001\n%Bq!\u0006B\u0016\t\u0003\u0011Y\u0004\u0006\u0004\u0003>\t}\"\u0011\t\t\u0004S\n-\u0002BB\u0014\u0003:\u0001\u0007\u0011\u0006C\u0004\u0002F\ne\u0002\u0019A\u0015\t\u00139\u0014Y#!A\u0005\u0002\t\u0015CC\u0002B\u001f\u0005\u000f\u0012I\u0005\u0003\u0005(\u0005\u0007\u0002\n\u00111\u0001*\u0011%\t)Ma\u0011\u0011\u0002\u0003\u0007\u0011\u0006\u0003\u0005u\u0005W\t\n\u0011\"\u0001v\u0011%\t\u0019Aa\u000b\u0012\u0002\u0013\u0005Q\u000f\u0003\u0006\u0002\f\t-\u0012\u0011!C!\u0003\u001bA!\"!\t\u0003,\u0005\u0005I\u0011AA\u0012\u0011)\tiCa\u000b\u0002\u0002\u0013\u0005!Q\u000b\u000b\u0005\u0003c\u00119\u0006\u0003\u0006\u0002:\tM\u0013\u0011!a\u0001\u0003KA!\"!\u0010\u0003,\u0005\u0005I\u0011IA \u0011)\tyEa\u000b\u0002\u0002\u0013\u0005!Q\f\u000b\u0005\u0003'\u0012y\u0006\u0003\u0006\u0002:\tm\u0013\u0011!a\u0001\u0003cA!\"!\u0018\u0003,\u0005\u0005I\u0011IA0\u0011)\t\u0019Ga\u000b\u0002\u0002\u0013\u0005\u0013Q\r\u0005\u000b\u0003S\u0012Y#!A\u0005B\t\u001dD\u0003BA*\u0005SB!\"!\u000f\u0003f\u0005\u0005\t\u0019AA\u0019\u000f%\u0011i'TA\u0001\u0012\u0003\u0011y'A\u0006NCb$\u0015n\u001d;b]\u000e,\u0007cA5\u0003r\u0019I!QF'\u0002\u0002#\u0005!1O\n\u0006\u0005c\u0012)h\u0016\t\t\u0003w\u0012I!K\u0015\u0003>!9QC!\u001d\u0005\u0002\teDC\u0001B8\u0011)\t\u0019G!\u001d\u0002\u0002\u0013\u0015\u0013Q\r\u0005\u000b\u0003\u001b\u0013\t(!A\u0005\u0002\n}DC\u0002B\u001f\u0005\u0003\u0013\u0019\t\u0003\u0004(\u0005{\u0002\r!\u000b\u0005\b\u0003\u000b\u0014i\b1\u0001*\u0011)\tIJ!\u001d\u0002\u0002\u0013\u0005%q\u0011\u000b\u0005\u0005?\u0011I\t\u0003\u0006\u0002,\n\u0015\u0015\u0011!a\u0001\u0005{A!\"a,\u0003r\u0005\u0005I\u0011BAY\u0011\u0015i\u0003\b1\u0001/\u0011\u00159\u0004\b1\u0001/\u0011\u0019I\u0004\u0001\"\u0001\u0003\u0014R91H!&\u0003\u0018\ne\u0005BB\u0017\u0003\u0012\u0002\u0007a\u0006\u0003\u00048\u0005#\u0003\rA\f\u0005\u0007O\tE\u0005\u0019A\u0015\t\u000f\tu\u0005\u0001\"\u0001\u0003 \u0006\u0019Q.\u001b8\u0015\r\t\u0005&1\u0015BS!\ra\u0014\u0011\u0018\u0005\u0007[\tm\u0005\u0019\u0001\u0018\t\r]\u0012Y\n1\u0001/\u0011\u001d\u0011i\n\u0001C\u0001\u0005S#r!\u000bBV\u0005[\u0013y\u000b\u0003\u0004.\u0005O\u0003\rA\f\u0005\u0007o\t\u001d\u0006\u0019\u0001\u0018\t\r\u001d\u00129\u000b1\u0001*\u0011\u001d\u0011\u0019\f\u0001C\u0001\u0005k\u000b1!\\1y)\u0019\u00119L!/\u0003<B\u0019AHa\u000b\t\r5\u0012\t\f1\u0001/\u0011\u00199$\u0011\u0017a\u0001]!9!1\u0017\u0001\u0005\u0002\t}FcB\u0015\u0003B\n\r'Q\u0019\u0005\u0007[\tu\u0006\u0019\u0001\u0018\t\r]\u0012i\f1\u0001/\u0011\u00199#Q\u0018a\u0001S\u0001")
public class DistanceCalculator {
    private final GeodeticCalculator calc = new GeodeticCalculator();

    private GeodeticCalculator calc() {
        return this.calc;
    }

    public double meters(Point a, Point b) {
        this.calc().setStartingGeographicPoint(a.getX(), a.getY());
        this.calc().setDestinationGeographicPoint(b.getX(), b.getY());
        return this.calc().getOrthodromicDistance();
    }

    public Distance distance(Point a, Point b) {
        return this.distance(a, b, this.meters(a, b));
    }

    public Distance distance(Point a, Point b, double meters) {
        Tuple2<Object, Object> tuple2 = GeometryUtils$.MODULE$.distanceDegrees(a, meters, this.calc());
        if (tuple2 != null) {
            Tuple2.mcDD.sp sp2;
            double a0 = tuple2._1$mcD$sp();
            double a1 = tuple2._2$mcD$sp();
            Tuple2.mcDD.sp sp3 = sp2 = new Tuple2.mcDD.sp(a0, a1);
            double a02 = sp3._1$mcD$sp();
            double a12 = sp3._2$mcD$sp();
            Tuple2<Object, Object> tuple22 = GeometryUtils$.MODULE$.distanceDegrees(b, meters, this.calc());
            if (tuple22 != null) {
                Tuple2.mcDD.sp sp4;
                double b0 = tuple22._1$mcD$sp();
                double b1 = tuple22._2$mcD$sp();
                Tuple2.mcDD.sp sp5 = sp4 = new Tuple2.mcDD.sp(b0, b1);
                double b02 = sp5._1$mcD$sp();
                double b12 = sp5._2$mcD$sp();
                return new Distance(meters, package$.MODULE$.min(a02, b02), package$.MODULE$.max(a12, b12));
            }
            throw new MatchError(tuple22);
        }
        throw new MatchError(tuple2);
    }

    public MinDistance min(Point a, Point b) {
        double m = this.meters(a, b);
        return new MinDistance(m, this.min(a, b, m));
    }

    public double min(Point a, Point b, double meters) {
        double amin = GeometryUtils$.MODULE$.distanceDegrees(a, meters, this.calc())._1$mcD$sp();
        double bmin = GeometryUtils$.MODULE$.distanceDegrees(b, meters, this.calc())._1$mcD$sp();
        return package$.MODULE$.min(amin, bmin);
    }

    public MaxDistance max(Point a, Point b) {
        double m = this.meters(a, b);
        return new MaxDistance(m, this.max(a, b, m));
    }

    public double max(Point a, Point b, double meters) {
        double amax = GeometryUtils$.MODULE$.distanceDegrees(a, meters, this.calc())._2$mcD$sp();
        double bmax = GeometryUtils$.MODULE$.distanceDegrees(b, meters, this.calc())._2$mcD$sp();
        return package$.MODULE$.max(amax, bmax);
    }

    public static class Distance
    implements Product,
    Serializable {
        private final double meters;
        private final double minDegrees;
        private final double maxDegrees;

        public double meters() {
            return this.meters;
        }

        public double minDegrees() {
            return this.minDegrees;
        }

        public double maxDegrees() {
            return this.maxDegrees;
        }

        public Distance copy(double meters, double minDegrees, double maxDegrees) {
            return new Distance(meters, minDegrees, maxDegrees);
        }

        public double copy$default$1() {
            return this.meters();
        }

        public double copy$default$2() {
            return this.minDegrees();
        }

        public double copy$default$3() {
            return this.maxDegrees();
        }

        public String productPrefix() {
            return "Distance";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            Double d;
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 2: {
                    d = BoxesRunTime.boxToDouble((double)this.maxDegrees());
                    break;
                }
                case 1: {
                    d = BoxesRunTime.boxToDouble((double)this.minDegrees());
                    break;
                }
                case 0: {
                    d = BoxesRunTime.boxToDouble((double)this.meters());
                }
            }
            return d;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Distance;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.meters()));
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.minDegrees()));
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.maxDegrees()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Distance)) return false;
            boolean bl = true;
            if (!bl) return false;
            Distance distance = (Distance)x$1;
            if (this.meters() != distance.meters()) return false;
            if (this.minDegrees() != distance.minDegrees()) return false;
            if (this.maxDegrees() != distance.maxDegrees()) return false;
            if (!distance.canEqual(this)) return false;
            return true;
        }

        public Distance(double meters, double minDegrees, double maxDegrees) {
            this.meters = meters;
            this.minDegrees = minDegrees;
            this.maxDegrees = maxDegrees;
            Product.class.$init$((Product)this);
        }
    }

    public static class MinDistance
    implements Product,
    Serializable {
        private final double meters;
        private final double degrees;

        public double meters() {
            return this.meters;
        }

        public double degrees() {
            return this.degrees;
        }

        public MinDistance copy(double meters, double degrees) {
            return new MinDistance(meters, degrees);
        }

        public double copy$default$1() {
            return this.meters();
        }

        public double copy$default$2() {
            return this.degrees();
        }

        public String productPrefix() {
            return "MinDistance";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Double d;
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 1: {
                    d = BoxesRunTime.boxToDouble((double)this.degrees());
                    break;
                }
                case 0: {
                    d = BoxesRunTime.boxToDouble((double)this.meters());
                }
            }
            return d;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof MinDistance;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.meters()));
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.degrees()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof MinDistance)) return false;
            boolean bl = true;
            if (!bl) return false;
            MinDistance minDistance = (MinDistance)x$1;
            if (this.meters() != minDistance.meters()) return false;
            if (this.degrees() != minDistance.degrees()) return false;
            if (!minDistance.canEqual(this)) return false;
            return true;
        }

        public MinDistance(double meters, double degrees) {
            this.meters = meters;
            this.degrees = degrees;
            Product.class.$init$((Product)this);
        }
    }

    public static class MaxDistance
    implements Product,
    Serializable {
        private final double meters;
        private final double degrees;

        public double meters() {
            return this.meters;
        }

        public double degrees() {
            return this.degrees;
        }

        public MaxDistance copy(double meters, double degrees) {
            return new MaxDistance(meters, degrees);
        }

        public double copy$default$1() {
            return this.meters();
        }

        public double copy$default$2() {
            return this.degrees();
        }

        public String productPrefix() {
            return "MaxDistance";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Double d;
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 1: {
                    d = BoxesRunTime.boxToDouble((double)this.degrees());
                    break;
                }
                case 0: {
                    d = BoxesRunTime.boxToDouble((double)this.meters());
                }
            }
            return d;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof MaxDistance;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.meters()));
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.degrees()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof MaxDistance)) return false;
            boolean bl = true;
            if (!bl) return false;
            MaxDistance maxDistance = (MaxDistance)x$1;
            if (this.meters() != maxDistance.meters()) return false;
            if (this.degrees() != maxDistance.degrees()) return false;
            if (!maxDistance.canEqual(this)) return false;
            return true;
        }

        public MaxDistance(double meters, double degrees) {
            this.meters = meters;
            this.degrees = degrees;
            Product.class.$init$((Product)this);
        }
    }
}

