/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.index;

import com.google.common.primitives.UnsignedBytes;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.math.PartialOrdering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

public final class ByteArrays$ {
    public static final ByteArrays$ MODULE$;
    private final byte ZeroByte;
    private final byte OneByte;
    private final byte MaxByte;
    private final byte[] ZeroByteArray;
    private final byte[] OneByteArray;
    private final Ordering<byte[]> ByteOrdering;
    private final Ordering<Object> UnsignedByteOrdering;

    static {
        new ByteArrays$();
    }

    public byte ZeroByte() {
        return this.ZeroByte;
    }

    public byte OneByte() {
        return this.OneByte;
    }

    public byte MaxByte() {
        return this.MaxByte;
    }

    public byte[] ZeroByteArray() {
        return this.ZeroByteArray;
    }

    public byte[] OneByteArray() {
        return this.OneByteArray;
    }

    public Ordering<byte[]> ByteOrdering() {
        return this.ByteOrdering;
    }

    public Ordering<Object> UnsignedByteOrdering() {
        return this.UnsignedByteOrdering;
    }

    public void writeShort(short s, byte[] bytes2, int offset) {
        bytes2[offset] = (byte)(s >> 8);
        bytes2[offset + 1] = (byte)s;
    }

    public int writeShort$default$3() {
        return 0;
    }

    public void writeOrderedShort(short s, byte[] bytes2, int offset) {
        bytes2[offset] = (byte)(s >> 8 & 0xFF ^ 0x80);
        bytes2[offset + 1] = (byte)(s & 0xFF);
    }

    public int writeOrderedShort$default$3() {
        return 0;
    }

    public void writeInt(int n, byte[] bytes2, int offset) {
        bytes2[offset] = (byte)(n >> 24 & 0xFF);
        bytes2[offset + 1] = (byte)(n >> 16 & 0xFF);
        bytes2[offset + 2] = (byte)(n >> 8 & 0xFF);
        bytes2[offset + 3] = (byte)(n & 0xFF);
    }

    public int writeInt$default$3() {
        return 0;
    }

    public void writeLong(long l, byte[] bytes2, int offset) {
        bytes2[offset] = (byte)(l >> 56 & 0xFFL);
        bytes2[offset + 1] = (byte)(l >> 48 & 0xFFL);
        bytes2[offset + 2] = (byte)(l >> 40 & 0xFFL);
        bytes2[offset + 3] = (byte)(l >> 32 & 0xFFL);
        bytes2[offset + 4] = (byte)(l >> 24 & 0xFFL);
        bytes2[offset + 5] = (byte)(l >> 16 & 0xFFL);
        bytes2[offset + 6] = (byte)(l >> 8 & 0xFFL);
        bytes2[offset + 7] = (byte)(l & 0xFFL);
    }

    public int writeLong$default$3() {
        return 0;
    }

    public void writeOrderedLong(long l, byte[] bytes2, int offset) {
        bytes2[offset] = (byte)(l >> 56 & 0xFFL ^ 0x80L);
        bytes2[offset + 1] = (byte)(l >> 48 & 0xFFL);
        bytes2[offset + 2] = (byte)(l >> 40 & 0xFFL);
        bytes2[offset + 3] = (byte)(l >> 32 & 0xFFL);
        bytes2[offset + 4] = (byte)(l >> 24 & 0xFFL);
        bytes2[offset + 5] = (byte)(l >> 16 & 0xFFL);
        bytes2[offset + 6] = (byte)(l >> 8 & 0xFFL);
        bytes2[offset + 7] = (byte)(l & 0xFFL);
    }

    public int writeOrderedLong$default$3() {
        return 0;
    }

    public short readShort(byte[] bytes2, int offset) {
        return (short)((bytes2[offset] & 0xFF) << 8 | bytes2[offset + 1] & 0xFF);
    }

    public int readShort$default$2() {
        return 0;
    }

    public short readOrderedShort(byte[] bytes2, int offset) {
        return (short)(((bytes2[offset] ^ 0x80) & 0xFF) << 8 | bytes2[offset + 1] & 0xFF);
    }

    public int readOrderedShort$default$2() {
        return 0;
    }

    public int readInt(byte[] bytes2, int offset) {
        return (bytes2[offset] & 0xFF) << 24 | (bytes2[offset + 1] & 0xFF) << 16 | (bytes2[offset + 2] & 0xFF) << 8 | bytes2[offset + 3] & 0xFF;
    }

    public int readInt$default$2() {
        return 0;
    }

    public long readLong(byte[] bytes2, int offset) {
        return ((long)bytes2[offset] & 0xFFL) << 56 | ((long)bytes2[offset + 1] & 0xFFL) << 48 | ((long)bytes2[offset + 2] & 0xFFL) << 40 | ((long)bytes2[offset + 3] & 0xFFL) << 32 | ((long)bytes2[offset + 4] & 0xFFL) << 24 | ((long)bytes2[offset + 5] & 0xFFL) << 16 | ((long)bytes2[offset + 6] & 0xFFL) << 8 | (long)bytes2[offset + 7] & 0xFFL;
    }

    public int readLong$default$2() {
        return 0;
    }

    public long readOrderedLong(byte[] bytes2, int offset) {
        return ((long)(bytes2[offset] ^ 0x80) & 0xFFL) << 56 | ((long)bytes2[offset + 1] & 0xFFL) << 48 | ((long)bytes2[offset + 2] & 0xFFL) << 40 | ((long)bytes2[offset + 3] & 0xFFL) << 32 | ((long)bytes2[offset + 4] & 0xFFL) << 24 | ((long)bytes2[offset + 5] & 0xFFL) << 16 | ((long)bytes2[offset + 6] & 0xFFL) << 8 | (long)bytes2[offset + 7] & 0xFFL;
    }

    public int readOrderedLong$default$2() {
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    public byte[] toBytes(short s) {
        void var2_2;
        byte[] result = (byte[])Array$.MODULE$.ofDim(2, ClassTag$.MODULE$.Byte());
        this.writeShort(s, result, this.writeShort$default$3());
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public byte[] toOrderedBytes(short s) {
        void var2_2;
        byte[] result = (byte[])Array$.MODULE$.ofDim(2, ClassTag$.MODULE$.Byte());
        this.writeOrderedShort(s, result, this.writeOrderedShort$default$3());
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public byte[] toBytes(int n) {
        void var2_2;
        byte[] result = (byte[])Array$.MODULE$.ofDim(4, ClassTag$.MODULE$.Byte());
        this.writeInt(n, result, this.writeInt$default$3());
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public byte[] toBytes(long l) {
        void var3_2;
        byte[] result = (byte[])Array$.MODULE$.ofDim(8, ClassTag$.MODULE$.Byte());
        this.writeLong(l, result, this.writeLong$default$3());
        return var3_2;
    }

    /*
     * WARNING - void declaration
     */
    public byte[] toOrderedBytes(long l) {
        void var3_2;
        byte[] result = (byte[])Array$.MODULE$.ofDim(8, ClassTag$.MODULE$.Byte());
        this.writeOrderedLong(l, result, this.writeOrderedLong$default$3());
        return var3_2;
    }

    public byte[] toBytes(short bin, long z) {
        byte[] result = (byte[])Array$.MODULE$.ofDim(10, ClassTag$.MODULE$.Byte());
        this.writeShort(bin, result, 0);
        this.writeLong(z, result, 2);
        return result;
    }

    public byte[] toBytes(short bin, long s, int time2) {
        byte[] result = (byte[])Array$.MODULE$.ofDim(14, ClassTag$.MODULE$.Byte());
        this.writeShort(bin, result, this.writeShort$default$3());
        this.writeLong(s, result, 2);
        this.writeInt(time2, result, 10);
        return result;
    }

    public byte[] toBytesFollowingPrefix(short bin, long s, int time2) {
        return this.incrementInPlace(this.toBytes(bin, s, time2));
    }

    public byte[] toOrderedBytes(short bin, long z) {
        byte[] result = (byte[])Array$.MODULE$.ofDim(10, ClassTag$.MODULE$.Byte());
        this.writeOrderedShort(bin, result, 0);
        this.writeLong(z, result, 2);
        return result;
    }

    public byte[] toBytes(byte[] bin, long z) {
        byte[] result = (byte[])Array$.MODULE$.ofDim(10, ClassTag$.MODULE$.Byte());
        result[0] = bin[0];
        result[1] = bin[1];
        this.writeLong(z, result, 2);
        return result;
    }

    public byte[] uuidToBytes(long msb, long lsb) {
        byte[] result = (byte[])Array$.MODULE$.ofDim(16, ClassTag$.MODULE$.Byte());
        this.writeLong(msb, result, 0);
        this.writeLong(lsb, result, 8);
        return result;
    }

    public Tuple2<Object, Object> uuidFromBytes(byte[] bytes2, int offset) {
        long msb = this.readLong(bytes2, offset);
        long lsb = this.readLong(bytes2, offset + 8);
        return new Tuple2.mcJJ.sp(msb, lsb);
    }

    public int uuidFromBytes$default$2() {
        return 0;
    }

    public byte[] toBytesFollowingPrefix(long z) {
        return this.incrementInPlace(this.toBytes(z));
    }

    public byte[] toBytesFollowingPrefix(short bin, long z) {
        return this.incrementInPlace(this.toBytes(bin, z));
    }

    public byte[] toOrderedBytesFollowingPrefix(short bin, long z) {
        return this.incrementInPlace(this.toOrderedBytes(bin, z));
    }

    /*
     * WARNING - void declaration
     */
    public byte[] toBytesFollowingRow(long l) {
        void var3_2;
        byte[] result = (byte[])Array$.MODULE$.ofDim(9, ClassTag$.MODULE$.Byte());
        this.writeLong(l, result, this.writeLong$default$3());
        result[8] = this.ZeroByte();
        return var3_2;
    }

    public byte[] toBytesFollowingRow(short bin, long z) {
        byte[] result = (byte[])Array$.MODULE$.ofDim(11, ClassTag$.MODULE$.Byte());
        this.writeShort(bin, result, 0);
        this.writeLong(z, result, 2);
        result[10] = this.ZeroByte();
        return result;
    }

    public byte[] toOrderedBytesFollowingRow(short bin, long z) {
        byte[] result = (byte[])Array$.MODULE$.ofDim(11, ClassTag$.MODULE$.Byte());
        this.writeOrderedShort(bin, result, 0);
        this.writeLong(z, result, 2);
        result[10] = this.ZeroByte();
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public byte[] rowFollowingPrefix(byte[] prefix) {
        byte[] byArray;
        int changeIndex;
        for (changeIndex = prefix.length - 1; changeIndex >= 0 && prefix[changeIndex] == this.MaxByte(); --changeIndex) {
        }
        if (changeIndex < 0) {
            byArray = (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte());
        } else {
            void var3_3;
            byte[] following = (byte[])Array$.MODULE$.ofDim(changeIndex + 1, ClassTag$.MODULE$.Byte());
            System.arraycopy(prefix, 0, following, 0, changeIndex + 1);
            following[changeIndex] = (byte)(following[changeIndex] + 1);
            byArray = var3_3;
        }
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    public byte[] rowFollowingRow(byte[] row) {
        void var2_2;
        byte[] following = (byte[])Array$.MODULE$.ofDim(row.length + 1, ClassTag$.MODULE$.Byte());
        System.arraycopy(row, 0, following, 0, row.length);
        following[row.length] = this.ZeroByte();
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public byte[] rowFollowingRow(Seq<byte[]> bytes2) {
        void var3_3;
        IntRef length2 = IntRef.create((int)1);
        bytes2.foreach((Function1)new Serializable(length2){
            public static final long serialVersionUID = 0L;
            private final IntRef length$1;

            public final void apply(byte[] b) {
                this.length$1.elem += b.length;
            }
            {
                this.length$1 = length$1;
            }
        });
        byte[] result = (byte[])Array$.MODULE$.ofDim(length2.elem, ClassTag$.MODULE$.Byte());
        IntRef i = IntRef.create((int)0);
        bytes2.foreach((Function1)new Serializable(result, i){
            public static final long serialVersionUID = 0L;
            private final byte[] result$1;
            private final IntRef i$1;

            public final void apply(byte[] b) {
                System.arraycopy(b, 0, this.result$1, this.i$1.elem, b.length);
                this.i$1.elem += b.length;
            }
            {
                this.result$1 = result$1;
                this.i$1 = i$1;
            }
        });
        result[i.elem] = this.ZeroByte();
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public byte[] concat(byte[] first, byte[] second) {
        void var3_3;
        byte[] result = (byte[])Array$.MODULE$.ofDim(first.length + second.length, ClassTag$.MODULE$.Byte());
        System.arraycopy(first, 0, result, 0, first.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public byte[] concat(Seq<byte[]> bytes2) {
        void var3_3;
        IntRef length2 = IntRef.create((int)0);
        bytes2.foreach((Function1)new Serializable(length2){
            public static final long serialVersionUID = 0L;
            private final IntRef length$2;

            public final void apply(byte[] b) {
                this.length$2.elem += b.length;
            }
            {
                this.length$2 = length$2;
            }
        });
        byte[] result = (byte[])Array$.MODULE$.ofDim(length2.elem, ClassTag$.MODULE$.Byte());
        IntRef i = IntRef.create((int)0);
        bytes2.foreach((Function1)new Serializable(result, i){
            public static final long serialVersionUID = 0L;
            private final byte[] result$2;
            private final IntRef i$2;

            public final void apply(byte[] b) {
                System.arraycopy(b, 0, this.result$2, this.i$2.elem, b.length);
                this.i$2.elem += b.length;
            }
            {
                this.result$2 = result$2;
                this.i$2 = i$2;
            }
        });
        return var3_3;
    }

    public String toHex(byte b) {
        int arg$macro$3 = (b & 0xFF) >>> 4;
        int arg$macro$4 = b & 0xF;
        return new StringOps("%01x%01x").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)arg$macro$3), BoxesRunTime.boxToInteger((int)arg$macro$4)}));
    }

    public String toHex(byte[] bytes2) {
        return this.toHex(bytes2, 0, bytes2.length);
    }

    public String toHex(byte[] bytes2, int offset, int length2) {
        StringBuilder sb = new StringBuilder(length2 * 2);
        for (int i = 0; i < length2; ++i) {
            sb.append(this.toHex(bytes2[i + offset]));
        }
        return sb.toString();
    }

    /*
     * WARNING - void declaration
     */
    private byte[] incrementInPlace(byte[] bytes2) {
        byte[] byArray;
        int i = bytes2.length - 1;
        if (bytes2[i] != this.MaxByte()) {
            bytes2[i] = (byte)(bytes2[i] + 1);
            byArray = bytes2;
        } else {
            while (--i >= 0 && bytes2[i] == this.MaxByte()) {
            }
            if (i == -1) {
                byArray = (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte());
            } else {
                void var3_3;
                byte[] result = (byte[])Array$.MODULE$.ofDim(i + 1, ClassTag$.MODULE$.Byte());
                System.arraycopy(bytes2, 0, result, 0, result.length);
                result[i] = (byte)(result[i] + 1);
                byArray = var3_3;
            }
        }
        return byArray;
    }

    private ByteArrays$() {
        MODULE$ = this;
        this.ZeroByte = (byte)0;
        this.OneByte = (byte)1;
        this.MaxByte = (byte)255;
        this.ZeroByteArray = new byte[]{this.ZeroByte()};
        this.OneByteArray = new byte[]{this.OneByte()};
        this.ByteOrdering = package$.MODULE$.Ordering().comparatorToOrdering(UnsignedBytes.lexicographicalComparator());
        this.UnsignedByteOrdering = new Ordering<Object>(){

            public Some tryCompare(Object x, Object y) {
                return Ordering.class.tryCompare((Ordering)this, (Object)x, (Object)y);
            }

            public boolean lteq(Object x, Object y) {
                return Ordering.class.lteq((Ordering)this, (Object)x, (Object)y);
            }

            public boolean gteq(Object x, Object y) {
                return Ordering.class.gteq((Ordering)this, (Object)x, (Object)y);
            }

            public boolean lt(Object x, Object y) {
                return Ordering.class.lt((Ordering)this, (Object)x, (Object)y);
            }

            public boolean gt(Object x, Object y) {
                return Ordering.class.gt((Ordering)this, (Object)x, (Object)y);
            }

            public boolean equiv(Object x, Object y) {
                return Ordering.class.equiv((Ordering)this, (Object)x, (Object)y);
            }

            public Object max(Object x, Object y) {
                return Ordering.class.max((Ordering)this, (Object)x, (Object)y);
            }

            public Object min(Object x, Object y) {
                return Ordering.class.min((Ordering)this, (Object)x, (Object)y);
            }

            public Ordering<Object> reverse() {
                return Ordering.class.reverse((Ordering)this);
            }

            public <U> Ordering<U> on(Function1<U, Object> f) {
                return Ordering.class.on((Ordering)this, f);
            }

            public Ordering.Ops mkOrderingOps(Object lhs) {
                return Ordering.class.mkOrderingOps((Ordering)this, (Object)lhs);
            }

            public int compare(byte x, byte y) {
                return UnsignedBytes.compare((byte)x, (byte)y);
            }
            {
                PartialOrdering.class.$init$((PartialOrdering)this);
                Ordering.class.$init$((Ordering)this);
            }
        };
    }
}

