/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.text;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.nio.charset.StandardCharsets;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.CSVRecord;
import org.locationtech.geomesa.utils.date.DateUtils$;
import org.locationtech.geomesa.utils.io.WithClose$;
import org.locationtech.geomesa.utils.text.StringSerialization$;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar;

public final class StringSerialization$
implements LazyLogging {
    public static final StringSerialization$ MODULE$;
    private final DateTimeFormatter org$locationtech$geomesa$utils$text$StringSerialization$$dateFormat;
    private final Pattern AlphaNumericPattern;
    private final IndexedSeq<Object> org$locationtech$geomesa$utils$text$StringSerialization$$AlphaNumeric;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new StringSerialization$();
    }

    private Logger logger$lzycompute() {
        StringSerialization$ stringSerialization$ = this;
        synchronized (stringSerialization$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public DateTimeFormatter org$locationtech$geomesa$utils$text$StringSerialization$$dateFormat() {
        return this.org$locationtech$geomesa$utils$text$StringSerialization$$dateFormat;
    }

    private Pattern AlphaNumericPattern() {
        return this.AlphaNumericPattern;
    }

    public IndexedSeq<Object> org$locationtech$geomesa$utils$text$StringSerialization$$AlphaNumeric() {
        return this.org$locationtech$geomesa$utils$text$StringSerialization$$AlphaNumeric;
    }

    public String encodeSeq(Seq<String> values) {
        String string2;
        if (values.isEmpty()) {
            string2 = "";
        } else {
            java.lang.StringBuilder sb = new java.lang.StringBuilder();
            CSVPrinter printer = new CSVPrinter((Appendable)sb, CSVFormat.DEFAULT);
            values.foreach((Function1)new Serializable(printer){
                public static final long serialVersionUID = 0L;
                private final CSVPrinter printer$1;

                public final void apply(Object x$1) {
                    this.printer$1.print(x$1);
                }
                {
                    this.printer$1 = printer$1;
                }
            });
            string2 = sb.toString();
        }
        return string2;
    }

    public Seq<String> decodeSeq(String values) {
        return values.isEmpty() ? (Seq)Seq$.MODULE$.empty() : (Seq)WithClose$.MODULE$.apply(CSVParser.parse((String)values, (CSVFormat)CSVFormat.DEFAULT), new Serializable(){
            public static final long serialVersionUID = 0L;

            public final List<String> apply(CSVParser x$1) {
                return ((TraversableOnce)JavaConverters$.MODULE$.asScalaIteratorConverter(((CSVRecord)x$1.iterator().next()).iterator()).asScala()).toList();
            }
        });
    }

    public String encodeMap(Map<String, String> values) {
        return this.encodeSeq((Seq<String>)((Seq)values.toSeq().flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Seq<String> apply(Tuple2<String, String> x0$1) {
                Tuple2<String, String> tuple2 = x0$1;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    Seq seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{k, v}));
                    return seq;
                }
                throw new MatchError(tuple2);
            }
        }, Seq$.MODULE$.canBuildFrom())));
    }

    public scala.collection.immutable.Map<String, String> decodeMap(String values) {
        return this.decodeSeq(values).grouped(2).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, String> apply(Seq<String> x0$2) {
                Seq<String> seq = x0$2;
                Some some = Seq$.MODULE$.unapplySeq(seq);
                if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                    String k = (String)((SeqLike)some.get()).apply(0);
                    String v = (String)((SeqLike)some.get()).apply(1);
                    Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)v);
                    return tuple2;
                }
                throw new MatchError(seq);
            }
        }).toMap(Predef$.MODULE$.$conforms());
    }

    public String encodeSeqMap(scala.collection.immutable.Map<String, Seq<Object>> map2) {
        java.lang.StringBuilder sb = new java.lang.StringBuilder();
        CSVPrinter printer = new CSVPrinter((Appendable)sb, CSVFormat.DEFAULT);
        map2.foreach((Function1)new Serializable(printer){
            public static final long serialVersionUID = 0L;
            public final CSVPrinter printer$2;

            public final void apply(Tuple2<String, Seq<Object>> x0$3) {
                Tuple2<String, Seq<Object>> tuple2 = x0$3;
                if (tuple2 != null) {
                    Some some;
                    String k = (String)tuple2._1();
                    Seq v = (Seq)tuple2._2();
                    Option option2 = v.headOption();
                    Seq seq = option2 instanceof Some && (some = (Some)option2).x() instanceof Date ? (Seq)v.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(Object d) {
                            return ZonedDateTime.ofInstant(DateUtils$.MODULE$.toInstant((Date)d), ZoneOffset.UTC).format(StringSerialization$.MODULE$.org$locationtech$geomesa$utils$text$StringSerialization$$dateFormat());
                        }
                    }, Seq$.MODULE$.canBuildFrom()) : v;
                    Seq strings = seq;
                    this.printer$2.print((Object)k);
                    strings.foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.encodeSeqMap.1 $outer;

                        public final void apply(Object x$1) {
                            this.$outer.printer$2.print(x$1);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                    this.printer$2.println();
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.printer$2 = printer$2;
            }
        });
        return sb.toString();
    }

    public scala.collection.immutable.Map<String, Object[]> decodeSeqMap(SimpleFeatureType sft, String encoded) {
        Buffer bindings = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(sft.getAttributeDescriptors()).asScala()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Class<Object>> apply(AttributeDescriptor d) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)d.getLocalName()), (Object)d.getType().getBinding());
            }
        }, Buffer$.MODULE$.canBuildFrom());
        return this.decodeSeqMap(encoded, bindings.toMap(Predef$.MODULE$.$conforms()));
    }

    public scala.collection.immutable.Map<String, Object[]> decodeSeqMap(String encoded, scala.collection.immutable.Map<String, Class<?>> bindings) {
        return (scala.collection.immutable.Map)WithClose$.MODULE$.apply(CSVParser.parse((String)encoded, (CSVFormat)CSVFormat.DEFAULT), new Serializable(bindings){
            public static final long serialVersionUID = 0L;
            public final scala.collection.immutable.Map bindings$1;

            public final scala.collection.immutable.Map<String, Object[]> apply(CSVParser parser) {
                return ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(parser.iterator()).asScala()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.decodeSeqMap.1 $outer;

                    /*
                     * Unable to fully structure code
                     */
                    public final Tuple2<String, Object[]> apply(CSVRecord record) {
                        block5: {
                            block10: {
                                block9: {
                                    block8: {
                                        block7: {
                                            block6: {
                                                block4: {
                                                    iter = (Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(record.iterator()).asScala();
                                                    key = (String)iter.next();
                                                    var5_4 = false;
                                                    var6_5 = null;
                                                    var7_6 = this.$outer.bindings$1.get((Object)key);
                                                    if (!(var7_6 instanceof Some)) break block4;
                                                    var5_4 = true;
                                                    var6_5 = (Some)var7_6;
                                                    v0 = c = (Class)var6_5.x();
                                                    var9_8 = String.class;
                                                    if (v0 != null ? v0.equals(var9_8) == false : var9_8 != null) break block4;
                                                    var10_9 = (Object[])iter.toArray(ClassTag$.MODULE$.AnyRef());
                                                    break block5;
                                                }
                                                if (!var5_4) break block6;
                                                v1 = c = (Class)var6_5.x();
                                                var12_11 = Integer.class;
                                                if (v1 != null ? v1.equals(var12_11) == false : var12_11 != null) break block6;
                                                var10_9 = (Object[])iter.map((Function1)new Serializable(this){
                                                    public static final long serialVersionUID = 0L;

                                                    public final Integer apply(String x$1) {
                                                        return Integer.valueOf(x$1);
                                                    }
                                                }).toArray(ClassTag$.MODULE$.AnyRef());
                                                break block5;
                                            }
                                            if (!var5_4) break block7;
                                            v2 = c = (Class)var6_5.x();
                                            var14_13 = Long.class;
                                            if (v2 != null ? v2.equals(var14_13) == false : var14_13 != null) break block7;
                                            var10_9 = (Object[])iter.map((Function1)new Serializable(this){
                                                public static final long serialVersionUID = 0L;

                                                public final Long apply(String x$1) {
                                                    return Long.valueOf(x$1);
                                                }
                                            }).toArray(ClassTag$.MODULE$.AnyRef());
                                            break block5;
                                        }
                                        if (!var5_4) break block8;
                                        v3 = c = (Class)var6_5.x();
                                        var16_15 = Float.class;
                                        if (v3 != null ? v3.equals(var16_15) == false : var16_15 != null) break block8;
                                        var10_9 = (Object[])iter.map((Function1)new Serializable(this){
                                            public static final long serialVersionUID = 0L;

                                            public final Float apply(String x$1) {
                                                return Float.valueOf(x$1);
                                            }
                                        }).toArray(ClassTag$.MODULE$.AnyRef());
                                        break block5;
                                    }
                                    if (!var5_4) break block9;
                                    v4 = c = (Class)var6_5.x();
                                    var18_17 = Double.class;
                                    if (v4 != null ? v4.equals(var18_17) == false : var18_17 != null) break block9;
                                    var10_9 = (Object[])iter.map((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final Double apply(String x$1) {
                                            return Double.valueOf(x$1);
                                        }
                                    }).toArray(ClassTag$.MODULE$.AnyRef());
                                    break block5;
                                }
                                if (!var5_4 || !Date.class.isAssignableFrom(c = (Class)var6_5.x())) break block10;
                                var10_9 = (Object[])iter.map((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final Date apply(String v) {
                                        return Date.from(ZonedDateTime.parse(v, StringSerialization$.MODULE$.org$locationtech$geomesa$utils$text$StringSerialization$$dateFormat()).toInstant());
                                    }
                                }).toArray(ClassTag$.MODULE$.AnyRef());
                                break block5;
                            }
                            if (!var5_4) ** GOTO lbl-1000
                            v5 = c = (Class)var6_5.x();
                            var21_20 = Boolean.class;
                            if (!(v5 != null ? v5.equals(var21_20) == false : var21_20 != null)) {
                                var10_9 = (Object[])iter.map((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final Boolean apply(String x$1) {
                                        return Boolean.valueOf(x$1);
                                    }
                                }).toArray(ClassTag$.MODULE$.AnyRef());
                            } else lbl-1000:
                            // 2 sources

                            {
                                if (StringSerialization$.MODULE$.logger().underlying().isWarnEnabled()) {
                                    StringSerialization$.MODULE$.logger().underlying().warn("No conversion defined for encoded attribute '{}' of type {}", new Object[]{key, var7_6.orNull(Predef$.MODULE$.$conforms())});
                                    v6 = BoxedUnit.UNIT;
                                } else {
                                    v6 = BoxedUnit.UNIT;
                                }
                                var10_9 = (Object[])iter.toArray(ClassTag$.MODULE$.AnyRef());
                            }
                        }
                        values = var10_9;
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)values);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }).toMap(Predef$.MODULE$.$conforms());
            }
            {
                this.bindings$1 = bindings$1;
            }
        });
    }

    public String alphaNumericSafeString(String input) {
        String string2;
        if (this.AlphaNumericPattern().matcher(input).matches()) {
            string2 = input;
        } else {
            StringBuilder sb = new StringBuilder();
            new StringOps(Predef$.MODULE$.augmentString(input)).foreach((Function1)new Serializable(sb){
                public static final long serialVersionUID = 0L;
                private final StringBuilder sb$1;

                public final StringBuilder apply(char c) {
                    StringBuilder stringBuilder;
                    if (StringSerialization$.MODULE$.org$locationtech$geomesa$utils$text$StringSerialization$$AlphaNumeric().contains((Object)BoxesRunTime.boxToCharacter((char)c))) {
                        stringBuilder = this.sb$1.append(c);
                    } else {
                        char[] hex = Hex.encodeHex((byte[])((Object)BoxesRunTime.boxToCharacter((char)c)).toString().getBytes(StandardCharsets.UTF_8));
                        String encoded = Predef$.MODULE$.charArrayOps(hex).grouped(2).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply(char[] arr) {
                                return new StringBuilder().append((Object)"_").append((Object)BoxesRunTime.boxToCharacter((char)arr[0])).append((Object)BoxesRunTime.boxToCharacter((char)arr[1])).toString();
                            }
                        }).mkString().toLowerCase(Locale.US);
                        stringBuilder = this.sb$1.append(encoded);
                    }
                    return stringBuilder;
                }
                {
                    this.sb$1 = sb$1;
                }
            });
            string2 = sb.toString();
        }
        return string2;
    }

    public String decodeAlphaNumericSafeString(String input) {
        String string2;
        if (this.AlphaNumericPattern().matcher(input).matches()) {
            string2 = input;
        } else {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < input.length(); ++i) {
                char c = input.charAt(i);
                StringBuilder stringBuilder = c != '_' ? sb.append(c) : sb.append((Object)Hex.decodeHex((char[])new char[]{input.charAt((i += 2) - 1), input.charAt(i)}));
            }
            string2 = sb.toString();
        }
        return string2;
    }

    private StringSerialization$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
        this.org$locationtech$geomesa$utils$text$StringSerialization$$dateFormat = DateTimeFormatter.ISO_OFFSET_DATE_TIME.withZone(ZoneOffset.UTC);
        this.AlphaNumericPattern = Pattern.compile("^[a-zA-Z0-9]+$");
        this.org$locationtech$geomesa$utils$text$StringSerialization$$AlphaNumeric = (IndexedSeq)((TraversableLike)new RichChar(Predef$.MODULE$.charWrapper('a')).to((Object)BoxesRunTime.boxToCharacter((char)'z')).$plus$plus((GenTraversableOnce)new RichChar(Predef$.MODULE$.charWrapper('A')).to((Object)BoxesRunTime.boxToCharacter((char)'Z')), IndexedSeq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)new RichChar(Predef$.MODULE$.charWrapper('0')).to((Object)BoxesRunTime.boxToCharacter((char)'9')), IndexedSeq$.MODULE$.canBuildFrom());
    }
}

