/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.column.values.rle;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.parquet.bytes.ByteBufferInputStream;
import org.apache.parquet.bytes.BytesUtils;
import org.apache.parquet.column.values.ValuesReader;
import org.apache.parquet.column.values.rle.RunLengthBitPackingHybridDecoder;
import org.apache.parquet.io.ParquetDecodingException;

public class RunLengthBitPackingHybridValuesReader
extends ValuesReader {
    private final int bitWidth;
    private RunLengthBitPackingHybridDecoder decoder;
    private int nextOffset;

    public RunLengthBitPackingHybridValuesReader(int bitWidth) {
        this.bitWidth = bitWidth;
    }

    @Override
    public void initFromPage(int valueCountL, ByteBuffer page, int offset) throws IOException {
        ByteBufferInputStream in = new ByteBufferInputStream(page, offset, page.limit() - offset);
        int length = BytesUtils.readIntLittleEndian((InputStream)in);
        this.decoder = new RunLengthBitPackingHybridDecoder(this.bitWidth, (InputStream)in);
        this.nextOffset = offset + length + 4;
    }

    @Override
    public int getNextOffset() {
        return this.nextOffset;
    }

    @Override
    public int readInteger() {
        try {
            return this.decoder.readInt();
        }
        catch (IOException e) {
            throw new ParquetDecodingException(e);
        }
    }

    @Override
    public boolean readBoolean() {
        return this.readInteger() != 0;
    }

    @Override
    public void skip() {
        this.readInteger();
    }
}

