/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml;

import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.gml.SubHandler;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.TopologyException;

public class SubHandlerLinearRing
extends SubHandler {
    static final Logger LOGGER = Logging.getLogger(SubHandlerLinearRing.class);
    private ArrayList coordinateList = new ArrayList();

    @Override
    public void addCoordinate(Coordinate coordinate) {
        this.coordinateList.add(coordinate);
    }

    @Override
    public boolean isComplete(String message) {
        if (this.coordinateList.size() > 1) {
            Coordinate firstCoordinate = (Coordinate)this.coordinateList.get(0);
            Coordinate lastCoordinate = (Coordinate)this.coordinateList.get(this.coordinateList.size() - 1);
            return lastCoordinate.equals2D(firstCoordinate);
        }
        return false;
    }

    @Override
    public Geometry create(GeometryFactory geometryFactory) {
        try {
            Coordinate[] coords = this.coordinateList.toArray(new Coordinate[this.coordinateList.size()]);
            LinearRing ring = geometryFactory.createLinearRing(coords);
            ring.setUserData((Object)this.getSRS());
            ring.setSRID(this.getSRID());
            return ring;
        }
        catch (TopologyException e) {
            LOGGER.log(Level.FINE, "Caught Topology exception in GMLLinearRingHandler", e);
            return null;
        }
    }
}

