/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.parquet.io;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.hadoop.api.InitContext;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;
import org.locationtech.geomesa.features.serialization.ObjectType$;
import org.locationtech.geomesa.features.serialization.TwkbSerialization;
import org.locationtech.geomesa.fs.storage.common.jobs.StorageConfiguration$;
import org.locationtech.geomesa.parquet.io.SimpleFeatureParquetSchema;
import org.locationtech.geomesa.parquet.io.SimpleFeatureParquetSchema$;
import org.locationtech.geomesa.parquet.io.SimpleFeatureParquetSchema$Binding$;
import org.locationtech.geomesa.parquet.io.SimpleFeatureParquetSchemaV0$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$;
import org.locationtech.geomesa.utils.text.StringSerialization$;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.NotImplementedError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class SimpleFeatureParquetSchema$
implements Serializable {
    public static final SimpleFeatureParquetSchema$ MODULE$;
    private final String FeatureIdField;
    private final String SchemaVersionKey;
    private final int CurrentSchemaVersion;
    private final String GeometryColumnX;
    private final String GeometryColumnY;

    static {
        new SimpleFeatureParquetSchema$();
    }

    public String FeatureIdField() {
        return this.FeatureIdField;
    }

    public String SchemaVersionKey() {
        return this.SchemaVersionKey;
    }

    public int CurrentSchemaVersion() {
        return this.CurrentSchemaVersion;
    }

    public String GeometryColumnX() {
        return this.GeometryColumnX;
    }

    public String GeometryColumnY() {
        return this.GeometryColumnY;
    }

    public Option<SimpleFeatureParquetSchema> read(InitContext context) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(context.getKeyValueMetadata()).asScala()).foreach((Function1)new Serializable(metadata){
            public static final long serialVersionUID = 0L;
            private final HashMap metadata$1;

            public final Object apply(Tuple2<String, Set<String>> x0$1) {
                Tuple2<String, Set<String>> tuple2 = x0$1;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    Set v = (Set)tuple2._2();
                    BoxedUnit boxedUnit = v.isEmpty() ? BoxedUnit.UNIT : this.metadata$1.put(k, v.iterator().next());
                    return boxedUnit;
                }
                throw new MatchError(tuple2);
            }
            {
                this.metadata$1 = metadata$1;
            }
        });
        Configuration conf = context.getConfiguration();
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{StorageConfiguration$.MODULE$.SftNameKey(), StorageConfiguration$.MODULE$.SftSpecKey(), this.SchemaVersionKey()}))).foreach((Function1)new Serializable(metadata, conf){
            public static final long serialVersionUID = 0L;
            private final HashMap metadata$1;
            private final Configuration conf$1;

            public final Object apply(String key) {
                String value = this.conf$1.get(key);
                return value == null ? BoxedUnit.UNIT : this.metadata$1.put(key, value);
            }
            {
                this.metadata$1 = metadata$1;
                this.conf$1 = conf$1;
            }
        });
        return this.apply(metadata);
    }

    public Option<SimpleFeatureParquetSchema> read(FileMetaData footer) {
        return this.apply(footer.getKeyValueMetaData());
    }

    public Option<SimpleFeatureParquetSchema> write(Configuration conf) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put(this.SchemaVersionKey(), ((Object)BoxesRunTime.boxToInteger((int)this.CurrentSchemaVersion())).toString());
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{StorageConfiguration$.MODULE$.SftNameKey(), StorageConfiguration$.MODULE$.SftSpecKey()}))).foreach((Function1)new Serializable(conf, metadata){
            public static final long serialVersionUID = 0L;
            private final Configuration conf$2;
            private final HashMap metadata$3;

            public final Object apply(String key) {
                String value = this.conf$2.get(key);
                return value == null ? BoxedUnit.UNIT : this.metadata$3.put(key, value);
            }
            {
                this.conf$2 = conf$2;
                this.metadata$3 = metadata$3;
            }
        });
        return this.apply(metadata);
    }

    private Option<SimpleFeatureParquetSchema> apply(Map<String, String> metadata) {
        return Option$.MODULE$.apply((Object)metadata.get(StorageConfiguration$.MODULE$.SftNameKey())).flatMap((Function1)new Serializable(metadata){
            public static final long serialVersionUID = 0L;
            public final Map metadata$2;

            public final Option<SimpleFeatureParquetSchema> apply(String name) {
                return Option$.MODULE$.apply(this.metadata$2.get(StorageConfiguration$.MODULE$.SftSpecKey())).map((Function1)new Serializable(this, name){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.apply.1 $outer;
                    private final String name$1;

                    public final SimpleFeatureParquetSchema apply(String spec) {
                        SimpleFeatureParquetSchema simpleFeatureParquetSchema;
                        SimpleFeatureType sft = SimpleFeatureTypes$.MODULE$.createType(this.name$1, spec);
                        int n = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply(this.$outer.metadata$2.get(SimpleFeatureParquetSchema$.MODULE$.SchemaVersionKey())).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final int apply(String x$1) {
                                return new StringOps(Predef$.MODULE$.augmentString(x$1)).toInt();
                            }
                        }).getOrElse((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final int apply() {
                                return this.apply$mcI$sp();
                            }

                            public int apply$mcI$sp() {
                                return 0;
                            }
                        }));
                        switch (n) {
                            default: {
                                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unknown SimpleFeatureParquetSchema version: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)n)})));
                            }
                            case 0: {
                                simpleFeatureParquetSchema = new SimpleFeatureParquetSchema(sft, SimpleFeatureParquetSchemaV0$.MODULE$.apply(sft));
                                break;
                            }
                            case 1: {
                                simpleFeatureParquetSchema = new SimpleFeatureParquetSchema(sft, SimpleFeatureParquetSchema$.MODULE$.org$locationtech$geomesa$parquet$io$SimpleFeatureParquetSchema$$schema(sft));
                            }
                        }
                        return simpleFeatureParquetSchema;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.name$1 = name$1;
                    }
                });
            }
            {
                this.metadata$2 = metadata$2;
            }
        });
    }

    public MessageType org$locationtech$geomesa$parquet$io$SimpleFeatureParquetSchema$$schema(SimpleFeatureType sft) {
        PrimitiveType id = (PrimitiveType)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as(OriginalType.UTF8).named(this.FeatureIdField());
        Buffer fields = (Buffer)((SeqLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(sft.getAttributeDescriptors()).asScala()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Type apply(AttributeDescriptor descriptor) {
                return SimpleFeatureParquetSchema$.MODULE$.org$locationtech$geomesa$parquet$io$SimpleFeatureParquetSchema$$schema(descriptor);
            }
        }, Buffer$.MODULE$.canBuildFrom())).$colon$plus((Object)id, Buffer$.MODULE$.canBuildFrom());
        return new MessageType(StringSerialization$.MODULE$.alphaNumericSafeString(sft.getTypeName()), (List)JavaConverters$.MODULE$.bufferAsJavaListConverter(fields).asJava());
    }

    public Type org$locationtech$geomesa$parquet$io$SimpleFeatureParquetSchema$$schema(AttributeDescriptor descriptor) {
        Types.Builder<?, ? extends Type> builder;
        Seq bindings = ObjectType$.MODULE$.selectType(descriptor);
        Enumeration.Value value = (Enumeration.Value)bindings.head();
        Enumeration.Value value2 = ObjectType$.MODULE$.GEOMETRY();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            builder = this.geometry((Enumeration.Value)bindings.apply(1));
        } else {
            Enumeration.Value value4 = ObjectType$.MODULE$.LIST();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                builder = SimpleFeatureParquetSchema$Binding$.MODULE$.apply((Enumeration.Value)bindings.apply(1)).list();
            } else {
                Enumeration.Value value6 = ObjectType$.MODULE$.MAP();
                Enumeration.Value value7 = value;
                builder = !(value6 != null ? !value6.equals(value7) : value7 != null) ? SimpleFeatureParquetSchema$Binding$.MODULE$.apply((Enumeration.Value)bindings.apply(1)).key((Enumeration.Value)bindings.apply(2)) : SimpleFeatureParquetSchema$Binding$.MODULE$.apply(value).primitive();
            }
        }
        Types.Builder<?, ? extends Type> builder2 = builder;
        return (Type)builder2.named(StringSerialization$.MODULE$.alphaNumericSafeString(descriptor.getLocalName()));
    }

    private Types.Builder<?, ? extends Type> geometry(Enumeration.Value binding) {
        Enumeration.Value value;
        block10: {
            Types.GroupBuilder groupBuilder;
            block5: {
                Types.GroupBuilder group;
                block9: {
                    block8: {
                        block7: {
                            block6: {
                                block4: {
                                    group = Types.buildGroup((Type.Repetition)Type.Repetition.OPTIONAL);
                                    value = binding;
                                    Enumeration.Value value2 = ObjectType$.MODULE$.POINT();
                                    Enumeration.Value value3 = value;
                                    if (value2 != null ? !value2.equals(value3) : value3 != null) break block4;
                                    groupBuilder = (Types.GroupBuilder)((Types.BaseGroupBuilder)((Types.BaseGroupBuilder)group.id((int)TwkbSerialization.GeometryBytes$.MODULE$.TwkbPoint())).required(PrimitiveType.PrimitiveTypeName.DOUBLE).named(this.GeometryColumnX())).required(PrimitiveType.PrimitiveTypeName.DOUBLE).named(this.GeometryColumnY());
                                    break block5;
                                }
                                Enumeration.Value value4 = ObjectType$.MODULE$.LINESTRING();
                                Enumeration.Value value5 = value;
                                if (value4 != null ? !value4.equals(value5) : value5 != null) break block6;
                                groupBuilder = (Types.GroupBuilder)((Types.BaseGroupBuilder)((Types.BaseGroupBuilder)group.id((int)TwkbSerialization.GeometryBytes$.MODULE$.TwkbLineString())).repeated(PrimitiveType.PrimitiveTypeName.DOUBLE).named(this.GeometryColumnX())).repeated(PrimitiveType.PrimitiveTypeName.DOUBLE).named(this.GeometryColumnY());
                                break block5;
                            }
                            Enumeration.Value value6 = ObjectType$.MODULE$.MULTIPOINT();
                            Enumeration.Value value7 = value;
                            if (value6 != null ? !value6.equals(value7) : value7 != null) break block7;
                            groupBuilder = (Types.GroupBuilder)((Types.BaseGroupBuilder)((Types.BaseGroupBuilder)group.id((int)TwkbSerialization.GeometryBytes$.MODULE$.TwkbMultiPoint())).repeated(PrimitiveType.PrimitiveTypeName.DOUBLE).named(this.GeometryColumnX())).repeated(PrimitiveType.PrimitiveTypeName.DOUBLE).named(this.GeometryColumnY());
                            break block5;
                        }
                        Enumeration.Value value8 = ObjectType$.MODULE$.POLYGON();
                        Enumeration.Value value9 = value;
                        if (value8 != null ? !value8.equals(value9) : value9 != null) break block8;
                        groupBuilder = (Types.GroupBuilder)((Types.BaseGroupBuilder)((Types.BaseGroupBuilder)group.id((int)TwkbSerialization.GeometryBytes$.MODULE$.TwkbPolygon())).requiredList().element(PrimitiveType.PrimitiveTypeName.DOUBLE, Type.Repetition.REPEATED).named(this.GeometryColumnX())).requiredList().element(PrimitiveType.PrimitiveTypeName.DOUBLE, Type.Repetition.REPEATED).named(this.GeometryColumnY());
                        break block5;
                    }
                    Enumeration.Value value10 = ObjectType$.MODULE$.MULTILINESTRING();
                    Enumeration.Value value11 = value;
                    if (value10 != null ? !value10.equals(value11) : value11 != null) break block9;
                    groupBuilder = (Types.GroupBuilder)((Types.BaseGroupBuilder)((Types.BaseGroupBuilder)group.id((int)TwkbSerialization.GeometryBytes$.MODULE$.TwkbMultiLineString())).requiredList().element(PrimitiveType.PrimitiveTypeName.DOUBLE, Type.Repetition.REPEATED).named(this.GeometryColumnX())).requiredList().element(PrimitiveType.PrimitiveTypeName.DOUBLE, Type.Repetition.REPEATED).named(this.GeometryColumnY());
                    break block5;
                }
                Enumeration.Value value12 = ObjectType$.MODULE$.MULTIPOLYGON();
                Enumeration.Value value13 = value;
                if (value12 != null ? !value12.equals(value13) : value13 != null) break block10;
                groupBuilder = (Types.GroupBuilder)((Types.BaseGroupBuilder)((Types.BaseGroupBuilder)group.id((int)TwkbSerialization.GeometryBytes$.MODULE$.TwkbMultiPolygon())).requiredList().requiredListElement().element(PrimitiveType.PrimitiveTypeName.DOUBLE, Type.Repetition.REPEATED).named(this.GeometryColumnX())).requiredList().requiredListElement().element(PrimitiveType.PrimitiveTypeName.DOUBLE, Type.Repetition.REPEATED).named(this.GeometryColumnY());
            }
            return groupBuilder;
        }
        Enumeration.Value value14 = ObjectType$.MODULE$.GEOMETRY_COLLECTION();
        Enumeration.Value value15 = value;
        if (!(value14 != null ? !value14.equals(value15) : value15 != null)) {
            throw new NotImplementedError("Geometry collections are not supported");
        }
        throw new NotImplementedError(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No mapping defined for geometry type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{binding})));
    }

    public SimpleFeatureParquetSchema apply(SimpleFeatureType sft, MessageType schema) {
        return new SimpleFeatureParquetSchema(sft, schema);
    }

    public Option<Tuple2<SimpleFeatureType, MessageType>> unapply(SimpleFeatureParquetSchema x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple2((Object)x$0.sft(), (Object)x$0.schema()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private SimpleFeatureParquetSchema$() {
        MODULE$ = this;
        this.FeatureIdField = "__fid__";
        this.SchemaVersionKey = "geomesa.parquet.version";
        this.CurrentSchemaVersion = 1;
        this.GeometryColumnX = "x";
        this.GeometryColumnY = "y";
    }
}

