/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.fs.storage.orc.jobs;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.orc.OrcFile;
import org.apache.orc.TypeDescription;
import org.apache.orc.mapred.OrcStruct;
import org.apache.orc.mapreduce.OrcMapreduceRecordWriter;
import org.apache.orc.mapreduce.OrcOutputFormat;
import org.locationtech.geomesa.fs.storage.common.jobs.StorageConfiguration$;
import org.locationtech.geomesa.fs.storage.orc.jobs.OrcSimpleFeatureOutputFormat$;
import org.locationtech.geomesa.fs.storage.orc.utils.OrcOutputFormatWriter;
import org.locationtech.geomesa.fs.storage.orc.utils.OrcOutputFormatWriter$;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005]e\u0001B\u0001\u0003\u0001E\u0011Ad\u0014:d'&l\u0007\u000f\\3GK\u0006$XO]3PkR\u0004X\u000f\u001e$pe6\fGO\u0003\u0002\u0004\t\u0005!!n\u001c2t\u0015\t)a!A\u0002pe\u000eT!a\u0002\u0005\u0002\u000fM$xN]1hK*\u0011\u0011BC\u0001\u0003MNT!a\u0003\u0007\u0002\u000f\u001d,w.\\3tC*\u0011QBD\u0001\rY>\u001c\u0017\r^5p]R,7\r\u001b\u0006\u0002\u001f\u0005\u0019qN]4\u0004\u0001M\u0011\u0001A\u0005\t\u0005'y\u0001\u0003&D\u0001\u0015\u0015\t)b#\u0001\u0004pkR\u0004X\u000f\u001e\u0006\u0003/a\t1\u0001\\5c\u0015\tI\"$A\u0005nCB\u0014X\rZ;dK*\u00111\u0004H\u0001\u0007Q\u0006$wn\u001c9\u000b\u0005uq\u0011AB1qC\u000eDW-\u0003\u0002 )\t\u0001b)\u001b7f\u001fV$\b/\u001e;G_Jl\u0017\r\u001e\t\u0003C\u0019j\u0011A\t\u0006\u0003G\u0011\nA\u0001\\1oO*\tQ%\u0001\u0003kCZ\f\u0017BA\u0014#\u0005\u00111v.\u001b3\u0011\u0005%\u0002T\"\u0001\u0016\u000b\u0005-b\u0013AB:j[BdWM\u0003\u0002.]\u00059a-Z1ukJ,'BA\u0018\u000f\u0003\u001dy\u0007/\u001a8hSNL!!\r\u0016\u0003\u001bMKW\u000e\u001d7f\r\u0016\fG/\u001e:f\u0011\u0015\u0019\u0004\u0001\"\u00015\u0003\u0019a\u0014N\\5u}Q\tQ\u0007\u0005\u00027\u00015\t!\u0001C\u00049\u0001\t\u0007I\u0011B\u001d\u0002\u0011\u0011,G.Z4bi\u0016,\u0012A\u000f\t\u0004wy\u0002U\"\u0001\u001f\u000b\u0005ei$BA\u0003\u001d\u0013\tyDHA\bPe\u000e|U\u000f\u001e9vi\u001a{'/\\1u!\t\tE)D\u0001C\u0015\t\u0019U(\u0001\u0004nCB\u0014X\rZ\u0005\u0003\u000b\n\u0013\u0011b\u0014:d'R\u0014Xo\u0019;\t\r\u001d\u0003\u0001\u0015!\u0003;\u0003%!W\r\\3hCR,\u0007\u0005C\u0003J\u0001\u0011\u0005!*A\bhKR\u0014VmY8sI^\u0013\u0018\u000e^3s)\rYu\n\u0016\t\u0005\u00196\u0003\u0003&D\u0001\u0019\u0013\tq\u0005D\u0001\u0007SK\u000e|'\u000fZ,sSR,'\u000fC\u0003Q\u0011\u0002\u0007\u0011+A\u0004d_:$X\r\u001f;\u0011\u00051\u0013\u0016BA*\u0019\u0005I!\u0016m]6BiR,W\u000e\u001d;D_:$X\r\u001f;\t\u000bUC\u0005\u0019\u0001,\u0002\t\u0019LG.\u001a\t\u0003/fk\u0011\u0001\u0017\u0006\u0003\u0013iI!A\u0017-\u0003\tA\u000bG\u000f\u001b\u0005\u0006\u0013\u0002!\t\u0005\u0018\u000b\u0003\u0017vCQ\u0001U.A\u0002ECQa\u0018\u0001\u0005B\u0001\f!cZ3u\t\u00164\u0017-\u001e7u/>\u00148NR5mKR\u0019a+\u00192\t\u000bAs\u0006\u0019A)\t\u000b\rt\u0006\u0019\u00013\u0002\u0013\u0015DH/\u001a8tS>t\u0007CA3l\u001d\t1\u0017.D\u0001h\u0015\u0005A\u0017!B:dC2\f\u0017B\u00016h\u0003\u0019\u0001&/\u001a3fM&\u0011A.\u001c\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005)<\u0007\"B%\u0001\t\u0013yGcA&qc\")\u0001K\u001ca\u0001#\")!O\u001ca\u0001g\u0006IqN]2Xe&$XM\u001d\t\u0005\u00196#\b\t\u0005\u0002vq6\taO\u0003\u0002x5\u0005\u0011\u0011n\\\u0005\u0003sZ\u0014ABT;mY^\u0013\u0018\u000e^1cY\u0016<Qa\u001f\u0002\t\u0002q\fAd\u0014:d'&l\u0007\u000f\\3GK\u0006$XO]3PkR\u0004X\u000f\u001e$pe6\fG\u000f\u0005\u00027{\u001a)\u0011A\u0001E\u0001}N\u0011Qp \t\u0004M\u0006\u0005\u0011bAA\u0002O\n1\u0011I\\=SK\u001aDaaM?\u0005\u0002\u0005\u001dA#\u0001?\t\u000f\u0005-Q\u0010\"\u0001\u0002\u000e\u0005q1/\u001a;EKN\u001c'/\u001b9uS>tGCBA\b\u0003+\t\u0019\u0003E\u0002g\u0003#I1!a\u0005h\u0005\u0011)f.\u001b;\t\u0011\u0005]\u0011\u0011\u0002a\u0001\u00033\tAaY8oMB!\u00111DA\u0010\u001b\t\tiBC\u0002\u0002\u0018iIA!!\t\u0002\u001e\ti1i\u001c8gS\u001e,(/\u0019;j_:D\u0001\"!\n\u0002\n\u0001\u0007\u0011qE\u0001\fI\u0016\u001c8M]5qi&|g\u000e\u0005\u0003\u0002*\u0005-R\"A\u001f\n\u0007\u00055RHA\bUsB,G)Z:de&\u0004H/[8o\u0011\u001d\t\t$ C\u0001\u0003g\tabZ3u\t\u0016\u001c8M]5qi&|g\u000e\u0006\u0003\u0002(\u0005U\u0002\u0002CA\f\u0003_\u0001\r!!\u0007\u0007\r\u0005eR\u0010AA\u001e\u0005=y%o\u0019*fG>\u0014Hm\u0016:ji\u0016\u00148cAA\u001c\u0017\"Y\u0011qHA\u001c\u0005\u0003\u0005\u000b\u0011BA!\u0003\r\u0019h\r\u001e\t\u0004S\u0005\r\u0013bAA#U\t\t2+[7qY\u00164U-\u0019;ve\u0016$\u0016\u0010]3\t\u0017\u0005\u0015\u0012q\u0007B\u0001B\u0003%\u0011q\u0005\u0005\nq\u0005]\"\u0011!Q\u0001\nMDqaMA\u001c\t\u0003\ti\u0005\u0006\u0005\u0002P\u0005M\u0013QKA,!\u0011\t\t&a\u000e\u000e\u0003uD\u0001\"a\u0010\u0002L\u0001\u0007\u0011\u0011\t\u0005\t\u0003K\tY\u00051\u0001\u0002(!1\u0001(a\u0013A\u0002MD!\"a\u0017\u00028\t\u0007I\u0011BA/\u0003\u00199(/\u001b;feV\u0011\u0011q\f\t\u0005\u0003C\n9'\u0004\u0002\u0002d)\u0019\u0011Q\r\u0003\u0002\u000bU$\u0018\u000e\\:\n\t\u0005%\u00141\r\u0002\u0016\u001fJ\u001cw*\u001e;qkR4uN]7bi^\u0013\u0018\u000e^3s\u0011%\ti'a\u000e!\u0002\u0013\ty&A\u0004xe&$XM\u001d\u0011\t\u0015\u0005E\u0014q\u0007b\u0001\n\u0013\t\u0019(A\u0002lKf,\u0012\u0001\u001e\u0005\t\u0003o\n9\u0004)A\u0005i\u0006!1.Z=!\u0011)\tY(a\u000eC\u0002\u0013%\u0011QP\u0001\u0007gR\u0014Xo\u0019;\u0016\u0003\u0001C\u0001\"!!\u00028\u0001\u0006I\u0001Q\u0001\bgR\u0014Xo\u0019;!\u0011!\t))a\u000e\u0005B\u0005\u001d\u0015!B<sSR,GCBA\b\u0003\u0013\u000bY\tC\u0004\u0002r\u0005\r\u0005\u0019\u0001\u0011\t\u000f\u00055\u00151\u0011a\u0001Q\u0005)a/\u00197vK\"A\u0011\u0011SA\u001c\t\u0003\n\u0019*A\u0003dY>\u001cX\r\u0006\u0003\u0002\u0010\u0005U\u0005B\u0002)\u0002\u0010\u0002\u0007\u0011\u000b")
public class OrcSimpleFeatureOutputFormat
extends FileOutputFormat<Void, SimpleFeature> {
    private final OrcOutputFormat<OrcStruct> delegate = new OrcOutputFormat();

    public static TypeDescription getDescription(Configuration configuration) {
        return OrcSimpleFeatureOutputFormat$.MODULE$.getDescription(configuration);
    }

    public static void setDescription(Configuration configuration, TypeDescription typeDescription) {
        OrcSimpleFeatureOutputFormat$.MODULE$.setDescription(configuration, typeDescription);
    }

    private OrcOutputFormat<OrcStruct> delegate() {
        return this.delegate;
    }

    public RecordWriter<Void, SimpleFeature> getRecordWriter(TaskAttemptContext context, Path file) {
        OrcFile.WriterOptions options = org.apache.orc.mapred.OrcOutputFormat.buildOptions((Configuration)context.getConfiguration());
        OrcMapreduceRecordWriter writer = new OrcMapreduceRecordWriter(OrcFile.createWriter((Path)file, (OrcFile.WriterOptions)options));
        return this.getRecordWriter(context, (RecordWriter<NullWritable, OrcStruct>)writer);
    }

    public RecordWriter<Void, SimpleFeature> getRecordWriter(TaskAttemptContext context) {
        return this.getRecordWriter(context, (RecordWriter<NullWritable, OrcStruct>)this.delegate().getRecordWriter(context));
    }

    public Path getDefaultWorkFile(TaskAttemptContext context, String extension) {
        return this.delegate().getDefaultWorkFile(context, extension);
    }

    private RecordWriter<Void, SimpleFeature> getRecordWriter(TaskAttemptContext context, RecordWriter<NullWritable, OrcStruct> orcWriter) {
        SimpleFeatureType sft = StorageConfiguration$.MODULE$.getSft(context.getConfiguration());
        TypeDescription description = OrcSimpleFeatureOutputFormat$.MODULE$.getDescription(context.getConfiguration());
        return new OrcRecordWriter(sft, description, orcWriter);
    }

    public static class OrcRecordWriter
    extends RecordWriter<Void, SimpleFeature> {
        private final RecordWriter<NullWritable, OrcStruct> delegate;
        private final OrcOutputFormatWriter writer;
        private final NullWritable key;
        private final OrcStruct struct;

        private OrcOutputFormatWriter writer() {
            return this.writer;
        }

        private NullWritable key() {
            return this.key;
        }

        private OrcStruct struct() {
            return this.struct;
        }

        public void write(Void key, SimpleFeature value) {
            this.writer().apply(value, this.struct());
            this.delegate.write((Object)this.key(), (Object)this.struct());
        }

        public void close(TaskAttemptContext context) {
            this.delegate.close(context);
        }

        public OrcRecordWriter(SimpleFeatureType sft, TypeDescription description, RecordWriter<NullWritable, OrcStruct> delegate) {
            this.delegate = delegate;
            this.writer = OrcOutputFormatWriter$.MODULE$.apply(sft, description, OrcOutputFormatWriter$.MODULE$.apply$default$3());
            this.key = NullWritable.get();
            this.struct = new OrcStruct(description);
        }
    }
}

