/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.arrow.io;

import java.io.InputStream;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.dictionary.DictionaryProvider;
import org.apache.arrow.vector.types.FloatingPointPrecision;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.DictionaryEncoding;
import org.apache.arrow.vector.types.pojo.Field;
import org.locationtech.geomesa.arrow.features.ArrowSimpleFeature;
import org.locationtech.geomesa.arrow.filter.ArrowFilterOptimizer$;
import org.locationtech.geomesa.arrow.io.SimpleFeatureArrowFileReader;
import org.locationtech.geomesa.arrow.io.SimpleFeatureArrowFileReader$;
import org.locationtech.geomesa.arrow.io.reader.CachingSimpleFeatureArrowFileReader;
import org.locationtech.geomesa.arrow.io.reader.StreamingSimpleFeatureArrowFileReader;
import org.locationtech.geomesa.arrow.vector.ArrowAttributeReader;
import org.locationtech.geomesa.arrow.vector.ArrowAttributeReader$;
import org.locationtech.geomesa.arrow.vector.ArrowDictionary;
import org.locationtech.geomesa.arrow.vector.GeometryFields;
import org.locationtech.geomesa.arrow.vector.SimpleFeatureVector;
import org.locationtech.geomesa.arrow.vector.SimpleFeatureVector$;
import org.locationtech.geomesa.arrow.vector.SimpleFeatureVector$EncodingPrecision$;
import org.locationtech.geomesa.features.serialization.ObjectType$;
import org.locationtech.geomesa.filter.Bounds;
import org.locationtech.geomesa.filter.Bounds$;
import org.locationtech.geomesa.filter.FilterHelper$;
import org.locationtech.geomesa.utils.geotools.AttributeSpec;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureSpecParser$;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.IncludeFilter;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.package$;

public final class SimpleFeatureArrowFileReader$ {
    public static final SimpleFeatureArrowFileReader$ MODULE$;

    static {
        new SimpleFeatureArrowFileReader$();
    }

    public SimpleFeatureArrowFileReader caching(InputStream is, BufferAllocator allocator) {
        return new CachingSimpleFeatureArrowFileReader(is, allocator);
    }

    public SimpleFeatureArrowFileReader streaming(Function0<InputStream> is, BufferAllocator allocator) {
        return new StreamingSimpleFeatureArrowFileReader(is, allocator);
    }

    public scala.collection.immutable.Map<String, ArrowDictionary> loadDictionaries(Seq<Field> fields, DictionaryProvider provider) {
        Seq tuples = (Seq)fields.flatMap((Function1)new Serializable(provider){
            public static final long serialVersionUID = 0L;
            public final DictionaryProvider provider$1;

            public final Seq<Tuple2<String, ArrowDictionary>> apply(Field field) {
                return (Seq)Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)field.getDictionary())).toSeq().map((Function1)new Serializable(this, field){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.1 $outer;
                    private final Field field$1;

                    public final Tuple2<String, ArrowDictionary> apply(DictionaryEncoding dictionaryEncoding) {
                        FieldVector vector = this.$outer.provider$1.lookup(dictionaryEncoding.getId()).getVector();
                        AttributeSpec spec = SimpleFeatureSpecParser$.MODULE$.parseAttribute((String)this.field$1.getMetadata().get(SimpleFeatureVector$.MODULE$.DescriptorKey()), SimpleFeatureSpecParser$.MODULE$.parseAttribute$default$2());
                        Tuple2 tuple2 = ObjectType$.MODULE$.selectType(spec.clazz(), JavaConversions$.MODULE$.mapAsJavaMap((Map)spec.options()));
                        if (tuple2 != null) {
                            ArrowType.Int intVal;
                            Tuple2 tuple22;
                            Enumeration.Value objectType = (Enumeration.Value)tuple2._1();
                            Seq bindings = (Seq)tuple2._2();
                            Tuple2 tuple23 = tuple22 = new Tuple2((Object)objectType, (Object)bindings);
                            Enumeration.Value objectType2 = (Enumeration.Value)tuple23._1();
                            Seq bindings2 = (Seq)tuple23._2();
                            FloatingPointPrecision floatingPointPrecision = GeometryFields.precisionFromField((Field)this.field$1);
                            FloatingPointPrecision floatingPointPrecision2 = FloatingPointPrecision.DOUBLE;
                            boolean isDouble = !(floatingPointPrecision != null ? !floatingPointPrecision.equals(floatingPointPrecision2) : floatingPointPrecision2 != null);
                            Enumeration.Value geomPrecision = isDouble ? SimpleFeatureVector$EncodingPrecision$.MODULE$.Max() : SimpleFeatureVector$EncodingPrecision$.MODULE$.Min();
                            ArrowType arrowType = this.field$1.getFieldType().getType();
                            Enumeration.Value value = arrowType instanceof ArrowType.Int && (intVal = (ArrowType.Int)arrowType).getBitWidth() == 64 ? SimpleFeatureVector$EncodingPrecision$.MODULE$.Max() : SimpleFeatureVector$EncodingPrecision$.MODULE$.Min();
                            Enumeration.Value datePrecision = value;
                            SimpleFeatureVector.SimpleFeatureEncoding encoding = new SimpleFeatureVector.SimpleFeatureEncoding(false, geomPrecision, datePrecision);
                            ArrowAttributeReader attributeReader = ArrowAttributeReader$.MODULE$.apply((Seq<Enumeration.Value>)((Seq)bindings2.$plus$colon((Object)objectType2, Seq$.MODULE$.canBuildFrom())), spec.clazz(), vector, (Option<ArrowDictionary>)None$.MODULE$, encoding);
                            ArrayBuffer values = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
                            for (int i = 0; i < vector.getAccessor().getValueCount(); ++i) {
                                values.append((Seq)Predef$.MODULE$.wrapRefArray(new Object[]{attributeReader.apply(i)}));
                            }
                            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.field$1.getName()), (Object)new ArrowDictionary((Seq<Object>)values, dictionaryEncoding));
                        }
                        throw new MatchError((Object)tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.field$1 = field$1;
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }
            {
                this.provider$1 = provider$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        return tuples.toMap(Predef$.MODULE$.$conforms());
    }

    public Function1<SimpleFeatureVector, Iterator<ArrowSimpleFeature>> features(SimpleFeatureType sft, Filter filter, SimpleFeatureArrowFileReader.SkipIndicator skip, Option<Tuple2<String, Object>> sort, scala.collection.immutable.Map<String, ArrowDictionary> dictionaries) {
        Option<Tuple2<String, Object>> option;
        block4: {
            Object object;
            block3: {
                Some some;
                Tuple2 tuple2;
                Filter optimized;
                block2: {
                    optimized = ArrowFilterOptimizer$.MODULE$.rewrite(filter, sft, dictionaries);
                    option = sort;
                    if (!None$.MODULE$.equals(option)) break block2;
                    object = new Serializable(optimized){
                        public static final long serialVersionUID = 0L;
                        private final Filter optimized$1;

                        public final Iterator<ArrowSimpleFeature> apply(SimpleFeatureVector x$2) {
                            return SimpleFeatureArrowFileReader$.MODULE$.org$locationtech$geomesa$arrow$io$SimpleFeatureArrowFileReader$$features(x$2, this.optimized$1);
                        }
                        {
                            this.optimized$1 = optimized$1;
                        }
                    };
                    break block3;
                }
                if (!(option instanceof Some) || (tuple2 = (Tuple2)(some = (Some)option).x()) == null) break block4;
                String field = (String)tuple2._1();
                boolean reverse = tuple2._2$mcZ$sp();
                int i = sft.indexOf(field);
                Class binding = sft.getDescriptor(i).getType().getBinding();
                Seq bounds = FilterHelper$.MODULE$.extractAttributeBounds(filter, field, binding).values();
                object = bounds.isEmpty() ? new Serializable(optimized){
                    public static final long serialVersionUID = 0L;
                    private final Filter optimized$1;

                    public final Iterator<ArrowSimpleFeature> apply(SimpleFeatureVector x$3) {
                        return SimpleFeatureArrowFileReader$.MODULE$.org$locationtech$geomesa$arrow$io$SimpleFeatureArrowFileReader$$features(x$3, this.optimized$1);
                    }
                    {
                        this.optimized$1 = optimized$1;
                    }
                } : new Serializable(skip, optimized, reverse, i, bounds){
                    public static final long serialVersionUID = 0L;
                    private final SimpleFeatureArrowFileReader.SkipIndicator skip$1;
                    private final Filter optimized$1;
                    private final boolean reverse$1;
                    private final int i$1;
                    private final Seq bounds$1;

                    public final Iterator<ArrowSimpleFeature> apply(SimpleFeatureVector x$4) {
                        return SimpleFeatureArrowFileReader$.MODULE$.org$locationtech$geomesa$arrow$io$SimpleFeatureArrowFileReader$$sortedFeatures(x$4, this.optimized$1, this.skip$1, (Seq<Bounds<Comparable<Object>>>)this.bounds$1, this.i$1, this.reverse$1);
                    }
                    {
                        this.skip$1 = skip$1;
                        this.optimized$1 = optimized$1;
                        this.reverse$1 = reverse$1;
                        this.i$1 = i$1;
                        this.bounds$1 = bounds$1;
                    }
                };
            }
            return object;
        }
        throw new MatchError(option);
    }

    public Iterator<ArrowSimpleFeature> org$locationtech$geomesa$arrow$io$SimpleFeatureArrowFileReader$$features(SimpleFeatureVector vector, Filter filter) {
        Iterator iterator;
        int total = vector.reader().getValueCount();
        if (total == 0) {
            iterator = package$.MODULE$.Iterator().empty();
        } else {
            ArrowSimpleFeature feature = vector.reader().feature();
            Iterator all = package$.MODULE$.Iterator().range(0, total).map((Function1)new Serializable(vector, feature){
                public static final long serialVersionUID = 0L;
                private final SimpleFeatureVector vector$1;
                private final ArrowSimpleFeature feature$1;

                public final ArrowSimpleFeature apply(int i) {
                    this.vector$1.reader().load(i);
                    return this.feature$1;
                }
                {
                    this.vector$1 = vector$1;
                    this.feature$1 = feature$1;
                }
            });
            Filter filter2 = filter;
            IncludeFilter includeFilter = Filter.INCLUDE;
            iterator = !(filter2 != null ? !filter2.equals(includeFilter) : includeFilter != null) ? all : all.filter((Function1)new Serializable(filter){
                public static final long serialVersionUID = 0L;
                private final Filter filter$1;

                public final boolean apply(Object x$1) {
                    return this.filter$1.evaluate(x$1);
                }
                {
                    this.filter$1 = filter$1;
                }
            });
        }
        return iterator;
    }

    public Iterator<ArrowSimpleFeature> org$locationtech$geomesa$arrow$io$SimpleFeatureArrowFileReader$$sortedFeatures(SimpleFeatureVector vector, Filter filter, SimpleFeatureArrowFileReader.SkipIndicator skip, Seq<Bounds<Comparable<Object>>> filterBounds, int sortField, boolean reverse) {
        Iterator iterator;
        int total = vector.reader().getValueCount();
        if (total == 0 || skip.skip()) {
            iterator = package$.MODULE$.Iterator().empty();
        } else {
            Bounds currentBatchBounds;
            ArrowSimpleFeature feature = vector.reader().feature();
            vector.reader().load(0);
            Bounds.Bound lo = new Bounds.Bound(Option$.MODULE$.apply((Object)((Comparable)feature.getAttribute(sortField))), true);
            vector.reader().load(total - 1);
            Bounds.Bound hi = new Bounds.Bound(Option$.MODULE$.apply((Object)((Comparable)feature.getAttribute(sortField))), true);
            Bounds bounds = currentBatchBounds = reverse ? new Bounds(hi, lo) : new Bounds(lo, hi);
            if (filterBounds.exists((Function1)new Serializable(currentBatchBounds){
                public static final long serialVersionUID = 0L;
                private final Bounds currentBatchBounds$1;

                public final boolean apply(Bounds<Comparable<Object>> x$5) {
                    return Bounds$.MODULE$.intersection(x$5, this.currentBatchBounds$1).isDefined();
                }
                {
                    this.currentBatchBounds$1 = currentBatchBounds$1;
                }
            })) {
                Iterator all = package$.MODULE$.Iterator().range(0, vector.reader().getValueCount()).map((Function1)new Serializable(vector, feature){
                    public static final long serialVersionUID = 0L;
                    private final SimpleFeatureVector vector$2;
                    private final ArrowSimpleFeature feature$2;

                    public final ArrowSimpleFeature apply(int i) {
                        this.vector$2.reader().load(i);
                        return this.feature$2;
                    }
                    {
                        this.vector$2 = vector$2;
                        this.feature$2 = feature$2;
                    }
                });
                iterator = all.filter((Function1)new Serializable(filter){
                    public static final long serialVersionUID = 0L;
                    private final Filter filter$2;

                    public final boolean apply(Object x$1) {
                        return this.filter$2.evaluate(x$1);
                    }
                    {
                        this.filter$2 = filter$2;
                    }
                });
            } else {
                boolean hasMore = reverse ? filterBounds.exists((Function1)new Serializable(currentBatchBounds){
                    public static final long serialVersionUID = 0L;
                    private final Bounds currentBatchBounds$1;

                    public final boolean apply(Bounds<Comparable<Object>> fb) {
                        return Bounds$.MODULE$.smallerLowerBound(fb.lower(), this.currentBatchBounds$1.lower()) == fb.lower();
                    }
                    {
                        this.currentBatchBounds$1 = currentBatchBounds$1;
                    }
                }) : filterBounds.exists((Function1)new Serializable(currentBatchBounds){
                    public static final long serialVersionUID = 0L;
                    private final Bounds currentBatchBounds$1;

                    public final boolean apply(Bounds<Comparable<Object>> fb) {
                        return Bounds$.MODULE$.largerUpperBound(fb.upper(), this.currentBatchBounds$1.upper()) == fb.upper();
                    }
                    {
                        this.currentBatchBounds$1 = currentBatchBounds$1;
                    }
                });
                skip.skip_$eq(!hasMore);
                iterator = package$.MODULE$.Iterator().empty();
            }
        }
        return iterator;
    }

    private SimpleFeatureArrowFileReader$() {
        MODULE$ = this;
    }
}

