/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.arrow.vector;

import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.NullableBigIntVector;
import org.apache.arrow.vector.complex.NullableMapVector;
import org.apache.arrow.vector.types.FloatingPointPrecision;
import org.apache.arrow.vector.types.pojo.Field;
import org.locationtech.geomesa.arrow.vector.ArrowDictionary;
import org.locationtech.geomesa.arrow.vector.GeometryFields;
import org.locationtech.geomesa.arrow.vector.SimpleFeatureVector;
import org.locationtech.geomesa.arrow.vector.SimpleFeatureVector$EncodingPrecision$;
import org.locationtech.geomesa.arrow.vector.SimpleFeatureVector$SimpleFeatureEncoding$;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import scala.Enumeration;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.runtime.BooleanRef;

public final class SimpleFeatureVector$ {
    public static final SimpleFeatureVector$ MODULE$;
    private final int DefaultCapacity;
    private final String FeatureIdField;
    private final String DescriptorKey;

    static {
        new SimpleFeatureVector$();
    }

    public int DefaultCapacity() {
        return this.DefaultCapacity;
    }

    public String FeatureIdField() {
        return this.FeatureIdField;
    }

    public String DescriptorKey() {
        return this.DescriptorKey;
    }

    public SimpleFeatureVector create(SimpleFeatureType sft, Map<String, ArrowDictionary> dictionaries, SimpleFeatureVector.SimpleFeatureEncoding encoding, int capacity, BufferAllocator allocator) {
        NullableMapVector underlying = NullableMapVector.empty((String)sft.getTypeName(), (BufferAllocator)allocator);
        SimpleFeatureVector vector = new SimpleFeatureVector(sft, underlying, dictionaries, encoding, allocator);
        underlying.setInitialCapacity(capacity);
        underlying.allocateNew();
        return vector;
    }

    public SimpleFeatureVector.SimpleFeatureEncoding create$default$3() {
        return SimpleFeatureVector$SimpleFeatureEncoding$.MODULE$.min(false);
    }

    public int create$default$4() {
        return this.DefaultCapacity();
    }

    public SimpleFeatureVector wrap(NullableMapVector vector, Map<String, ArrowDictionary> dictionaries, BufferAllocator allocator) {
        BooleanRef includeFids = BooleanRef.create((boolean)false);
        ArrayBuffer attributes = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        JavaConversions$.MODULE$.asScalaBuffer(vector.getField().getChildren()).foreach((Function1)new Serializable(includeFids, attributes){
            public static final long serialVersionUID = 0L;
            private final BooleanRef includeFids$1;
            private final ArrayBuffer attributes$1;

            public final void apply(Field field) {
                String string = field.getName();
                String string2 = SimpleFeatureVector$.MODULE$.FeatureIdField();
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    this.includeFids$1.elem = true;
                } else {
                    this.attributes$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{(String)field.getMetadata().get(SimpleFeatureVector$.MODULE$.DescriptorKey())}));
                }
            }
            {
                this.includeFids$1 = includeFids$1;
                this.attributes$1 = attributes$1;
            }
        });
        SimpleFeatureType sft = SimpleFeatureTypes$.MODULE$.createType(vector.getField().getName(), attributes.mkString(","));
        Option geomVector = Option$.MODULE$.apply((Object)sft.getGeometryDescriptor()).flatMap((Function1)new Serializable(vector){
            public static final long serialVersionUID = 0L;
            private final NullableMapVector vector$1;

            public final Option<FieldVector> apply(GeometryDescriptor d) {
                return Option$.MODULE$.apply((Object)this.vector$1.getChild(d.getLocalName()));
            }
            {
                this.vector$1 = vector$1;
            }
        });
        boolean isDouble = geomVector.exists((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(FieldVector v) {
                FloatingPointPrecision floatingPointPrecision = GeometryFields.precisionFromField((Field)v.getField());
                FloatingPointPrecision floatingPointPrecision2 = FloatingPointPrecision.DOUBLE;
                return !(floatingPointPrecision != null ? !floatingPointPrecision.equals(floatingPointPrecision2) : floatingPointPrecision2 != null);
            }
        });
        Enumeration.Value geomPrecision = isDouble ? SimpleFeatureVector$EncodingPrecision$.MODULE$.Max() : SimpleFeatureVector$EncodingPrecision$.MODULE$.Min();
        Option dateVector = RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getDtgField$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)).flatMap((Function1)new Serializable(vector){
            public static final long serialVersionUID = 0L;
            private final NullableMapVector vector$1;

            public final Option<FieldVector> apply(String d) {
                return Option$.MODULE$.apply((Object)this.vector$1.getChild(d));
            }
            {
                this.vector$1 = vector$1;
            }
        });
        boolean isLong = dateVector.exists((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(FieldVector x$2) {
                return x$2 instanceof NullableBigIntVector;
            }
        });
        Enumeration.Value datePrecision = isLong ? SimpleFeatureVector$EncodingPrecision$.MODULE$.Max() : SimpleFeatureVector$EncodingPrecision$.MODULE$.Min();
        SimpleFeatureVector.SimpleFeatureEncoding encoding = new SimpleFeatureVector.SimpleFeatureEncoding(includeFids.elem, geomPrecision, datePrecision);
        return new SimpleFeatureVector(sft, vector, dictionaries, encoding, allocator);
    }

    public SimpleFeatureVector clone(SimpleFeatureVector vector, NullableMapVector underlying, BufferAllocator allocator) {
        return new SimpleFeatureVector(vector.sft(), underlying, vector.dictionaries(), vector.encoding(), allocator);
    }

    private SimpleFeatureVector$() {
        MODULE$ = this;
        this.DefaultCapacity = 8096;
        this.FeatureIdField = "id";
        this.DescriptorKey = "descriptor";
    }
}

