/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.arrow.io;

import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.SmallIntVector;
import org.apache.arrow.vector.TinyIntVector;
import org.apache.arrow.vector.complex.StructVector;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.DictionaryEncoding;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.locationtech.geomesa.arrow.io.DictionaryBuildingWriter;
import org.locationtech.geomesa.arrow.package;
import org.locationtech.geomesa.arrow.vector.ArrowAttributeWriter;
import org.locationtech.geomesa.arrow.vector.ArrowAttributeWriter$;
import org.locationtech.geomesa.arrow.vector.ArrowDictionary;
import org.locationtech.geomesa.arrow.vector.SimpleFeatureVector;
import org.locationtech.geomesa.arrow.vector.SimpleFeatureVector$;
import org.locationtech.geomesa.arrow.vector.SimpleFeatureVector$SimpleFeatureEncoding$;
import org.locationtech.geomesa.features.serialization.ObjectType$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import scala.Enumeration;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.mutable.Buffer$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;

public final class DictionaryBuildingWriter$ {
    public static final DictionaryBuildingWriter$ MODULE$;

    static {
        new DictionaryBuildingWriter$();
    }

    public DictionaryBuildingWriter create(SimpleFeatureType sft, Seq<String> dictionaries2, SimpleFeatureVector.SimpleFeatureEncoding encoding, int maxSize, BufferAllocator allocator) {
        StructVector underlying = StructVector.empty((String)sft.getTypeName(), (BufferAllocator)allocator);
        underlying.allocateNew();
        return new DictionaryBuildingWriter(sft, underlying, dictionaries2, encoding, maxSize, allocator);
    }

    public SimpleFeatureVector.SimpleFeatureEncoding create$default$3() {
        return SimpleFeatureVector$SimpleFeatureEncoding$.MODULE$.Min();
    }

    public int create$default$4() {
        return Short.MAX_VALUE;
    }

    public Seq<ArrowAttributeWriter> org$locationtech$geomesa$arrow$io$DictionaryBuildingWriter$$attribute(SimpleFeatureType sft, StructVector vector, Seq<String> dictionaries2, SimpleFeatureVector.SimpleFeatureEncoding encoding, int maxSize, BufferAllocator allocator) {
        LongRef dictionaryId = LongRef.create((long)-1L);
        return (Seq)JavaConversions$.MODULE$.asScalaBuffer(sft.getAttributeDescriptors()).map((Function1)new Serializable(sft, vector, dictionaries2, encoding, maxSize, allocator, dictionaryId){
            public static final long serialVersionUID = 0L;
            private final SimpleFeatureType sft$1;
            private final StructVector vector$1;
            private final Seq dictionaries$1;
            private final SimpleFeatureVector.SimpleFeatureEncoding encoding$1;
            private final int maxSize$1;
            private final BufferAllocator allocator$1;
            private final LongRef dictionaryId$1;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final ArrowAttributeWriter apply(AttributeDescriptor descriptor) {
                ArrowAttributeWriter arrowAttributeWriter;
                String name = descriptor.getLocalName();
                scala.collection.immutable.Map metadata = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SimpleFeatureVector$.MODULE$.DescriptorKey()), (Object)SimpleFeatureTypes$.MODULE$.encodeDescriptor(this.sft$1, descriptor))}));
                Class classBinding = descriptor.getType().getBinding();
                Seq bindings = ObjectType$.MODULE$.selectType(classBinding, descriptor.getUserData());
                if (this.dictionaries$1.contains((Object)name)) {
                    ++this.dictionaryId$1.elem;
                    package.TypeBindings dictionaryType = new package.TypeBindings((Seq<Enumeration.Value>)bindings, this.encoding$1);
                    if (this.maxSize$1 <= 127) {
                        DictionaryEncoding dictionaryEncoding = new DictionaryEncoding(this.dictionaryId$1.elem, false, new ArrowType.Int(8, true));
                        FieldType fieldType = new FieldType(true, Types.MinorType.TINYINT.getType(), dictionaryEncoding, JavaConversions$.MODULE$.mapAsJavaMap((Map)metadata));
                        TinyIntVector child = (TinyIntVector)this.vector$1.addOrGet(name, fieldType, TinyIntVector.class);
                        arrowAttributeWriter = new DictionaryBuildingWriter.ArrowAttributeByteDictionaryBuildingWriter(child, dictionaryEncoding, dictionaryType);
                        return arrowAttributeWriter;
                    } else if (this.maxSize$1 <= Short.MAX_VALUE) {
                        DictionaryEncoding dictionaryEncoding = new DictionaryEncoding(this.dictionaryId$1.elem, false, new ArrowType.Int(16, true));
                        FieldType fieldType = new FieldType(true, Types.MinorType.SMALLINT.getType(), dictionaryEncoding, JavaConversions$.MODULE$.mapAsJavaMap((Map)metadata));
                        SmallIntVector child = (SmallIntVector)this.vector$1.addOrGet(name, fieldType, SmallIntVector.class);
                        arrowAttributeWriter = new DictionaryBuildingWriter.ArrowAttributeShortDictionaryBuildingWriter(child, dictionaryEncoding, dictionaryType);
                        return arrowAttributeWriter;
                    } else {
                        if (this.maxSize$1 > Integer.MAX_VALUE) throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"MaxSize must be less than or equal to Int.MaxValue (", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE)})));
                        DictionaryEncoding dictionaryEncoding = new DictionaryEncoding(this.dictionaryId$1.elem, false, new ArrowType.Int(32, true));
                        FieldType fieldType = new FieldType(true, Types.MinorType.INT.getType(), dictionaryEncoding, JavaConversions$.MODULE$.mapAsJavaMap((Map)metadata));
                        IntVector child = (IntVector)this.vector$1.addOrGet(name, fieldType, IntVector.class);
                        arrowAttributeWriter = new DictionaryBuildingWriter.ArrowAttributeIntDictionaryBuildingWriter(child, dictionaryEncoding, dictionaryType);
                    }
                    return arrowAttributeWriter;
                } else {
                    arrowAttributeWriter = ArrowAttributeWriter$.MODULE$.apply(name, (Seq<Enumeration.Value>)bindings, (Option<StructVector>)new Some((Object)this.vector$1), (Option<ArrowDictionary>)None$.MODULE$, (scala.collection.immutable.Map<String, String>)metadata, this.encoding$1, this.allocator$1);
                }
                return arrowAttributeWriter;
            }
            {
                this.sft$1 = sft$1;
                this.vector$1 = vector$1;
                this.dictionaries$1 = dictionaries$1;
                this.encoding$1 = encoding$1;
                this.maxSize$1 = maxSize$1;
                this.allocator$1 = allocator$1;
                this.dictionaryId$1 = dictionaryId$1;
            }
        }, Buffer$.MODULE$.canBuildFrom());
    }

    private DictionaryBuildingWriter$() {
        MODULE$ = this;
    }
}

