/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.arrow.io;

import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.nio.channels.Channels;
import java.util.Collections;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.ipc.ArrowStreamWriter;
import org.apache.arrow.vector.ipc.message.IpcOption;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.arrow.vector.util.TransferPair;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.locationtech.geomesa.arrow.io.SimpleFeatureArrowFileWriter$;
import org.locationtech.geomesa.arrow.io.package;
import org.locationtech.geomesa.arrow.io.package$Metadata$;
import org.locationtech.geomesa.arrow.jts.GeometryFields;
import org.locationtech.geomesa.arrow.jts.GeometryVector;
import org.locationtech.geomesa.arrow.vector.ArrowDictionary;
import org.locationtech.geomesa.arrow.vector.SimpleFeatureVector;
import org.locationtech.geomesa.utils.collection.CloseableIterator;
import org.locationtech.geomesa.utils.io.IsCloseable$;
import org.locationtech.geomesa.utils.io.package;
import org.locationtech.jts.geom.Geometry;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.java8.JFunction2;

public final class package$ {
    public static package$ MODULE$;

    static {
        new package$();
    }

    public Option<Tuple2<String, Object>> getSortFromMetadata(java.util.Map<String, String> metadata) {
        return Option$.MODULE$.apply((Object)metadata.get(package$Metadata$.MODULE$.SortField())).map((Function1 & Serializable & scala.Serializable)field -> {
            boolean reverse = Option$.MODULE$.apply(metadata.get(package$Metadata$.MODULE$.SortOrder())).exists((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)package$.$anonfun$getSortFromMetadata$2(x0$1)));
            return new Tuple2(field, (Object)BoxesRunTime.boxToBoolean((boolean)reverse));
        });
    }

    public java.util.Map<String, String> getSortAsMetadata(String field, boolean reverse) {
        return (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)package$Metadata$.MODULE$.SortField()), (Object)field), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)package$Metadata$.MODULE$.SortOrder()), (Object)(reverse ? "descending" : "ascending"))}))).asJava();
    }

    public VectorSchemaRoot createRoot(FieldVector vector, java.util.Map<String, String> metadata) {
        Schema schema = new Schema(Collections.singletonList(vector.getField()), metadata);
        return new VectorSchemaRoot(schema, Collections.singletonList(vector), vector.getValueCount());
    }

    public java.util.Map<String, String> createRoot$default$2() {
        return null;
    }

    public Function2<Object, Object, BoxedUnit> createTransferPair(SimpleFeatureType sft, FieldVector from, FieldVector to) {
        LazyRef binding$lzy = new LazyRef();
        int i = sft.indexOf(from.getField().getName());
        if (i != -1 && Geometry.class.isAssignableFrom(package$.binding$1(binding$lzy, sft, i))) {
            GeometryVector fromGeom = GeometryFields.wrap((FieldVector)from, (Class)package$.binding$1(binding$lzy, sft, i));
            GeometryVector toGeom = GeometryFields.wrap((FieldVector)to, (Class)package$.binding$1(binding$lzy, sft, i));
            return (JFunction2.mcVII.sp & Serializable & scala.Serializable)(fromIndex, toIndex) -> fromGeom.transfer(fromIndex, toIndex, toGeom);
        }
        TransferPair transfer = from.makeTransferPair((ValueVector)to);
        return (JFunction2.mcVII.sp & Serializable & scala.Serializable)(fromIndex, toIndex) -> transfer.copyValueSafe(fromIndex, toIndex);
    }

    public byte[] writeHeaderAndFirstBatch(SimpleFeatureVector result, scala.collection.immutable.Map<String, ArrowDictionary> dictionaries, IpcOption ipcOpts, Option<Tuple2<String, Object>> sort, int count) {
        Some some;
        Tuple2 tuple2;
        java.util.Map<String, String> map;
        Option<Tuple2<String, Object>> option = sort;
        if (None$.MODULE$.equals(option)) {
            map = null;
        } else if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
            String sortBy = (String)tuple2._1();
            boolean reverse = tuple2._2$mcZ$sp();
            map = this.getSortAsMetadata(sortBy, reverse);
        } else {
            throw new MatchError(option);
        }
        java.util.Map<String, String> metadata = map;
        VectorSchemaRoot root = this.createRoot((FieldVector)result.underlying(), metadata);
        root.setRowCount(count);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        return (byte[])package.WithClose$.MODULE$.apply((Object)SimpleFeatureArrowFileWriter$.MODULE$.provider(dictionaries, result.encoding()), (Function1 & Serializable & scala.Serializable)provider -> (byte[])package.WithClose$.MODULE$.apply((Object)new ArrowStreamWriter(root, provider, Channels.newChannel(os), ipcOpts), (Function1 & Serializable & scala.Serializable)writer -> {
            writer.writeBatch();
            return os.toByteArray();
        }, IsCloseable$.MODULE$.closeableIsCloseable()), IsCloseable$.MODULE$.closeableIsCloseable());
    }

    public CloseableIterator<byte[]> createFileFromBatches(SimpleFeatureType sft, scala.collection.immutable.Map<String, ArrowDictionary> dictionaries, SimpleFeatureVector.SimpleFeatureEncoding encoding, IpcOption ipcOpts, Option<Tuple2<String, Object>> sort, CloseableIterator<byte[]> batches, boolean firstBatchHasHeader) {
        byte[] ft = ipcOpts.write_legacy_ipc_format ? this.legacyFooter() : this.footer();
        return new package.ArrowFileIterator(sft, dictionaries, encoding, sort, ipcOpts, batches, firstBatchHasHeader, ft);
    }

    private byte[] footer() {
        return (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{-1, -1, -1, -1, 0, 0, 0, 0}), ClassTag$.MODULE$.Byte());
    }

    private byte[] legacyFooter() {
        return (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{0, 0, 0, 0}), ClassTag$.MODULE$.Byte());
    }

    public static final /* synthetic */ boolean $anonfun$getSortFromMetadata$2(String x0$1) {
        String string = x0$1;
        return "descending".equals(string);
    }

    private static final /* synthetic */ Class binding$lzycompute$1(LazyRef binding$lzy$1, SimpleFeatureType sft$1, int i$1) {
        Class clazz;
        LazyRef lazyRef = binding$lzy$1;
        synchronized (lazyRef) {
            clazz = binding$lzy$1.initialized() ? (Class)binding$lzy$1.value() : (Class)binding$lzy$1.initialize((Object)sft$1.getDescriptor(i$1).getType().getBinding());
        }
        return clazz;
    }

    private static final Class binding$1(LazyRef binding$lzy$1, SimpleFeatureType sft$1, int i$1) {
        if (binding$lzy$1.initialized()) {
            return (Class)binding$lzy$1.value();
        }
        return package$.binding$lzycompute$1(binding$lzy$1, sft$1, i$1);
    }

    private package$() {
        MODULE$ = this;
    }
}

