/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.arrow.filter;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.locationtech.geomesa.arrow.filter.ArrowFilterOptimizer;
import org.locationtech.geomesa.arrow.vector.ArrowDictionary;
import org.locationtech.geomesa.filter.expression.AttributeExpression;
import org.locationtech.geomesa.filter.factory.FastFilterFactory$;
import org.locationtech.geomesa.filter.package$;
import org.locationtech.geomesa.utils.geotools.RichAttributeDescriptors;
import org.locationtech.geomesa.utils.geotools.RichAttributeDescriptors$;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.geotools.converters.FastConverter$;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygon;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.And;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.Not;
import org.opengis.filter.Or;
import org.opengis.filter.PropertyIsBetween;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.temporal.During;
import org.opengis.temporal.Period;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.immutable.Map;
import scala.collection.mutable.Buffer;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

public final class ArrowFilterOptimizer$
implements LazyLogging {
    public static final ArrowFilterOptimizer$ MODULE$ = new ArrowFilterOptimizer$();
    private static final FilterFactory2 ff;
    private static transient Logger logger;
    private static volatile transient boolean bitmap$trans$0;

    static {
        LazyLogging.$init$((LazyLogging)MODULE$);
        ff = FastFilterFactory$.MODULE$.factory();
    }

    private Logger logger$lzycompute() {
        ArrowFilterOptimizer$ arrowFilterOptimizer$ = this;
        synchronized (arrowFilterOptimizer$) {
            if (!bitmap$trans$0) {
                logger = LazyLogging.logger$((LazyLogging)this);
                bitmap$trans$0 = true;
            }
        }
        return logger;
    }

    public Logger logger() {
        if (!bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    private FilterFactory2 ff() {
        return ff;
    }

    public Filter rewrite(Filter filter, SimpleFeatureType sft, Map<String, ArrowDictionary> dictionaries) {
        Filter filter2;
        Filter bound = FastFilterFactory$.MODULE$.optimize(sft, filter);
        FastFilterFactory$.MODULE$.sfts().set(sft);
        try {
            filter2 = this.rewriteFilter(bound, sft, dictionaries);
        }
        finally {
            FastFilterFactory$.MODULE$.sfts().remove();
        }
        return filter2;
    }

    private Filter rewriteFilter(Filter filter, SimpleFeatureType sft, Map<String, ArrowDictionary> dictionaries) {
        Filter filter2;
        try {
            Filter filter3 = filter;
            if (filter3 instanceof BBOX) {
                BBOX bBOX = (BBOX)filter3;
                filter2 = this.rewriteBBox(bBOX, sft);
            } else if (filter3 instanceof During) {
                During during = (During)filter3;
                filter2 = this.rewriteDuring(during, sft);
            } else if (filter3 instanceof PropertyIsBetween) {
                PropertyIsBetween propertyIsBetween = (PropertyIsBetween)filter3;
                filter2 = this.rewriteBetween(propertyIsBetween, sft);
            } else if (filter3 instanceof PropertyIsEqualTo) {
                PropertyIsEqualTo propertyIsEqualTo = (PropertyIsEqualTo)filter3;
                filter2 = this.rewritePropertyIsEqualTo(propertyIsEqualTo, sft, dictionaries);
            } else if (filter3 instanceof And) {
                And and = (And)filter3;
                filter2 = this.ff().and((List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(and.getChildren()).asScala()).map((Function1 & Serializable)x$1 -> MODULE$.rewriteFilter((Filter)x$1, sft, dictionaries))).asJava());
            } else if (filter3 instanceof Or) {
                Or or = (Or)filter3;
                filter2 = this.ff().or((List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(or.getChildren()).asScala()).map((Function1 & Serializable)x$2 -> MODULE$.rewriteFilter((Filter)x$2, sft, dictionaries))).asJava());
            } else if (filter3 instanceof Not) {
                Not not = (Not)filter3;
                filter2 = this.ff().not(this.rewriteFilter(not.getFilter(), sft, dictionaries));
            } else {
                filter2 = filter;
            }
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                BoxedUnit boxedUnit;
                Throwable e = (Throwable)option.get();
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn(new StringBuilder(24).append("Error re-writing filter ").append(filter).toString(), e);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                filter2 = filter;
            }
            throw throwable;
        }
        return filter2;
    }

    private Filter rewriteBBox(BBOX filter, SimpleFeatureType sft) {
        if (RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.isPoints$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)) || RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.isLines$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft))) {
            AttributeExpression props = package$.MODULE$.checkOrderUnsafe(filter.getExpression1(), filter.getExpression2());
            Envelope bbox = ((Geometry)FastConverter$.MODULE$.evaluate((Expression)props.literal(), Polygon.class)).getEnvelopeInternal();
            int attrIndex = sft.indexOf(props.name());
            if (RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.isPoints$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft))) {
                return new ArrowFilterOptimizer.ArrowPointBBox(attrIndex, bbox.getMinX(), bbox.getMinY(), bbox.getMaxX(), bbox.getMaxY());
            }
            return new ArrowFilterOptimizer.ArrowLineStringBBox(attrIndex, bbox.getMinX(), bbox.getMinY(), bbox.getMaxX(), bbox.getMaxY());
        }
        return filter;
    }

    private Filter rewriteDuring(During filter, SimpleFeatureType sft) {
        AttributeExpression props = package$.MODULE$.checkOrderUnsafe(filter.getExpression1(), filter.getExpression2());
        int attrIndex = sft.indexOf(props.name());
        Period period = (Period)FastConverter$.MODULE$.evaluate((Expression)props.literal(), Period.class);
        long lower = period.getBeginning().getPosition().getDate().getTime();
        long upper = period.getEnding().getPosition().getDate().getTime();
        return new ArrowFilterOptimizer.ArrowDuring(attrIndex, lower, upper);
    }

    private Filter rewriteBetween(PropertyIsBetween filter, SimpleFeatureType sft) {
        String attribute = ((PropertyName)filter.getExpression()).getPropertyName();
        int attrIndex = sft.indexOf(attribute);
        Class clazz = sft.getDescriptor(attrIndex).getType().getBinding();
        Class<Date> clazz2 = Date.class;
        if (clazz == null ? clazz2 != null : !clazz.equals(clazz2)) {
            return filter;
        }
        long lower = ((Date)FastConverter$.MODULE$.evaluate(filter.getLowerBoundary(), Date.class)).getTime();
        long upper = ((Date)FastConverter$.MODULE$.evaluate(filter.getUpperBoundary(), Date.class)).getTime();
        return new ArrowFilterOptimizer.ArrowBetweenDate(attrIndex, lower, upper);
    }

    private Filter rewritePropertyIsEqualTo(PropertyIsEqualTo filter, SimpleFeatureType sft, Map<String, ArrowDictionary> dictionaries) {
        AttributeExpression props = package$.MODULE$.checkOrderUnsafe(filter.getExpression1(), filter.getExpression2());
        Option option = dictionaries.get((Object)props.name());
        if (None$.MODULE$.equals(option)) {
            return filter;
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            ArrowDictionary dictionary = (ArrowDictionary)some.value();
            int attrIndex = sft.indexOf(props.name());
            int numericValue = dictionary.index(props.literal().evaluate(null));
            if (RichAttributeDescriptors.RichAttributeDescriptor$.MODULE$.isList$extension(RichAttributeDescriptors$.MODULE$.RichAttributeDescriptor(sft.getDescriptor(attrIndex)))) {
                return new ArrowFilterOptimizer.ArrowListDictionaryEquals(attrIndex, numericValue);
            }
            return new ArrowFilterOptimizer.ArrowDictionaryEquals(attrIndex, numericValue);
        }
        throw new MatchError((Object)option);
    }

    private ArrowFilterOptimizer$() {
    }
}

