/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.arrow.vector;

import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.complex.StructVector;
import org.apache.arrow.vector.types.FloatingPointPrecision;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.locationtech.geomesa.arrow.jts.GeometryFields;
import org.locationtech.geomesa.arrow.package$ArrowAllocator$;
import org.locationtech.geomesa.arrow.vector.ArrowDictionary;
import org.locationtech.geomesa.arrow.vector.SimpleFeatureVector;
import org.locationtech.geomesa.arrow.vector.SimpleFeatureVector$SimpleFeatureEncoding$;
import org.locationtech.geomesa.arrow.vector.SimpleFeatureVector$SimpleFeatureEncoding$Encoding$;
import org.locationtech.geomesa.utils.geotools.RichAttributeDescriptors;
import org.locationtech.geomesa.utils.geotools.RichAttributeDescriptors$;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$;
import org.locationtech.geomesa.utils.io.IsCloseable$;
import org.locationtech.geomesa.utils.io.package;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.util.control.NonFatal$;

public final class SimpleFeatureVector$ {
    public static final SimpleFeatureVector$ MODULE$ = new SimpleFeatureVector$();
    private static final int DefaultCapacity = 8096;
    private static final String FeatureIdField = "id";
    private static final String DescriptorKey = "descriptor";
    private static final String OptionsKey = "options";

    public int DefaultCapacity() {
        return DefaultCapacity;
    }

    public String FeatureIdField() {
        return FeatureIdField;
    }

    public String DescriptorKey() {
        return DescriptorKey;
    }

    public String OptionsKey() {
        return OptionsKey;
    }

    public SimpleFeatureVector create(SimpleFeatureType sft, scala.collection.immutable.Map<String, ArrowDictionary> dictionaries, SimpleFeatureVector.SimpleFeatureEncoding encoding, int capacity) {
        SimpleFeatureVector simpleFeatureVector;
        BufferAllocator allocator = package$ArrowAllocator$.MODULE$.apply(new StringBuilder(22).append("simple-feature-vector:").append(sft.getTypeName()).toString());
        try {
            Map<String, String> metadata = Collections.singletonMap(this.OptionsKey(), SimpleFeatureTypes$.MODULE$.encodeUserData(sft));
            FieldType fieldType = new FieldType(true, (ArrowType)ArrowType.Struct.INSTANCE, null, metadata);
            StructVector underlying = new StructVector(sft.getTypeName(), allocator, fieldType, null);
            SimpleFeatureVector vector = new SimpleFeatureVector(sft, underlying, dictionaries, encoding, (Option<BufferAllocator>)new Some((Object)allocator));
            underlying.setInitialCapacity(capacity);
            underlying.allocateNew();
            simpleFeatureVector = vector;
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable e = (Throwable)option.get();
                package.CloseQuietly$.MODULE$.apply((Object)allocator, IsCloseable$.MODULE$.closeableIsCloseable()).foreach((Function1 & Serializable)x$1 -> {
                    e.addSuppressed(x$1);
                    return BoxedUnit.UNIT;
                });
                throw e;
            }
            throw throwable;
        }
        return simpleFeatureVector;
    }

    public SimpleFeatureVector.SimpleFeatureEncoding create$default$3() {
        return SimpleFeatureVector$SimpleFeatureEncoding$.MODULE$.Min();
    }

    public int create$default$4() {
        return this.DefaultCapacity();
    }

    public SimpleFeatureVector wrap(StructVector vector, scala.collection.immutable.Map<String, ArrowDictionary> dictionaries) {
        Tuple2<SimpleFeatureType, SimpleFeatureVector.SimpleFeatureEncoding> tuple2 = this.getFeatureType(vector);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        SimpleFeatureType sft = (SimpleFeatureType)tuple2._1();
        SimpleFeatureVector.SimpleFeatureEncoding encoding = (SimpleFeatureVector.SimpleFeatureEncoding)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)sft, (Object)encoding);
        SimpleFeatureType sft2 = (SimpleFeatureType)tuple22._1();
        SimpleFeatureVector.SimpleFeatureEncoding encoding2 = (SimpleFeatureVector.SimpleFeatureEncoding)tuple22._2();
        return new SimpleFeatureVector(sft2, vector, dictionaries, encoding2, (Option<BufferAllocator>)None$.MODULE$);
    }

    public SimpleFeatureVector clone(SimpleFeatureVector vector, StructVector underlying) {
        return new SimpleFeatureVector(vector.sft(), underlying, vector.dictionaries(), vector.encoding(), (Option<BufferAllocator>)None$.MODULE$);
    }

    public Tuple2<SimpleFeatureType, SimpleFeatureVector.SimpleFeatureEncoding> getFeatureType(StructVector vector) {
        ArrayBuffer attributes = ArrayBuffer$.MODULE$.empty();
        ObjectRef fidEncoding = ObjectRef.create((Object)None$.MODULE$);
        ((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(vector.getField().getChildren()).asScala()).foreach((Function1 & Serializable)field -> {
            String string = field.getName();
            String string2 = MODULE$.FeatureIdField();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                ArrowType arrowType = field.getType();
                if (arrowType instanceof ArrowType.Int) {
                    fidEncoding$1.elem = new Some((Object)SimpleFeatureVector$SimpleFeatureEncoding$Encoding$.MODULE$.Min());
                } else if (arrowType instanceof ArrowType.FixedSizeList) {
                    fidEncoding$1.elem = new Some((Object)SimpleFeatureVector$SimpleFeatureEncoding$Encoding$.MODULE$.Max());
                } else if (arrowType instanceof ArrowType.Utf8) {
                    fidEncoding$1.elem = new Some((Object)SimpleFeatureVector$SimpleFeatureEncoding$Encoding$.MODULE$.Max());
                } else {
                    throw new IllegalArgumentException(new StringBuilder(50).append("Found feature ID vector field of unexpected type: ").append(field).toString());
                }
                return BoxedUnit.UNIT;
            }
            return attributes.append(field.getMetadata().get(MODULE$.DescriptorKey()));
        });
        String options = (String)Option$.MODULE$.apply(vector.getField().getMetadata().get(this.OptionsKey())).getOrElse((Function0 & Serializable)() -> "");
        SimpleFeatureType sft = SimpleFeatureTypes$.MODULE$.createImmutableType(vector.getField().getName(), new StringBuilder(0).append(attributes.mkString(",")).append(options).toString());
        Option geomVector = Option$.MODULE$.apply((Object)RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getGeomField$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft))).flatMap((Function1 & Serializable)d -> Option$.MODULE$.apply((Object)vector.getChild(d))).orElse((Function0 & Serializable)() -> MODULE$.getNestedVector(sft, vector, ClassTag$.MODULE$.apply(Geometry.class)));
        boolean isDouble = geomVector.exists((Function1 & Serializable)v -> BoxesRunTime.boxToBoolean((boolean)SimpleFeatureVector$.$anonfun$getFeatureType$5(v)));
        Enumeration.Value geomPrecision = isDouble ? SimpleFeatureVector$SimpleFeatureEncoding$Encoding$.MODULE$.Max() : SimpleFeatureVector$SimpleFeatureEncoding$Encoding$.MODULE$.Min();
        Option dateVector = RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getDtgField$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)).flatMap((Function1 & Serializable)d -> Option$.MODULE$.apply((Object)vector.getChild(d))).orElse((Function0 & Serializable)() -> MODULE$.getNestedVector(sft, vector, ClassTag$.MODULE$.apply(Date.class)));
        boolean isLong = dateVector.exists((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)SimpleFeatureVector$.$anonfun$getFeatureType$8(x$3)));
        Enumeration.Value datePrecision = isLong ? SimpleFeatureVector$SimpleFeatureEncoding$Encoding$.MODULE$.Max() : SimpleFeatureVector$SimpleFeatureEncoding$Encoding$.MODULE$.Min();
        SimpleFeatureVector.SimpleFeatureEncoding encoding = new SimpleFeatureVector.SimpleFeatureEncoding((Option<Enumeration.Value>)((Option)fidEncoding.elem), geomPrecision, datePrecision);
        return new Tuple2((Object)sft, (Object)encoding);
    }

    public boolean isGeometryVector(FieldVector vector) {
        return Option$.MODULE$.apply(vector.getField().getMetadata().get(this.DescriptorKey())).map((Function1 & Serializable)spec -> SimpleFeatureTypes$.MODULE$.createDescriptor(spec)).exists((Function1 & Serializable)d -> BoxesRunTime.boxToBoolean((boolean)SimpleFeatureVector$.$anonfun$isGeometryVector$2(d)));
    }

    private <T> Option<FieldVector> getNestedVector(SimpleFeatureType sft, StructVector vector, ClassTag<T> ct) {
        return ((IterableOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(sft.getAttributeDescriptors()).asScala()).flatMap((Function1 & Serializable)x0$1 -> {
            AttributeDescriptor attributeDescriptor = x0$1;
            if (RichAttributeDescriptors.RichAttributeDescriptor$.MODULE$.isList$extension(RichAttributeDescriptors$.MODULE$.RichAttributeDescriptor(attributeDescriptor)) && ct.runtimeClass().isAssignableFrom(RichAttributeDescriptors.RichAttributeDescriptor$.MODULE$.getListType$extension(RichAttributeDescriptors$.MODULE$.RichAttributeDescriptor(attributeDescriptor)))) {
                return Option$.MODULE$.apply((Object)((ListVector)vector.getChild(attributeDescriptor.getLocalName()))).map((Function1 & Serializable)x$4 -> x$4.getDataVector());
            }
            if (RichAttributeDescriptors.RichAttributeDescriptor$.MODULE$.isMap$extension(RichAttributeDescriptors$.MODULE$.RichAttributeDescriptor(attributeDescriptor)) && ct.runtimeClass().isAssignableFrom((Class)RichAttributeDescriptors.RichAttributeDescriptor$.MODULE$.getMapTypes$extension(RichAttributeDescriptors$.MODULE$.RichAttributeDescriptor(attributeDescriptor))._1())) {
                return Option$.MODULE$.apply((Object)((StructVector)vector.getChild(attributeDescriptor.getLocalName()))).map((Function1 & Serializable)x$5 -> (FieldVector)x$5.getChildrenFromFields().get(0));
            }
            if (RichAttributeDescriptors.RichAttributeDescriptor$.MODULE$.isMap$extension(RichAttributeDescriptors$.MODULE$.RichAttributeDescriptor(attributeDescriptor)) && ct.runtimeClass().isAssignableFrom((Class)RichAttributeDescriptors.RichAttributeDescriptor$.MODULE$.getMapTypes$extension(RichAttributeDescriptors$.MODULE$.RichAttributeDescriptor(attributeDescriptor))._2())) {
                return Option$.MODULE$.apply((Object)((StructVector)vector.getChild(attributeDescriptor.getLocalName()))).map((Function1 & Serializable)x$6 -> (FieldVector)x$6.getChildrenFromFields().get(1));
            }
            return None$.MODULE$;
        })).headOption();
    }

    public static final /* synthetic */ boolean $anonfun$getFeatureType$5(FieldVector v) {
        FloatingPointPrecision floatingPointPrecision = GeometryFields.precisionFromField((Field)v.getField());
        FloatingPointPrecision floatingPointPrecision2 = FloatingPointPrecision.DOUBLE;
        return !(floatingPointPrecision != null ? !floatingPointPrecision.equals(floatingPointPrecision2) : floatingPointPrecision2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getFeatureType$8(FieldVector x$3) {
        return x$3 instanceof BigIntVector;
    }

    public static final /* synthetic */ boolean $anonfun$isGeometryVector$2(AttributeDescriptor d) {
        return Geometry.class.isAssignableFrom(d.getType().getBinding());
    }

    private SimpleFeatureVector$() {
    }
}

