/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.arrow.io;

import java.io.InputStream;
import java.io.Serializable;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.dictionary.DictionaryProvider;
import org.apache.arrow.vector.types.pojo.DictionaryEncoding;
import org.apache.arrow.vector.types.pojo.Field;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.IncludeFilter;
import org.locationtech.geomesa.arrow.features.ArrowSimpleFeature;
import org.locationtech.geomesa.arrow.filter.ArrowFilterOptimizer$;
import org.locationtech.geomesa.arrow.io.SimpleFeatureArrowFileReader;
import org.locationtech.geomesa.arrow.io.reader.CachingSimpleFeatureArrowFileReader;
import org.locationtech.geomesa.arrow.io.reader.StreamingSimpleFeatureArrowFileReader;
import org.locationtech.geomesa.arrow.vector.ArrowDictionary;
import org.locationtech.geomesa.arrow.vector.ArrowDictionary$;
import org.locationtech.geomesa.arrow.vector.SimpleFeatureVector;
import org.locationtech.geomesa.arrow.vector.SimpleFeatureVector$;
import org.locationtech.geomesa.filter.Bounds;
import org.locationtech.geomesa.filter.Bounds$;
import org.locationtech.geomesa.filter.FilterHelper$;
import org.locationtech.geomesa.utils.geotools.ObjectType$;
import org.locationtech.geomesa.utils.geotools.RichAttributeDescriptors;
import org.locationtech.geomesa.utils.geotools.RichAttributeDescriptors$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$;
import scala.;
import scala.$less$colon$less$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;

public final class SimpleFeatureArrowFileReader$ {
    public static final SimpleFeatureArrowFileReader$ MODULE$ = new SimpleFeatureArrowFileReader$();

    public SimpleFeatureArrowFileReader caching(InputStream is) {
        return new CachingSimpleFeatureArrowFileReader(is);
    }

    public SimpleFeatureArrowFileReader streaming(Function0<InputStream> is) {
        return new StreamingSimpleFeatureArrowFileReader(is);
    }

    public Map<String, ArrowDictionary> loadDictionaries(Seq<Field> fields, DictionaryProvider provider, SimpleFeatureVector.SimpleFeatureEncoding precision) {
        return ((IterableOnceOps)fields.flatMap((Function1 & Serializable)field -> {
            Seq encodings = (Seq)new .colon.colon((Object)field.getDictionary(), (List)Nil$.MODULE$).$plus$plus((IterableOnce)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(field.getChildren()).asScala()).map((Function1 & Serializable)x$1 -> x$1.getDictionary()));
            return (Seq)encodings.collect((PartialFunction)new Serializable((Field)field, provider, precision){
                private static final long serialVersionUID = 0L;
                private final Field field$1;
                private final DictionaryProvider provider$1;
                private final SimpleFeatureVector.SimpleFeatureEncoding precision$1;

                public final <A1 extends DictionaryEncoding, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1 != null) {
                        AttributeDescriptor descriptor = SimpleFeatureTypes$.MODULE$.createDescriptor((String)this.field$1.getMetadata().get(SimpleFeatureVector$.MODULE$.DescriptorKey()));
                        Seq main = ObjectType$.MODULE$.selectType(descriptor);
                        Seq bindings = RichAttributeDescriptors.RichAttributeDescriptor$.MODULE$.isList$extension(RichAttributeDescriptors$.MODULE$.RichAttributeDescriptor(descriptor)) ? (Seq)main.tail() : main;
                        FieldVector vector = this.provider$1.lookup(A1.getId()).getVector();
                        return (B1)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.field$1.getName()), (Object)ArrowDictionary$.MODULE$.create(A1, vector, (Seq<Enumeration.Value>)bindings, this.precision$1));
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(DictionaryEncoding x1) {
                    DictionaryEncoding dictionaryEncoding = x1;
                    return dictionaryEncoding != null;
                }
                {
                    this.field$1 = field$1;
                    this.provider$1 = provider$1;
                    this.precision$1 = precision$1;
                }
            });
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public Function1<SimpleFeatureVector, Iterator<ArrowSimpleFeature>> features(SimpleFeatureType sft, Filter filter, SimpleFeatureArrowFileReader.SkipIndicator skip, Option<Tuple2<String, Object>> sort, Map<String, ArrowDictionary> dictionaries) {
        Some some;
        Tuple2 tuple2;
        Filter optimized = ArrowFilterOptimizer$.MODULE$.rewrite(filter, sft, dictionaries);
        Option<Tuple2<String, Object>> option = sort;
        if (None$.MODULE$.equals(option)) {
            return (Function1 & Serializable)x$2 -> MODULE$.features((SimpleFeatureVector)x$2, optimized);
        }
        if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
            String field = (String)tuple2._1();
            boolean reverse = tuple2._2$mcZ$sp();
            int i = sft.indexOf(field);
            Class binding = sft.getDescriptor(i).getType().getBinding();
            Seq bounds = FilterHelper$.MODULE$.extractAttributeBounds(filter, field, binding).values();
            if (bounds.isEmpty()) {
                return (Function1 & Serializable)x$3 -> MODULE$.features((SimpleFeatureVector)x$3, optimized);
            }
            return (Function1 & Serializable)x$4 -> MODULE$.sortedFeatures((SimpleFeatureVector)x$4, optimized, skip, (Seq<Bounds<Comparable<Object>>>)bounds, i, reverse);
        }
        throw new MatchError(option);
    }

    private Iterator<ArrowSimpleFeature> features(SimpleFeatureVector vector, Filter filter) {
        int total = vector.reader().getValueCount();
        if (total == 0) {
            return package$.MODULE$.Iterator().empty();
        }
        ArrowSimpleFeature feature = vector.reader().feature();
        Iterator all = package$.MODULE$.Iterator().range(0, total).map((Function1 & Serializable)i -> SimpleFeatureArrowFileReader$.$anonfun$features$4(vector, feature, BoxesRunTime.unboxToInt((Object)i)));
        Filter filter2 = filter;
        IncludeFilter includeFilter = Filter.INCLUDE;
        if (!(filter2 != null ? !filter2.equals(includeFilter) : includeFilter != null)) {
            return all;
        }
        return all.filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)filter.evaluate(x$1)));
    }

    private Iterator<ArrowSimpleFeature> sortedFeatures(SimpleFeatureVector vector, Filter filter, SimpleFeatureArrowFileReader.SkipIndicator skip, Seq<Bounds<Comparable<Object>>> filterBounds, int sortField, boolean reverse) {
        Bounds currentBatchBounds;
        int total = vector.reader().getValueCount();
        if (total == 0 || skip.skip()) {
            return package$.MODULE$.Iterator().empty();
        }
        ArrowSimpleFeature feature = vector.reader().feature();
        vector.reader().load(0);
        Bounds.Bound lo = new Bounds.Bound(Option$.MODULE$.apply((Object)((Comparable)feature.getAttribute(sortField))), true);
        vector.reader().load(total - 1);
        Bounds.Bound hi = new Bounds.Bound(Option$.MODULE$.apply((Object)((Comparable)feature.getAttribute(sortField))), true);
        Bounds bounds = currentBatchBounds = reverse ? new Bounds(hi, lo) : new Bounds(lo, hi);
        if (filterBounds.exists((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)SimpleFeatureArrowFileReader$.$anonfun$sortedFeatures$1(currentBatchBounds, x$5)))) {
            Iterator all = package$.MODULE$.Iterator().range(0, vector.reader().getValueCount()).map((Function1 & Serializable)i -> SimpleFeatureArrowFileReader$.$anonfun$sortedFeatures$2(vector, feature, BoxesRunTime.unboxToInt((Object)i)));
            return all.filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)filter.evaluate(x$1)));
        }
        boolean hasMore = reverse ? filterBounds.exists((Function1 & Serializable)fb -> BoxesRunTime.boxToBoolean((boolean)SimpleFeatureArrowFileReader$.$anonfun$sortedFeatures$4(currentBatchBounds, fb))) : filterBounds.exists((Function1 & Serializable)fb -> BoxesRunTime.boxToBoolean((boolean)SimpleFeatureArrowFileReader$.$anonfun$sortedFeatures$5(currentBatchBounds, fb)));
        skip.skip_$eq(!hasMore);
        return package$.MODULE$.Iterator().empty();
    }

    public static final /* synthetic */ ArrowSimpleFeature $anonfun$features$4(SimpleFeatureVector vector$1, ArrowSimpleFeature feature$1, int i) {
        vector$1.reader().load(i);
        return feature$1;
    }

    public static final /* synthetic */ boolean $anonfun$sortedFeatures$1(Bounds currentBatchBounds$1, Bounds x$5) {
        return Bounds$.MODULE$.intersection(x$5, currentBatchBounds$1).isDefined();
    }

    public static final /* synthetic */ ArrowSimpleFeature $anonfun$sortedFeatures$2(SimpleFeatureVector vector$2, ArrowSimpleFeature feature$2, int i) {
        vector$2.reader().load(i);
        return feature$2;
    }

    public static final /* synthetic */ boolean $anonfun$sortedFeatures$4(Bounds currentBatchBounds$1, Bounds fb) {
        return Bounds$.MODULE$.smallerLowerBound(fb.lower(), currentBatchBounds$1.lower()) == fb.lower();
    }

    public static final /* synthetic */ boolean $anonfun$sortedFeatures$5(Bounds currentBatchBounds$1, Bounds fb) {
        return Bounds$.MODULE$.largerUpperBound(fb.upper(), currentBatchBounds$1.upper()) == fb.upper();
    }

    private SimpleFeatureArrowFileReader$() {
    }
}

