/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.arrow.tools.export;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.util.List;
import java.util.Map;
import org.geotools.data.DataStore;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.locationtech.geomesa.arrow.data.ArrowDataStore;
import org.locationtech.geomesa.arrow.tools.ArrowDataStoreCommand;
import org.locationtech.geomesa.arrow.tools.ArrowDataStoreCommand$class;
import org.locationtech.geomesa.arrow.tools.UrlParam;
import org.locationtech.geomesa.arrow.tools.UrlParam$class;
import org.locationtech.geomesa.tools.DataStoreCommand;
import org.locationtech.geomesa.tools.OptionalCqlFilterParam;
import org.locationtech.geomesa.tools.QueryHintsParams;
import org.locationtech.geomesa.tools.export.ExportCommand;
import org.locationtech.geomesa.tools.export.formats.FeatureExporter;
import org.locationtech.geomesa.tools.utils.ParameterConverters;
import org.locationtech.geomesa.utils.stats.MethodProfiling;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001\u0005ea\u0001B\u0001\u0003\u0001=\u0011!#\u0011:s_^,\u0005\u0010]8si\u000e{W.\\1oI*\u00111\u0001B\u0001\u0007Kb\u0004xN\u001d;\u000b\u0005\u00151\u0011!\u0002;p_2\u001c(BA\u0004\t\u0003\u0015\t'O]8x\u0015\tI!\"A\u0004hK>lWm]1\u000b\u0005-a\u0011\u0001\u00047pG\u0006$\u0018n\u001c8uK\u000eD'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001\u0001bC\t\t\u0003#Qi\u0011A\u0005\u0006\u0002'\u0005)1oY1mC&\u0011QC\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0007]QB$D\u0001\u0019\u0015\t\u0019\u0011D\u0003\u0002\u0006\u0011%\u00111\u0004\u0007\u0002\u000e\u000bb\u0004xN\u001d;D_6l\u0017M\u001c3\u0011\u0005u\u0001S\"\u0001\u0010\u000b\u0005}1\u0011\u0001\u00023bi\u0006L!!\t\u0010\u0003\u001d\u0005\u0013(o\\<ECR\f7\u000b^8sKB\u00111\u0005J\u0007\u0002\t%\u0011Q\u0005\u0002\u0002\u0016\u0003J\u0014xn\u001e#bi\u0006\u001cFo\u001c:f\u0007>lW.\u00198e\u0011\u00159\u0003\u0001\"\u0001)\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0006\u0005\u0002+\u00015\t!\u0001C\u0004-\u0001\t\u0007I\u0011I\u0017\u0002\rA\f'/Y7t+\u0005q\u0003CA\u0018G\u001d\t\u0001tH\u0004\u00022}9\u0011!'\u0010\b\u0003gqr!\u0001N\u001e\u000f\u0005URdB\u0001\u001c:\u001b\u00059$B\u0001\u001d\u000f\u0003\u0019a$o\\8u}%\tQ\"\u0003\u0002\f\u0019%\u0011\u0011BC\u0005\u0003\u000f!I!!\u0002\u0004\n\u0005\r!q!\u0002!\u0003\u0011\u0003\t\u0015AE!se><X\t\u001f9peR\u001cu.\\7b]\u0012\u0004\"A\u000b\"\u0007\u000b\u0005\u0011\u0001\u0012A\"\u0014\u0005\t\u0003\u0002\"B\u0014C\t\u0003)E#A!\u0007\t\u001d\u0013\u0005\u0001\u0013\u0002\u0012\u0003J\u0014xn^#ya>\u0014H\u000fU1sC6\u001c8\u0003\u0002$\u0011\u0013R\u0003\"AS)\u000f\u0005-{eB\u0001'O\u001d\t\u0019T*\u0003\u0002\u0006\u0011%\u00111!G\u0005\u0003!b\tQ\"\u0012=q_J$8i\\7nC:$\u0017B\u0001*T\u00051)\u0005\u0010]8siB\u000b'/Y7t\u0015\t\u0001\u0006\u0004\u0005\u0002$+&\u0011a\u000b\u0002\u0002\t+Jd\u0007+\u0019:b[\")qE\u0012C\u00011R\t\u0011\f\u0005\u0002[\r6\t!\t\u000b\u0003G9\u001a<\u0007CA/e\u001b\u0005q&BA0a\u0003)Q7m\\7nC:$WM\u001d\u0006\u0003C\n\fQAY3vgRT\u0011aY\u0001\u0004G>l\u0017BA3_\u0005)\u0001\u0016M]1nKR,'o]\u0001\u0013G>lW.\u00198e\t\u0016\u001c8M]5qi&|g.I\u0001i\u0003%*\u0005\u0010]8si\u00022W-\u0019;ve\u0016\u001c\bE\u001a:p[\u0002\n\u0007eR3p\u001b\u0016\u001c\u0018\r\t3bi\u0006\u00043\u000f^8sK\"1!\u000e\u0001Q\u0001\n9\nq\u0001]1sC6\u001c\b\u0005C\u0003m\u0001\u0011ES.A\u0005hKR\u001c6\r[3nCR\u0011a\u000e\u001f\t\u0003_Zl\u0011\u0001\u001d\u0006\u0003cJ\faa]5na2,'BA:u\u0003\u001d1W-\u0019;ve\u0016T!!\u001e\u0007\u0002\u000f=\u0004XM\\4jg&\u0011q\u000f\u001d\u0002\u0012'&l\u0007\u000f\\3GK\u0006$XO]3UsB,\u0007\"B=l\u0001\u0004a\u0012A\u00013t\u0011\u0015Y\b\u0001\"\u0015}\u0003-9W\r\u001e$fCR,(/Z:\u0015\u000bu\fY!!\u0004\u0011\u0007y\f9!D\u0001\u0000\u0015\r\t\u0018\u0011\u0001\u0006\u0004?\u0005\r!bAA\u0003\u0019\u0005Aq-Z8u_>d7/C\u0002\u0002\n}\u0014qcU5na2,g)Z1ukJ,7i\u001c7mK\u000e$\u0018n\u001c8\t\u000beT\b\u0019\u0001\u000f\t\u000f\u0005=!\u00101\u0001\u0002\u0012\u0005)\u0011/^3ssB!\u00111CA\u000b\u001b\t\t\t!\u0003\u0003\u0002\u0018\u0005\u0005!!B)vKJL\b")
public class ArrowExportCommand
implements ExportCommand<ArrowDataStore>,
ArrowDataStoreCommand {
    private final ArrowExportParams params;
    private final String name;
    private final Logger logger;
    private volatile boolean bitmap$0;

    @Override
    public scala.collection.immutable.Map<String, String> connection() {
        return ArrowDataStoreCommand$class.connection(this);
    }

    public String name() {
        return this.name;
    }

    public void org$locationtech$geomesa$tools$export$ExportCommand$_setter_$name_$eq(String x$1) {
        this.name = x$1;
    }

    public void execute() {
        ExportCommand.class.execute((ExportCommand)this);
    }

    public Option export(DataStore ds) {
        return ExportCommand.class.export((ExportCommand)this, (DataStore)ds);
    }

    public Option<Object> export(FeatureExporter exporter, SimpleFeatureCollection collection) {
        return ExportCommand.class.export((ExportCommand)this, (FeatureExporter)exporter, (SimpleFeatureCollection)collection);
    }

    public <R> R profile(Function1<Object, BoxedUnit> onComplete, Function0<R> code) {
        return (R)MethodProfiling.class.profile((MethodProfiling)this, onComplete, code);
    }

    public <R> R profile(Function2<R, Object, BoxedUnit> onComplete, Function0<R> code) {
        return (R)MethodProfiling.class.profile((MethodProfiling)this, onComplete, code);
    }

    public <R> R profile(String message, Function0<R> code) {
        return (R)MethodProfiling.class.profile((MethodProfiling)this, (String)message, code);
    }

    private Logger logger$lzycompute() {
        ArrowExportCommand arrowExportCommand = this;
        synchronized (arrowExportCommand) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public <T> T withDataStore(Function1<ArrowDataStore, T> method) throws ParameterException {
        return (T)DataStoreCommand.class.withDataStore((DataStoreCommand)this, method);
    }

    public DataStore loadDataStore() throws ParameterException {
        return DataStoreCommand.class.loadDataStore((DataStoreCommand)this);
    }

    @Override
    public ArrowExportParams params() {
        return this.params;
    }

    public SimpleFeatureType getSchema(ArrowDataStore ds) {
        return ds.getSchema();
    }

    public SimpleFeatureCollection getFeatures(ArrowDataStore ds, Query query) {
        return ds.getFeatureSource().getFeatures(query);
    }

    public ArrowExportCommand() {
        DataStoreCommand.class.$init$((DataStoreCommand)this);
        LazyLogging.class.$init$((LazyLogging)this);
        MethodProfiling.class.$init$((MethodProfiling)this);
        ExportCommand.class.$init$((ExportCommand)this);
        ArrowDataStoreCommand$class.$init$(this);
        this.params = new ArrowExportParams();
    }

    @Parameters(commandDescription="Export features from a GeoMesa data store")
    public static class ArrowExportParams
    implements ExportCommand.ExportParams,
    UrlParam {
        @Parameter(names={"--url", "-u"}, description="URL for an Arrow resource, or path to an arrow file", required=true)
        private String url;
        @Parameter(names={"-o", "--output"}, description="Output to a file instead of std out")
        private String file;
        @Parameter(names={"--gzip"}, description="Level of gzip compression to apply to output, from 1-9")
        private Integer gzip;
        @Parameter(names={"-F", "--output-format"}, description="File format of output files (csv|tsv|gml|json|shp|avro|leaflet|orc|parquet|arrow)", required=false, converter=ParameterConverters.ExportFormatConverter.class)
        private Enumeration.Value outputFormat;
        @Parameter(names={"--no-header"}, description="Export as a delimited text format (csv|tsv) without a type header", required=false)
        private boolean noHeader;
        @Parameter(names={"-m", "--max-features"}, description="Maximum number of features to return. default: Unlimited")
        private Integer maxFeatures;
        @Parameter(names={"-a", "--attributes"}, description="Attributes from feature to export (comma-separated)...Comma-separated expressions with each in the format attribute[=filter_function_expression]|derived-attribute=filter_function_expression|'id'. 'id' will export the feature ID, filter_function_expression is an expression of filter function applied to attributes, literals and filter functions, i.e. can be nested")
        private List<String> attributes;
        @Parameter(names={"--hints"}, description="Query hints to set, in the form key1=value1;key2=value2", required=false, converter=ParameterConverters.HintConverter.class)
        private Map<String, String> hints;
        @Parameter(names={"-q", "--cql"}, description="CQL predicate", converter=ParameterConverters.FilterConverter.class)
        private Filter cqlFilter;

        @Override
        public String url() {
            return this.url;
        }

        @Override
        @TraitSetter
        public void url_$eq(String x$1) {
            this.url = x$1;
        }

        public String file() {
            return this.file;
        }

        public void file_$eq(String x$1) {
            this.file = x$1;
        }

        public Integer gzip() {
            return this.gzip;
        }

        public void gzip_$eq(Integer x$1) {
            this.gzip = x$1;
        }

        public Enumeration.Value outputFormat() {
            return this.outputFormat;
        }

        public void outputFormat_$eq(Enumeration.Value x$1) {
            this.outputFormat = x$1;
        }

        public boolean noHeader() {
            return this.noHeader;
        }

        public void noHeader_$eq(boolean x$1) {
            this.noHeader = x$1;
        }

        public Integer maxFeatures() {
            return this.maxFeatures;
        }

        public void maxFeatures_$eq(Integer x$1) {
            this.maxFeatures = x$1;
        }

        public List<String> attributes() {
            return this.attributes;
        }

        public void attributes_$eq(List<String> x$1) {
            this.attributes = x$1;
        }

        public Map<String, String> hints() {
            return this.hints;
        }

        public void hints_$eq(Map<String, String> x$1) {
            this.hints = x$1;
        }

        public Filter cqlFilter() {
            return this.cqlFilter;
        }

        public void cqlFilter_$eq(Filter x$1) {
            this.cqlFilter = x$1;
        }

        public ArrowExportParams() {
            OptionalCqlFilterParam.class.$init$((OptionalCqlFilterParam)this);
            QueryHintsParams.class.$init$((QueryHintsParams)this);
            ExportCommand.ExportParams.class.$init$((ExportCommand.ExportParams)this);
            UrlParam$class.$init$(this);
        }
    }
}

