/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.arrow.tools.ingest;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.typesafe.config.Config;
import java.io.File;
import java.util.List;
import org.geotools.data.DataStore;
import org.locationtech.geomesa.arrow.data.ArrowDataStore;
import org.locationtech.geomesa.arrow.tools.ArrowDataStoreCommand;
import org.locationtech.geomesa.arrow.tools.ArrowDataStoreCommand$UrlParam$class;
import org.locationtech.geomesa.arrow.tools.ArrowDataStoreCommand$class;
import org.locationtech.geomesa.jobs.package;
import org.locationtech.geomesa.tools.ConverterConfigParam;
import org.locationtech.geomesa.tools.DistributedCombineParam;
import org.locationtech.geomesa.tools.DistributedRunParam;
import org.locationtech.geomesa.tools.InputFilesParam;
import org.locationtech.geomesa.tools.OptionalFeatureSpecParam;
import org.locationtech.geomesa.tools.OptionalForceParam;
import org.locationtech.geomesa.tools.OptionalInputFormatParam;
import org.locationtech.geomesa.tools.OptionalTypeNameParam;
import org.locationtech.geomesa.tools.data.CreateSchemaCommand;
import org.locationtech.geomesa.tools.ingest.IngestCommand;
import org.locationtech.geomesa.tools.package;
import org.locationtech.geomesa.tools.utils.ParameterConverters;
import org.locationtech.geomesa.utils.io.PathUtils$;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001u4A!\u0001\u0002\u0001\u001f\t\u0011\u0012I\u001d:po&sw-Z:u\u0007>lW.\u00198e\u0015\t\u0019A!\u0001\u0004j]\u001e,7\u000f\u001e\u0006\u0003\u000b\u0019\tQ\u0001^8pYNT!a\u0002\u0005\u0002\u000b\u0005\u0014(o\\<\u000b\u0005%Q\u0011aB4f_6,7/\u0019\u0006\u0003\u00171\tA\u0002\\8dCRLwN\u001c;fG\"T\u0011!D\u0001\u0004_J<7\u0001A\n\u0005\u0001AAB\u0005\u0005\u0002\u0012-5\t!C\u0003\u0002\u0014)\u0005!A.\u00198h\u0015\u0005)\u0012\u0001\u00026bm\u0006L!a\u0006\n\u0003\r=\u0013'.Z2u!\rIBDH\u0007\u00025)\u00111a\u0007\u0006\u0003\u000b!I!!\b\u000e\u0003\u001b%sw-Z:u\u0007>lW.\u00198e!\ty\"%D\u0001!\u0015\t\tc!\u0001\u0003eCR\f\u0017BA\u0012!\u00059\t%O]8x\t\u0006$\u0018m\u0015;pe\u0016\u0004\"!\n\u0014\u000e\u0003\u0011I!a\n\u0003\u0003+\u0005\u0013(o\\<ECR\f7\u000b^8sK\u000e{W.\\1oI\")\u0011\u0006\u0001C\u0001U\u00051A(\u001b8jiz\"\u0012a\u000b\t\u0003Y\u0001i\u0011A\u0001\u0005\b]\u0001\u0011\r\u0011\"\u00110\u0003\u0019\u0001\u0018M]1ngV\t\u0001\u0007\u0005\u00022\u001d:\u0011!'\u0011\b\u0003g\u0001s!\u0001N \u000f\u0005UrdB\u0001\u001c>\u001d\t9DH\u0004\u00029w5\t\u0011H\u0003\u0002;\u001d\u00051AH]8pizJ\u0011!D\u0005\u0003\u00171I!!\u0003\u0006\n\u0005\u001dA\u0011BA\u0003\u0007\u0013\t\u0019AaB\u0003C\u0005!\u00051)\u0001\nBeJ|w/\u00138hKN$8i\\7nC:$\u0007C\u0001\u0017E\r\u0015\t!\u0001#\u0001F'\t!e\t\u0005\u0002H\u00156\t\u0001JC\u0001J\u0003\u0015\u00198-\u00197b\u0013\tY\u0005J\u0001\u0004B]f\u0014VM\u001a\u0005\u0006S\u0011#\t!\u0014\u000b\u0002\u0007\u001a!q\n\u0012\u0001Q\u0005E\t%O]8x\u0013:<Wm\u001d;QCJ\fWn]\n\u0005\u001d\u001a\u000bF\f\u0005\u0002S3:\u00111k\u0016\b\u0003)Zs!!N+\n\u0005\u0015A\u0011BA\u0002\u001c\u0013\tA&$A\u0007J]\u001e,7\u000f^\"p[6\fg\u000eZ\u0005\u00035n\u0013A\"\u00138hKN$\b+\u0019:b[NT!\u0001\u0017\u000e\u0011\u0005u\u0003gBA\u001a_\u0013\tyF!A\u000bBeJ|w\u000fR1uCN#xN]3D_6l\u0017M\u001c3\n\u0005\u0005\u0014'\u0001C+sYB\u000b'/Y7\u000b\u0005}#\u0001\"B\u0015O\t\u0003!G#A3\u0011\u0005\u0019tU\"\u0001#)\t9C'o\u001d\t\u0003SBl\u0011A\u001b\u0006\u0003W2\f!B[2p[6\fg\u000eZ3s\u0015\tig.A\u0003cKV\u001cHOC\u0001p\u0003\r\u0019w.\\\u0005\u0003c*\u0014!\u0002U1sC6,G/\u001a:t\u0003I\u0019w.\\7b]\u0012$Um]2sSB$\u0018n\u001c8\"\u0003Q\f\u0001'\u00138hKN$xfY8om\u0016\u0014H\u000f\t<be&|Wo\u001d\u0011gS2,\u0007EZ8s[\u0006$8\u000fI5oi>\u0004s)Z8NKN\f\u0007B\u0002<\u0001A\u0003%\u0001'A\u0004qCJ\fWn\u001d\u0011\t\u000ba\u0004A\u0011I=\u0002\u000f\u0015DXmY;uKR\t!\u0010\u0005\u0002Hw&\u0011A\u0010\u0013\u0002\u0005+:LG\u000f")
public class ArrowIngestCommand
implements IngestCommand<ArrowDataStore>,
ArrowDataStoreCommand {
    private final ArrowIngestParams params;
    private final String name;
    private Object org$locationtech$geomesa$tools$InteractiveCommand$$_console;

    @Override
    public Map<String, String> connection() {
        return ArrowDataStoreCommand$class.connection(this);
    }

    public String name() {
        return this.name;
    }

    public void org$locationtech$geomesa$tools$ingest$IngestCommand$_setter_$name_$eq(String x$1) {
        this.name = x$1;
    }

    public Seq<String> libjarsFiles() {
        return IngestCommand.class.libjarsFiles((IngestCommand)this);
    }

    public package.Awaitable startIngest(Enumeration.Value mode, DataStore ds, SimpleFeatureType sft, Config converter, IngestCommand.Inputs inputs) {
        return IngestCommand.class.startIngest((IngestCommand)this, (Enumeration.Value)mode, (DataStore)ds, (SimpleFeatureType)sft, (Config)converter, (IngestCommand.Inputs)inputs);
    }

    public void setBackendSpecificOptions(SimpleFeatureType sft) {
        CreateSchemaCommand.SchemaOptionsCommand.class.setBackendSpecificOptions((CreateSchemaCommand.SchemaOptionsCommand)this, (SimpleFeatureType)sft);
    }

    public Object org$locationtech$geomesa$tools$InteractiveCommand$$_console() {
        return this.org$locationtech$geomesa$tools$InteractiveCommand$$_console;
    }

    public void org$locationtech$geomesa$tools$InteractiveCommand$$_console_$eq(Object x$1) {
        this.org$locationtech$geomesa$tools$InteractiveCommand$$_console = x$1;
    }

    public Object console() {
        return package.InteractiveCommand.class.console((package.InteractiveCommand)this);
    }

    public void setConsole(Object c) {
        package.InteractiveCommand.class.setConsole((package.InteractiveCommand)this, (Object)c);
    }

    public Iterator<Function0<Seq<File>>> libjarsPaths() {
        return package.DistributedCommand.class.libjarsPaths((package.DistributedCommand)this);
    }

    public <T> T withDataStore(Function1<ArrowDataStore, T> method) throws ParameterException {
        return (T)package.DataStoreCommand.class.withDataStore((package.DataStoreCommand)this, method);
    }

    public DataStore loadDataStore() throws ParameterException {
        return package.DataStoreCommand.class.loadDataStore((package.DataStoreCommand)this);
    }

    public Seq<package.Command> subCommands() {
        return package.Command.class.subCommands((package.Command)this);
    }

    public Option<ParameterException> validate() {
        return package.Command.class.validate((package.Command)this);
    }

    public void run() {
        package.Command.class.run((package.Command)this);
    }

    @Override
    public ArrowIngestParams params() {
        return this.params;
    }

    public void execute() {
        if (((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.params().files()).asScala()).exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String path) {
                return PathUtils$.MODULE$.isRemote(path);
            }
        })) {
            throw new ParameterException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Only local ingestion supported: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.params().files()})));
        }
        IngestCommand.class.execute((IngestCommand)this);
    }

    public ArrowIngestCommand() {
        package.Command.class.$init$((package.Command)this);
        package.DataStoreCommand.class.$init$((package.DataStoreCommand)this);
        package.DistributedCommand.class.$init$((package.DistributedCommand)this);
        package.InteractiveCommand.class.$init$((package.InteractiveCommand)this);
        CreateSchemaCommand.SchemaOptionsCommand.class.$init$((CreateSchemaCommand.SchemaOptionsCommand)this);
        IngestCommand.class.$init$((IngestCommand)this);
        ArrowDataStoreCommand$class.$init$(this);
        this.params = new ArrowIngestParams();
    }

    @Parameters(commandDescription="Ingest/convert various file formats into GeoMesa")
    public static class ArrowIngestParams
    implements IngestCommand.IngestParams,
    ArrowDataStoreCommand.UrlParam {
        @Parameter(names={"--url", "-u"}, description="URL for an Arrow resource, or path to an arrow file", required=true)
        private String url;
        @Parameter(names={"-t", "--threads"}, description="Number of threads if using local ingest")
        private Integer threads;
        @Parameter(names={"--src-list"}, description="Input files are text files with lists of files, one per line, to ingest.")
        private boolean srcList;
        @Parameter(names={"--no-tracking"}, description="Return immediately after submitting ingest job (distributed jobs)")
        private boolean noWaitForCompletion;
        @Parameter(names={"--combine-inputs"}, description="Combine multiple input files into a single input split (distributed jobs)")
        private boolean combineInputs;
        @Parameter(names={"--split-max-size"}, description="Maximum size of a split in bytes (distributed jobs)")
        private Integer maxSplitSize;
        @Parameter(names={"--run-mode"}, description="Run locally or on a cluster", required=false)
        private String runMode;
        private final Option<Enumeration.Value> mode;
        @Parameter(names={"--input-format"}, description="File format of input files (shp, csv, tsv, avro, etc). Optional, auto-detection will be attempted")
        private String inputFormat;
        @Parameter(description="<file>...")
        private List<String> files;
        @Parameter(names={"-C", "--converter"}, description="GeoMesa converter specification as a config string, file name, or name of an available converter")
        private String config;
        @Parameter(names={"--converter-error-mode"}, description="Override the converter error mode - 'skip-bad-records' or 'raise-errors'", converter=ParameterConverters.ErrorModeConverter.class)
        private Enumeration.Value errorMode;
        @Parameter(names={"--force"}, description="Force execution without prompt")
        private boolean force;
        @Parameter(names={"-s", "--spec"}, description="SimpleFeatureType specification as a GeoTools spec string, SFT config, or file with either")
        private String spec;
        @Parameter(names={"-f", "--feature-name"}, description="Simple Feature Type name on which to operate")
        private String featureName;
        private volatile boolean bitmap$0;

        @Override
        public String url() {
            return this.url;
        }

        @Override
        @TraitSetter
        public void url_$eq(String x$1) {
            this.url = x$1;
        }

        public Integer threads() {
            return this.threads;
        }

        public void threads_$eq(Integer x$1) {
            this.threads = x$1;
        }

        public boolean srcList() {
            return this.srcList;
        }

        public void srcList_$eq(boolean x$1) {
            this.srcList = x$1;
        }

        public boolean noWaitForCompletion() {
            return this.noWaitForCompletion;
        }

        public void noWaitForCompletion_$eq(boolean x$1) {
            this.noWaitForCompletion = x$1;
        }

        public boolean waitForCompletion() {
            return IngestCommand.IngestParams.class.waitForCompletion((IngestCommand.IngestParams)this);
        }

        public boolean combineInputs() {
            return this.combineInputs;
        }

        public void combineInputs_$eq(boolean x$1) {
            this.combineInputs = x$1;
        }

        public Integer maxSplitSize() {
            return this.maxSplitSize;
        }

        public void maxSplitSize_$eq(Integer x$1) {
            this.maxSplitSize = x$1;
        }

        public String runMode() {
            return this.runMode;
        }

        public void runMode_$eq(String x$1) {
            this.runMode = x$1;
        }

        private Option mode$lzycompute() {
            ArrowIngestParams arrowIngestParams = this;
            synchronized (arrowIngestParams) {
                if (!this.bitmap$0) {
                    this.mode = DistributedRunParam.class.mode((DistributedRunParam)this);
                    this.bitmap$0 = true;
                }
                return this.mode;
            }
        }

        public Option<Enumeration.Value> mode() {
            return this.bitmap$0 ? this.mode : this.mode$lzycompute();
        }

        public String inputFormat() {
            return this.inputFormat;
        }

        public void inputFormat_$eq(String x$1) {
            this.inputFormat = x$1;
        }

        public List<String> files() {
            return this.files;
        }

        public void files_$eq(List<String> x$1) {
            this.files = x$1;
        }

        public String config() {
            return this.config;
        }

        public void config_$eq(String x$1) {
            this.config = x$1;
        }

        public Enumeration.Value errorMode() {
            return this.errorMode;
        }

        public void errorMode_$eq(Enumeration.Value x$1) {
            this.errorMode = x$1;
        }

        public boolean force() {
            return this.force;
        }

        public void force_$eq(boolean x$1) {
            this.force = x$1;
        }

        public String spec() {
            return this.spec;
        }

        public void spec_$eq(String x$1) {
            this.spec = x$1;
        }

        public String featureName() {
            return this.featureName;
        }

        public void featureName_$eq(String x$1) {
            this.featureName = x$1;
        }

        public ArrowIngestParams() {
            OptionalTypeNameParam.class.$init$((OptionalTypeNameParam)this);
            OptionalFeatureSpecParam.class.$init$((OptionalFeatureSpecParam)this);
            OptionalForceParam.class.$init$((OptionalForceParam)this);
            ConverterConfigParam.class.$init$((ConverterConfigParam)this);
            InputFilesParam.class.$init$((InputFilesParam)this);
            OptionalInputFormatParam.class.$init$((OptionalInputFormatParam)this);
            DistributedRunParam.class.$init$((DistributedRunParam)this);
            DistributedCombineParam.class.$init$((DistributedCombineParam)this);
            IngestCommand.IngestParams.class.$init$((IngestCommand.IngestParams)this);
            ArrowDataStoreCommand$UrlParam$class.$init$(this);
        }
    }
}

