/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.arrow.tools.export;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.validators.PositiveInteger;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.mapreduce.Job;
import org.geotools.data.DataStore;
import org.geotools.data.Query;
import org.locationtech.geomesa.arrow.data.ArrowDataStore;
import org.locationtech.geomesa.arrow.tools.ArrowDataStoreCommand;
import org.locationtech.geomesa.tools.DistributedRunParam;
import org.locationtech.geomesa.tools.NumReducersParam;
import org.locationtech.geomesa.tools.OptionalCqlFilterParam;
import org.locationtech.geomesa.tools.OptionalForceParam;
import org.locationtech.geomesa.tools.ProvidedTypeNameParam;
import org.locationtech.geomesa.tools.QueryHintsParams;
import org.locationtech.geomesa.tools.export.ExportCommand;
import org.locationtech.geomesa.tools.export.formats.ExportFormat;
import org.locationtech.geomesa.tools.export.formats.FeatureExporter;
import org.locationtech.geomesa.tools.package;
import org.locationtech.geomesa.tools.utils.NoopParameterSplitter;
import org.locationtech.geomesa.tools.utils.ParameterConverters;
import org.locationtech.geomesa.utils.stats.MethodProfiling;
import org.opengis.filter.Filter;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001m4A!\u0003\u0006\u0001/!)\u0001\u0007\u0001C\u0001c!9A\u0007\u0001b\u0001\n\u0003*\u0004B\u0002>\u0001A\u0003%agB\u0003H\u0015!\u0005\u0001JB\u0003\n\u0015!\u0005\u0011\nC\u00031\u000b\u0011\u0005\u0001K\u0002\u0003R\u000b\u0001\u0011\u0006\"\u0002\u0019\b\t\u0003I'AE!se><X\t\u001f9peR\u001cu.\\7b]\u0012T!a\u0003\u0007\u0002\r\u0015D\bo\u001c:u\u0015\tia\"A\u0003u_>d7O\u0003\u0002\u0010!\u0005)\u0011M\u001d:po*\u0011\u0011CE\u0001\bO\u0016|W.Z:b\u0015\t\u0019B#\u0001\u0007m_\u000e\fG/[8oi\u0016\u001c\u0007NC\u0001\u0016\u0003\ry'oZ\u0002\u0001'\u0011\u0001\u0001\u0004\t\u0017\u0011\u0005eqR\"\u0001\u000e\u000b\u0005ma\u0012\u0001\u00027b]\u001eT\u0011!H\u0001\u0005U\u00064\u0018-\u0003\u0002 5\t1qJ\u00196fGR\u00042!\t\u0013'\u001b\u0005\u0011#BA\u0006$\u0015\ti\u0001#\u0003\u0002&E\tiQ\t\u001f9peR\u001cu.\\7b]\u0012\u0004\"a\n\u0016\u000e\u0003!R!!\u000b\b\u0002\t\u0011\fG/Y\u0005\u0003W!\u0012a\"\u0011:s_^$\u0015\r^1Ti>\u0014X\r\u0005\u0002.]5\tA\"\u0003\u00020\u0019\t)\u0012I\u001d:po\u0012\u000bG/Y*u_J,7i\\7nC:$\u0017A\u0002\u001fj]&$h\bF\u00013!\t\u0019\u0004!D\u0001\u000b\u0003\u0019\u0001\u0018M]1ngV\ta\u0007\u0005\u00028\u000f9\u0011\u0001\b\u0002\b\u0003s\u0019s!AO#\u000f\u0005m\"eB\u0001\u001fD\u001d\ti$I\u0004\u0002?\u00036\tqH\u0003\u0002A-\u00051AH]8pizJ\u0011!F\u0005\u0003'QI!!\u0005\n\n\u0005=\u0001\u0012BA\u0007\u000f\u0013\tYA\"\u0001\nBeJ|w/\u0012=q_J$8i\\7nC:$\u0007CA\u001a\u0006'\t)!\n\u0005\u0002L\u001d6\tAJC\u0001N\u0003\u0015\u00198-\u00197b\u0013\tyEJ\u0001\u0004B]f\u0014VM\u001a\u000b\u0002\u0011\n\t\u0012I\u001d:po\u0016C\bo\u001c:u!\u0006\u0014\u0018-\\:\u0014\u000b\u001dQ5KX3\u0011\u0005Q[fBA+Z\u001d\t1\u0006L\u0004\u0002</&\u0011Q\u0002E\u0005\u0003\u0017\rJ!A\u0017\u0012\u0002\u001b\u0015C\bo\u001c:u\u0007>lW.\u00198e\u0013\taVL\u0001\u0007FqB|'\u000f\u001e)be\u0006l7O\u0003\u0002[EA\u0011qL\u0019\b\u0003s\u0001L!!\u0019\u0007\u0002+\u0005\u0013(o\\<ECR\f7\u000b^8sK\u000e{W.\\1oI&\u00111\r\u001a\u0002\t+Jd\u0007+\u0019:b[*\u0011\u0011\r\u0004\t\u0003M\u001el\u0011aI\u0005\u0003Q\u000e\u0012Q\u0003\u0015:pm&$W\r\u001a+za\u0016t\u0015-\\3QCJ\fW\u000eF\u0001k!\tYw!D\u0001\u0006Q\u00119Qn\u001e=\u0011\u00059,X\"A8\u000b\u0005A\f\u0018A\u00036d_6l\u0017M\u001c3fe*\u0011!o]\u0001\u0006E\u0016,8\u000f\u001e\u0006\u0002i\u0006\u00191m\\7\n\u0005Y|'A\u0003)be\u0006lW\r^3sg\u0006\u00112m\\7nC:$G)Z:de&\u0004H/[8oC\u0005I\u0018!K#ya>\u0014H\u000f\t4fCR,(/Z:!MJ|W\u000eI1!\u000f\u0016|W*Z:bA\u0011\fG/\u0019\u0011ti>\u0014X-A\u0004qCJ\fWn\u001d\u0011")
public class ArrowExportCommand
implements ExportCommand<ArrowDataStore>,
ArrowDataStoreCommand {
    private final ArrowExportParams params;
    private final String name;
    private Logger logger;
    private Object org$locationtech$geomesa$tools$InteractiveCommand$$_console;
    private volatile boolean bitmap$0;

    @Override
    public scala.collection.immutable.Map<String, String> connection() {
        return ArrowDataStoreCommand.connection$(this);
    }

    public Seq<String> libjarsFiles() {
        return ExportCommand.libjarsFiles$((ExportCommand)this);
    }

    public void execute() {
        ExportCommand.execute$((ExportCommand)this);
    }

    public Option export(DataStore ds, Query query, FeatureExporter exporter, boolean writeEmptyFiles) {
        return ExportCommand.export$((ExportCommand)this, (DataStore)ds, (Query)query, (FeatureExporter)exporter, (boolean)writeEmptyFiles);
    }

    public void configure(Job job, DataStore ds, Query query) {
        ExportCommand.configure$((ExportCommand)this, (Job)job, (DataStore)ds, (Query)query);
    }

    public <R> R profile(Function1<Object, BoxedUnit> onComplete, Function0<R> code) {
        return (R)MethodProfiling.profile$((MethodProfiling)this, onComplete, code);
    }

    public <R> R profile(Function2<R, Object, BoxedUnit> onComplete, Function0<R> code) {
        return (R)MethodProfiling.profile$((MethodProfiling)this, onComplete, code);
    }

    public <R> R profile(String message, Function0<R> code) {
        return (R)MethodProfiling.profile$((MethodProfiling)this, (String)message, code);
    }

    public Object console() {
        return package.InteractiveCommand.console$((package.InteractiveCommand)this);
    }

    public void setConsole(Object c) {
        package.InteractiveCommand.setConsole$((package.InteractiveCommand)this, (Object)c);
    }

    public Iterator<Function0<Seq<File>>> libjarsPaths() {
        return package.DistributedCommand.libjarsPaths$((package.DistributedCommand)this);
    }

    public <T> T withDataStore(Function1<ArrowDataStore, T> method) throws ParameterException {
        return (T)package.DataStoreCommand.withDataStore$((package.DataStoreCommand)this, method);
    }

    public DataStore loadDataStore() throws ParameterException {
        return package.DataStoreCommand.loadDataStore$((package.DataStoreCommand)this);
    }

    public Seq<package.Command> subCommands() {
        return package.Command.subCommands$((package.Command)this);
    }

    public Option<ParameterException> validate() {
        return package.Command.validate$((package.Command)this);
    }

    public void run() {
        package.Command.run$((package.Command)this);
    }

    public String name() {
        return this.name;
    }

    public void org$locationtech$geomesa$tools$export$ExportCommand$_setter_$name_$eq(String x$1) {
        this.name = x$1;
    }

    private Logger logger$lzycompute() {
        ArrowExportCommand arrowExportCommand = this;
        synchronized (arrowExportCommand) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    public Object org$locationtech$geomesa$tools$InteractiveCommand$$_console() {
        return this.org$locationtech$geomesa$tools$InteractiveCommand$$_console;
    }

    public void org$locationtech$geomesa$tools$InteractiveCommand$$_console_$eq(Object x$1) {
        this.org$locationtech$geomesa$tools$InteractiveCommand$$_console = x$1;
    }

    @Override
    public ArrowExportParams params() {
        return this.params;
    }

    public ArrowExportCommand() {
        package.Command.$init$((package.Command)this);
        package.DataStoreCommand.$init$((package.DataStoreCommand)this);
        package.DistributedCommand.$init$((package.DistributedCommand)this);
        package.InteractiveCommand.$init$((package.InteractiveCommand)this);
        LazyLogging.$init$((LazyLogging)this);
        MethodProfiling.$init$((MethodProfiling)this);
        ExportCommand.$init$((ExportCommand)this);
        ArrowDataStoreCommand.$init$(this);
        this.params = new ArrowExportParams();
    }

    @Parameters(commandDescription="Export features from a GeoMesa data store")
    public static class ArrowExportParams
    implements ExportCommand.ExportParams,
    ArrowDataStoreCommand.UrlParam,
    ProvidedTypeNameParam {
        private String featureName;
        @Parameter(names={"--url", "-u"}, description="URL for an Arrow resource, or path to an arrow file", required=true)
        private String url;
        @Parameter(names={"-o", "--output"}, description="Output to a file instead of std out")
        private String file;
        @Parameter(names={"--gzip"}, description="Level of gzip compression to apply to output, from 1-9")
        private Integer gzip;
        @Parameter(names={"--no-header"}, description="Export as a delimited text format (csv|tsv) without a type header")
        private boolean noHeader;
        @Parameter(names={"--suppress-empty"}, description="Suppress all output (headers, etc) if there are no features exported")
        private boolean suppressEmpty;
        @Parameter(names={"-m", "--max-features"}, description="Restrict the maximum number of features returned")
        private Integer maxFeatures;
        @Parameter(names={"--attribute"}, description="Attributes or derived expressions to export, or 'id' to include the feature ID", splitter=NoopParameterSplitter.class)
        private List<String> transforms;
        @Parameter(names={"-a", "--attributes"}, description="Comma-separated attributes to export, or 'id' to include the feature ID")
        private List<String> attributes;
        @Parameter(names={"--sort-by"}, description="Sort by the specified attributes (comma-delimited)")
        private List<String> sortFields;
        @Parameter(names={"--sort-descending"}, description="Sort in descending order, instead of ascending", arity=0)
        private boolean sortDescending;
        @Parameter(names={"--chunk-size"}, description="Split the output into multiple files, by specifying the rough number of bytes to store per file", converter=ParameterConverters.BytesConverter.class)
        private Long chunkSize;
        @Parameter(names={"-F", "--output-format"}, description="File format of output files (csv|tsv|gml|json|shp|avro|leaflet|orc|parquet|arrow)", converter=ParameterConverters.ExportFormatConverter.class)
        private ExportFormat explicitOutputFormat;
        private ExportFormat outputFormat;
        @Parameter(names={"--force"}, description="Force execution without prompt")
        private boolean force;
        @Parameter(names={"--num-reducers"}, description="Number of reducers to use when sorting or merging (for distributed jobs)", validateWith={PositiveInteger.class})
        private Integer reducers;
        @Parameter(names={"--run-mode"}, description="Run locally or on a cluster", required=false)
        private String runMode;
        private Option<Enumeration.Value> mode;
        @Parameter(names={"--hints"}, description="Query hints to set, in the form key1=value1;key2=value2", required=false, converter=ParameterConverters.HintConverter.class)
        private Map<String, String> hints;
        @Parameter(names={"-q", "--cql"}, description="CQL predicate", converter=ParameterConverters.FilterConverter.class)
        private Filter cqlFilter;
        private volatile byte bitmap$0;

        public String featureName() {
            return this.featureName;
        }

        public void featureName_$eq(String x$1) {
            this.featureName = x$1;
        }

        @Override
        public String url() {
            return this.url;
        }

        @Override
        public void url_$eq(String x$1) {
            this.url = x$1;
        }

        public String file() {
            return this.file;
        }

        public void file_$eq(String x$1) {
            this.file = x$1;
        }

        public Integer gzip() {
            return this.gzip;
        }

        public void gzip_$eq(Integer x$1) {
            this.gzip = x$1;
        }

        public boolean noHeader() {
            return this.noHeader;
        }

        public void noHeader_$eq(boolean x$1) {
            this.noHeader = x$1;
        }

        public boolean suppressEmpty() {
            return this.suppressEmpty;
        }

        public void suppressEmpty_$eq(boolean x$1) {
            this.suppressEmpty = x$1;
        }

        public Integer maxFeatures() {
            return this.maxFeatures;
        }

        public void maxFeatures_$eq(Integer x$1) {
            this.maxFeatures = x$1;
        }

        public List<String> transforms() {
            return this.transforms;
        }

        public void transforms_$eq(List<String> x$1) {
            this.transforms = x$1;
        }

        public List<String> attributes() {
            return this.attributes;
        }

        public void attributes_$eq(List<String> x$1) {
            this.attributes = x$1;
        }

        public List<String> sortFields() {
            return this.sortFields;
        }

        public void sortFields_$eq(List<String> x$1) {
            this.sortFields = x$1;
        }

        public boolean sortDescending() {
            return this.sortDescending;
        }

        public void sortDescending_$eq(boolean x$1) {
            this.sortDescending = x$1;
        }

        public Long chunkSize() {
            return this.chunkSize;
        }

        public void chunkSize_$eq(Long x$1) {
            this.chunkSize = x$1;
        }

        public ExportFormat explicitOutputFormat() {
            return this.explicitOutputFormat;
        }

        public void explicitOutputFormat_$eq(ExportFormat x$1) {
            this.explicitOutputFormat = x$1;
        }

        private ExportFormat outputFormat$lzycompute() {
            ArrowExportParams arrowExportParams = this;
            synchronized (arrowExportParams) {
                if ((byte)(this.bitmap$0 & 1) == 0) {
                    this.outputFormat = ExportCommand.ExportParams.outputFormat$((ExportCommand.ExportParams)this);
                    this.bitmap$0 = (byte)(this.bitmap$0 | 1);
                }
            }
            return this.outputFormat;
        }

        public ExportFormat outputFormat() {
            return (byte)(this.bitmap$0 & 1) == 0 ? this.outputFormat$lzycompute() : this.outputFormat;
        }

        public boolean force() {
            return this.force;
        }

        public void force_$eq(boolean x$1) {
            this.force = x$1;
        }

        public Integer reducers() {
            return this.reducers;
        }

        public void reducers_$eq(Integer x$1) {
            this.reducers = x$1;
        }

        public String runMode() {
            return this.runMode;
        }

        public void runMode_$eq(String x$1) {
            this.runMode = x$1;
        }

        private Option<Enumeration.Value> mode$lzycompute() {
            ArrowExportParams arrowExportParams = this;
            synchronized (arrowExportParams) {
                if ((byte)(this.bitmap$0 & 2) == 0) {
                    this.mode = DistributedRunParam.mode$((DistributedRunParam)this);
                    this.bitmap$0 = (byte)(this.bitmap$0 | 2);
                }
            }
            return this.mode;
        }

        public Option<Enumeration.Value> mode() {
            return (byte)(this.bitmap$0 & 2) == 0 ? this.mode$lzycompute() : this.mode;
        }

        public Map<String, String> hints() {
            return this.hints;
        }

        public void hints_$eq(Map<String, String> x$1) {
            this.hints = x$1;
        }

        public Filter cqlFilter() {
            return this.cqlFilter;
        }

        public void cqlFilter_$eq(Filter x$1) {
            this.cqlFilter = x$1;
        }

        public ArrowExportParams() {
            OptionalCqlFilterParam.$init$((OptionalCqlFilterParam)this);
            QueryHintsParams.$init$((QueryHintsParams)this);
            DistributedRunParam.$init$((DistributedRunParam)this);
            NumReducersParam.$init$((NumReducersParam)this);
            OptionalForceParam.$init$((OptionalForceParam)this);
            ExportCommand.ExportParams.$init$((ExportCommand.ExportParams)this);
            ArrowDataStoreCommand.UrlParam.$init$(this);
            ProvidedTypeNameParam.$init$((ProvidedTypeNameParam)this);
        }
    }
}

