/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.bigtable.data;

import com.google.cloud.bigtable.hbase.BigtableExtendedScan;
import java.io.Serializable;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.MultiRowRangeFilter;
import org.locationtech.geomesa.bigtable.data.BigtableDataStore;
import org.locationtech.geomesa.hbase.data.HBaseDataStore;
import org.locationtech.geomesa.hbase.data.HBaseIndexAdapter;
import org.locationtech.geomesa.hbase.data.HBaseQueryPlan;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005%a\u0001\u0002\u0004\b\u0001IA\u0001B\u0007\u0001\u0003\u0002\u0003\u0006Ia\u0007\u0005\u0006?\u0001!\t\u0001\t\u0005\bG\u0001\u0011\r\u0011\"\u0011%\u0011\u0019q\u0003\u0001)A\u0005K!)q\u0006\u0001C)a\t!\")[4uC\ndW-\u00138eKb\fE-\u00199uKJT!\u0001C\u0005\u0002\t\u0011\fG/\u0019\u0006\u0003\u0015-\t\u0001BY5hi\u0006\u0014G.\u001a\u0006\u0003\u00195\tqaZ3p[\u0016\u001c\u0018M\u0003\u0002\u000f\u001f\u0005aAn\\2bi&|g\u000e^3dQ*\t\u0001#A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001'A\u0011A\u0003G\u0007\u0002+)\u0011\u0001B\u0006\u0006\u0003/-\tQ\u0001\u001b2bg\u0016L!!G\u000b\u0003#!\u0013\u0015m]3J]\u0012,\u00070\u00113baR,'/\u0001\u0002egB\u0011A$H\u0007\u0002\u000f%\u0011ad\u0002\u0002\u0012\u0005&<G/\u00192mK\u0012\u000bG/Y*u_J,\u0017A\u0002\u001fj]&$h\b\u0006\u0002\"EA\u0011A\u0004\u0001\u0005\u00065\t\u0001\raG\u0001\u000fi\u0006\u0014G.\u001a(b[\u0016d\u0015.\\5u+\u0005)\u0003c\u0001\u0014*W5\tqEC\u0001)\u0003\u0015\u00198-\u00197b\u0013\tQsE\u0001\u0004PaRLwN\u001c\t\u0003M1J!!L\u0014\u0003\u0007%sG/A\buC\ndWMT1nK2KW.\u001b;!\u00039\u0019wN\u001c4jOV\u0014XmU2b]N$\u0002\"\r([]N\\\u0018Q\u0001\t\u0004eijdBA\u001a9\u001d\t!t'D\u00016\u0015\t1\u0014#\u0001\u0004=e>|GOP\u0005\u0002Q%\u0011\u0011hJ\u0001\ba\u0006\u001c7.Y4f\u0013\tYDHA\u0002TKFT!!O\u0014\u0011\u0005yZeBA J\u001d\t\u0001\u0005J\u0004\u0002B\u000f:\u0011!I\u0012\b\u0003\u0007\u0016s!\u0001\u000e#\n\u0003AI!AD\b\n\u00051i\u0011BA\f\f\u0013\tAa#\u0003\u0002K+\u0005q\u0001JQ1tKF+XM]=QY\u0006t\u0017B\u0001'N\u0005%!\u0016M\u00197f'\u000e\fgN\u0003\u0002K+!)q*\u0002a\u0001!\u00061A/\u00192mKN\u00042A\r\u001eR!\t\u0011\u0006,D\u0001T\u0015\t9BK\u0003\u0002V-\u00061\u0001.\u00193p_BT!aV\b\u0002\r\u0005\u0004\u0018m\u00195f\u0013\tI6KA\u0005UC\ndWMT1nK\")1,\u0002a\u00019\u00061!/\u00198hKN\u00042A\r\u001e^!\tq6N\u0004\u0002`Q:\u0011\u0001M\u001a\b\u0003C\u0016t!A\u00193\u000f\u0005\r\u001b\u0017BA,\u0010\u0013\t)f+\u0003\u0002\u0018)&\u0011qmU\u0001\u0007M&dG/\u001a:\n\u0005%T\u0017aE'vYRL'k\\<SC:<WMR5mi\u0016\u0014(BA4T\u0013\taWN\u0001\u0005S_^\u0014\u0016M\\4f\u0015\tI'\u000eC\u0003p\u000b\u0001\u0007\u0001/A\u0003t[\u0006dG\u000e\u0005\u0002'c&\u0011!o\n\u0002\b\u0005>|G.Z1o\u0011\u0015!X\u00011\u0001v\u0003%\u0019w\u000e\u001c$b[&d\u0017\u0010E\u0002'mbL!a^\u0014\u0003\u000b\u0005\u0013(/Y=\u0011\u0005\u0019J\u0018B\u0001>(\u0005\u0011\u0011\u0015\u0010^3\t\u000bq,\u0001\u0019A?\u0002\u000f\u0019LG\u000e^3sgB\u0019!G\u000f@\u0011\u0007}\f\t!D\u0001k\u0013\r\t\u0019A\u001b\u0002\u0007\r&dG/\u001a:\t\r\u0005\u001dQ\u00011\u0001q\u0003-\u0019w\u000e\u001d:pG\u0016\u001c8o\u001c:")
public class BigtableIndexAdapter
extends HBaseIndexAdapter {
    private final Option<Object> tableNameLimit = new Some((Object)BoxesRunTime.boxToInteger((int)50));

    public Option<Object> tableNameLimit() {
        return this.tableNameLimit;
    }

    public Seq<HBaseQueryPlan.TableScan> configureScans(Seq<TableName> tables, Seq<MultiRowRangeFilter.RowRange> ranges, boolean small, byte[] colFamily, Seq<Filter> filters, boolean coprocessor) {
        if (filters.nonEmpty()) {
            throw new IllegalArgumentException(new StringBuilder(35).append("Bigtable does not support filters: ").append(filters.mkString(", ")).toString());
        }
        if (coprocessor) {
            throw new IllegalArgumentException("Bigtable does not support coprocessors");
        }
        Seq hbase = super.configureScans(tables, ranges, small, colFamily, filters, coprocessor);
        return small ? hbase : (Seq)hbase.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            HBaseQueryPlan.TableScan tableScan = x0$1;
            if (tableScan == null) {
                throw new MatchError((Object)tableScan);
            }
            TableName table = tableScan.table();
            Seq originals = tableScan.scans();
            Seq scans = (Seq)originals.map((Function1 & Serializable & scala.Serializable)original -> {
                void var2_1;
                None$ none$;
                BigtableExtendedScan scan = new BigtableExtendedScan();
                scan.setStartRow(original.getStartRow());
                scan.setStopRow(original.getStopRow());
                Filter filter2 = original.getFilter();
                if (filter2 instanceof MultiRowRangeFilter) {
                    MultiRowRangeFilter multiRowRangeFilter = (MultiRowRangeFilter)filter2;
                    none$ = new Some((Object)multiRowRangeFilter);
                } else if (filter2 instanceof FilterList) {
                    FilterList filterList = (FilterList)filter2;
                    none$ = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(filterList.getFilters()).asScala()).collectFirst((PartialFunction)new scala.Serializable(null){
                        public static final long serialVersionUID = 0L;

                        public final <A1 extends Filter, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                            MultiRowRangeFilter multiRowRangeFilter;
                            A1 A1 = x1;
                            Object object = A1 instanceof MultiRowRangeFilter ? (multiRowRangeFilter = (MultiRowRangeFilter)A1) : function1.apply(x1);
                            return (B1)object;
                        }

                        public final boolean isDefinedAt(Filter x1) {
                            Filter filter = x1;
                            boolean bl = filter instanceof MultiRowRangeFilter;
                            return bl;
                        }
                    });
                } else {
                    none$ = None$.MODULE$;
                }
                None$ mrrf = none$;
                mrrf.foreach((Function1 & Serializable & scala.Serializable)filter -> {
                    BigtableIndexAdapter.$anonfun$configureScans$3(scan, filter);
                    return BoxedUnit.UNIT;
                });
                return var2_1;
            }, Seq$.MODULE$.canBuildFrom());
            HBaseQueryPlan.TableScan tableScan2 = new HBaseQueryPlan.TableScan(table, scans);
            return tableScan2;
        }, Seq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ void $anonfun$configureScans$3(BigtableExtendedScan scan$1, MultiRowRangeFilter filter) {
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(filter.getRowRanges()).asScala()).foreach((Function1 & Serializable & scala.Serializable)r -> {
            scan$1.addRange(r.getStartRow(), r.getStopRow());
            return BoxedUnit.UNIT;
        });
    }

    public BigtableIndexAdapter(BigtableDataStore ds) {
        super((HBaseDataStore)ds);
    }
}

