/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.filter.expression;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.operation.distance.DistanceOp;
import org.geotools.referencing.GeodeticCalculator;
import org.locationtech.geomesa.filter.FilterHelper$;
import org.locationtech.geomesa.filter.expression.FastDWithin$;
import org.locationtech.geomesa.utils.geotools.GeometryUtils$;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.MultiValuedFilter;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.spatial.DWithin;
import scala.Array$;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005}t!B\u0001\u0003\u0011\u0003i\u0011a\u0003$bgR$u+\u001b;iS:T!a\u0001\u0003\u0002\u0015\u0015D\bO]3tg&|gN\u0003\u0002\u0006\r\u00051a-\u001b7uKJT!a\u0002\u0005\u0002\u000f\u001d,w.\\3tC*\u0011\u0011BC\u0001\rY>\u001c\u0017\r^5p]R,7\r\u001b\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001A\u0011abD\u0007\u0002\u0005\u0019)\u0001C\u0001E\u0001#\tYa)Y:u\t^KG\u000f[5o'\ty!\u0003\u0005\u0002\u0014-5\tACC\u0001\u0016\u0003\u0015\u00198-\u00197b\u0013\t9BC\u0001\u0004B]f\u0014VM\u001a\u0005\u00063=!\tAG\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00035Aq\u0001H\bC\u0002\u0013%Q$A\u0006dC2\u001cW\u000f\\1u_J\u001cX#\u0001\u0010\u0011\u0007}!c%D\u0001!\u0015\t\t#%\u0001\u0003mC:<'\"A\u0012\u0002\t)\fg/Y\u0005\u0003K\u0001\u00121\u0002\u00165sK\u0006$Gj\\2bYB\u0011q\u0005L\u0007\u0002Q)\u0011\u0011FK\u0001\fe\u00164WM]3oG&twM\u0003\u0002,\u0015\u0005Aq-Z8u_>d7/\u0003\u0002.Q\t\u0011r)Z8eKRL7mQ1mGVd\u0017\r^8s\u0011\u0019ys\u0002)A\u0005=\u0005a1-\u00197dk2\fGo\u001c:tA\u0019!\u0011g\u0004\u00013\u00059!u+\u001b;iS:d\u0015\u000e^3sC2\u001c2\u0001M\u001a7!\tyB'\u0003\u00026A\t1qJ\u00196fGR\u0004\"aN\u001f\u000e\u0003aR!!\u000f\u001e\u0002\u000fM\u0004\u0018\r^5bY*\u0011Qa\u000f\u0006\u0003y)\tqa\u001c9f]\u001eL7/\u0003\u0002?q\t9AiV5uQ&t\u0007\u0002\u0003!1\u0005\u0003\u0005\u000b\u0011B!\u0002\t\u0015D\b/\r\t\u0003\u0005\u0012k\u0011a\u0011\u0006\u0003\u0007iJ!!R\"\u0003\u0015\u0015C\bO]3tg&|g\u000e\u0003\u0005Ha\t\u0005\t\u0015!\u0003I\u0003\u0011)\u0007\u0010\u001d\u001a\u0011\u0005\tK\u0015B\u0001&D\u0005\u001da\u0015\u000e^3sC2D\u0001\u0002\u0014\u0019\u0003\u0002\u0003\u0006I!T\u0001\tI&\u001cH/\u00198dKB\u00111CT\u0005\u0003\u001fR\u0011a\u0001R8vE2,\u0007\u0002C)1\u0005\u0003\u0005\u000b\u0011\u0002*\u0002\u000bUt\u0017\u000e^:\u0011\u0005M3fBA\nU\u0013\t)F#\u0001\u0004Qe\u0016$WMZ\u0005\u0003/b\u0013aa\u0015;sS:<'BA+\u0015\u0011\u0015I\u0002\u0007\"\u0001[)\u0015YVLX0a!\ta\u0006'D\u0001\u0010\u0011\u0015\u0001\u0015\f1\u0001B\u0011\u00159\u0015\f1\u0001I\u0011\u0015a\u0015\f1\u0001N\u0011\u0015\t\u0016\f1\u0001S\u0011\u001d\u0011\u0007G1A\u0005\n\r\f\u0001bZ3p[\u0016$(/_\u000b\u0002IB\u0011QM\\\u0007\u0002M*\u0011q\r[\u0001\u0005O\u0016|WN\u0003\u0002jU\u0006\u0019!\u000e^:\u000b\u0005-d\u0017A\u0004<jm&$7o\u001c7vi&|gn\u001d\u0006\u0002[\u0006\u00191m\\7\n\u0005=4'\u0001C$f_6,GO]=\t\rE\u0004\u0004\u0015!\u0003e\u0003%9Wm\\7fiJL\b\u0005C\u0004ta\t\u0007I\u0011\u0002;\u0002\u0011\u0015tg/\u001a7pa\u0016,\u0012!\u001e\t\u0003KZL!a\u001e4\u0003\u0011\u0015sg/\u001a7pa\u0016Da!\u001f\u0019!\u0002\u0013)\u0018!C3om\u0016dw\u000e]3!\u0011\u001dY\bG1A\u0005\nq\fa!\\3uKJ\u001cX#A'\t\ry\u0004\u0004\u0015!\u0003N\u0003\u001diW\r^3sg\u0002BA\"!\u00011!\u0003\u0005\u0019\u0011)A\u0005\u0003\u0007\t1\u0001\u001f\u00132!\u0015\u0019\u0012QA'N\u0013\r\t9\u0001\u0006\u0002\u0007)V\u0004H.\u001a\u001a\t\u0011\u0005-\u0001G1A\u0005\nq\f!\"\\5o\t\u0016<'/Z3t\u0011\u001d\ty\u0001\rQ\u0001\n5\u000b1\"\\5o\t\u0016<'/Z3tA!A\u00111\u0003\u0019C\u0002\u0013%A0\u0001\u0006nCb$Um\u001a:fKNDq!a\u00061A\u0003%Q*A\u0006nCb$Um\u001a:fKN\u0004\u0003bBA\u000ea\u0011\u0005\u0013QD\u0001\tKZ\fG.^1uKR!\u0011qDA\u0013!\r\u0019\u0012\u0011E\u0005\u0004\u0003G!\"a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003O\tI\u00021\u0001\u0013\u0003\ry'M\u001b\u0005\b\u0003W\u0001D\u0011IA\u0017\u000399W\r^#yaJ,7o]5p]F\"\u0012!\u0011\u0005\b\u0003c\u0001D\u0011IA\u0017\u000399W\r^#yaJ,7o]5p]JBq!!\u000e1\t\u0003\n9$A\u0006hKR$\u0015n\u001d;b]\u000e,G#A'\t\u000f\u0005m\u0002\u0007\"\u0011\u0002>\u0005\u0001r-\u001a;ESN$\u0018M\\2f+:LGo\u001d\u000b\u0002%\"9\u0011\u0011\t\u0019\u0005B\u0005\r\u0013AD4fi6\u000bGo\u00195BGRLwN\u001c\u000b\u0003\u0003\u000b\u0002B!a\u0012\u0002`9!\u0011\u0011JA.\u001d\u0011\tY%!\u0017\u000f\t\u00055\u0013q\u000b\b\u0005\u0003\u001f\n)&\u0004\u0002\u0002R)\u0019\u00111\u000b\u0007\u0002\rq\u0012xn\u001c;?\u0013\u0005Y\u0011B\u0001\u001f\u000b\u0013\t)1(C\u0002\u0002^i\n\u0011#T;mi&4\u0016\r\\;fI\u001aKG\u000e^3s\u0013\u0011\t\t'a\u0019\u0003\u00175\u000bGo\u00195BGRLwN\u001c\u0006\u0004\u0003;R\u0004bBA4a\u0011\u0005\u0013\u0011N\u0001\u0007C\u000e\u001cW\r\u001d;\u0015\u000bI\tY'a\u001e\t\u0011\u00055\u0014Q\ra\u0001\u0003_\nqA^5tSR|'\u000f\u0005\u0003\u0002r\u0005MT\"\u0001\u001e\n\u0007\u0005U$HA\u0007GS2$XM\u001d,jg&$xN\u001d\u0005\b\u0003s\n)\u00071\u0001\u0013\u0003%)\u0007\u0010\u001e:b\t\u0006$\u0018\rC\u0004\u0002~A\"\t%!\u0010\u0002\u0011Q|7\u000b\u001e:j]\u001e\u0004")
public final class FastDWithin {

    public static class DWithinLiteral
    implements DWithin {
        private final Expression exp1;
        private final Literal exp2;
        private final double distance;
        private final String units;
        private final Geometry geometry;
        private final Envelope envelope;
        private final double meters;
        private final /* synthetic */ Tuple2 x$1;
        private final double minDegrees;
        private final double maxDegrees;

        private Geometry geometry() {
            return this.geometry;
        }

        private Envelope envelope() {
            return this.envelope;
        }

        private double meters() {
            return this.meters;
        }

        private double minDegrees() {
            return this.minDegrees;
        }

        private double maxDegrees() {
            return this.maxDegrees;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean evaluate(Object obj) {
            Tuple2 tuple2;
            Geometry geom = (Geometry)this.exp1.evaluate(obj);
            if (geom == null) return false;
            if (this.envelope().distance(geom.getEnvelopeInternal()) > this.maxDegrees()) {
                return false;
            }
            DistanceOp op = new DistanceOp(this.geometry(), geom);
            if (op.distance() <= this.minDegrees()) return true;
            Coordinate[] coordinateArray = op.nearestPoints();
            Option option = Array$.MODULE$.unapplySeq((Object)coordinateArray);
            if (option.isEmpty()) throw new MatchError((Object)coordinateArray);
            if (option.get() == null) throw new MatchError((Object)coordinateArray);
            if (((SeqLike)option.get()).lengthCompare(2) != 0) throw new MatchError((Object)coordinateArray);
            Coordinate p1 = (Coordinate)((SeqLike)option.get()).apply(0);
            Coordinate p2 = (Coordinate)((SeqLike)option.get()).apply(1);
            Tuple2 tuple22 = tuple2 = new Tuple2((Object)p1, (Object)p2);
            Coordinate p12 = (Coordinate)tuple22._1();
            Coordinate p22 = (Coordinate)tuple22._2();
            GeodeticCalculator calculator = FastDWithin$.MODULE$.org$locationtech$geomesa$filter$expression$FastDWithin$$calculators().get();
            calculator.setStartingGeographicPoint(p12.x, p12.y);
            calculator.setDestinationGeographicPoint(p22.x, p22.y);
            if (!(calculator.getOrthodromicDistance() <= this.meters())) return false;
            return true;
        }

        public Expression getExpression1() {
            return this.exp1;
        }

        public Expression getExpression2() {
            return this.exp2;
        }

        public double getDistance() {
            return this.distance;
        }

        public String getDistanceUnits() {
            return this.units;
        }

        public MultiValuedFilter.MatchAction getMatchAction() {
            return MultiValuedFilter.MatchAction.ANY;
        }

        public Object accept(FilterVisitor visitor, Object extraData) {
            return visitor.visit((DWithin)this, extraData);
        }

        public String toString() {
            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[ ", " dwithin ", " , distance: ", " ", " ]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.exp1, this.exp2, BoxesRunTime.boxToDouble((double)this.distance), this.units}));
        }

        public DWithinLiteral(Expression exp1, Literal exp2, double distance, String units) {
            this.exp1 = exp1;
            this.exp2 = exp2;
            this.distance = distance;
            this.units = units;
            this.geometry = (Geometry)exp2.evaluate(null);
            this.envelope = this.geometry().getEnvelopeInternal();
            this.meters = distance * FilterHelper$.MODULE$.metersMultiplier(units);
            Tuple2 tuple2 = GeometryUtils$.MODULE$.distanceDegrees(this.geometry(), this.meters());
            if (tuple2 != null) {
                double minDegrees = tuple2._1$mcD$sp();
                double maxDegrees = tuple2._2$mcD$sp();
                Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(minDegrees, maxDegrees);
                this.x$1 = sp2;
                this.minDegrees = this.x$1._1$mcD$sp();
                this.maxDegrees = this.x$1._2$mcD$sp();
                return;
            }
            throw new MatchError((Object)tuple2);
        }
    }
}

