/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.bigtable.index;

import com.google.cloud.bigtable.hbase.BigtableExtendedScan;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.MultiRowRangeFilter;
import org.locationtech.geomesa.bigtable.index.BigtablePlatform;
import org.locationtech.geomesa.hbase.data.HBaseDataStore;
import org.locationtech.geomesa.hbase.data.HBaseQueryPlan;
import org.locationtech.geomesa.hbase.data.ScanPlan;
import org.locationtech.geomesa.hbase.index.HBaseColumnGroups$;
import org.locationtech.geomesa.hbase.index.HBasePlatform$;
import org.locationtech.geomesa.index.api.FilterStrategy;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.math.package$;

public abstract class BigtablePlatform$class {
    public static HBaseQueryPlan buildPlatformScanPlan(BigtablePlatform $this, HBaseDataStore ds, SimpleFeatureType sft, FilterStrategy filter, Seq ranges, byte[] colFamily, Seq tables, Seq hbaseFilters, Option coprocessor, Function1 toFeatures) {
        Seq seq;
        if (hbaseFilters.nonEmpty()) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Bigtable doesn't support filters: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{hbaseFilters.mkString(", ")})));
        }
        if (ranges.headOption().exists((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Scan x$1) {
                return x$1.isSmall();
            }
        })) {
            ranges.foreach((Function1)new Serializable($this, colFamily){
                public static final long serialVersionUID = 0L;
                private final byte[] colFamily$2;

                public final Scan apply(Scan x$2) {
                    return x$2.addColumn(this.colFamily$2, HBaseColumnGroups$.MODULE$.default());
                }
                {
                    this.colFamily$2 = colFamily$2;
                }
            });
            seq = ranges;
        } else {
            seq = BigtablePlatform$class.configureBigtableExtendedScan($this, ds, ranges, colFamily);
        }
        Seq scans = seq;
        return new ScanPlan(filter, tables, ranges, scans, toFeatures);
    }

    private static Seq configureBigtableExtendedScan(BigtablePlatform $this, HBaseDataStore ds, Seq originalRanges, byte[] colFamily) {
        List sortedRowRanges = HBasePlatform$.MODULE$.sortAndMerge(originalRanges);
        int numRanges = sortedRowRanges.size();
        int numThreads = ds.config().queryThreads();
        int rangesPerThread = package$.MODULE$.min(ds.config().maxRangesPerExtendedScan(), package$.MODULE$.max(1, (int)package$.MODULE$.ceil((double)(numRanges / numThreads * 2))));
        List groupedRanges = Lists.partition((List)sortedRowRanges, (int)rangesPerThread);
        Buffer groupedScans = (Buffer)JavaConversions$.MODULE$.asScalaBuffer(groupedRanges).map((Function1)new Serializable($this, colFamily){
            public static final long serialVersionUID = 0L;
            private final byte[] colFamily$1;

            /*
             * WARNING - void declaration
             */
            public final BigtableExtendedScan apply(List<MultiRowRangeFilter.RowRange> localRanges) {
                void var2_2;
                BigtableExtendedScan scan = new BigtableExtendedScan();
                JavaConversions$.MODULE$.asScalaBuffer(localRanges).foreach((Function1)new Serializable(this, scan){
                    public static final long serialVersionUID = 0L;
                    private final BigtableExtendedScan scan$1;

                    public final void apply(MultiRowRangeFilter.RowRange r) {
                        this.scan$1.addRange(r.getStartRow(), r.getStopRow());
                    }
                    {
                        this.scan$1 = scan$1;
                    }
                });
                scan.addColumn(this.colFamily$1, HBaseColumnGroups$.MODULE$.default());
                return var2_2;
            }
            {
                this.colFamily$1 = colFamily$1;
            }
        }, Buffer$.MODULE$.canBuildFrom());
        return groupedScans;
    }

    public static void $init$(BigtablePlatform $this) {
    }
}

