/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.index.geotools;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import org.geotools.factory.Hints;
import org.geotools.filter.identity.FeatureIdImpl;
import org.locationtech.geomesa.features.ScalaSimpleFeature$;
import org.locationtech.geomesa.index.api.GeoMesaFeatureIndex;
import org.locationtech.geomesa.index.api.WrappedFeature;
import org.locationtech.geomesa.index.conf.FeatureProperties$;
import org.locationtech.geomesa.index.geotools.GeoMesaDataStore;
import org.locationtech.geomesa.index.geotools.GeoMesaFeatureWriter$;
import org.locationtech.geomesa.utils.cache.CacheKeyGenerator$;
import org.locationtech.geomesa.utils.uuid.FeatureIdGenerator;
import org.locationtech.geomesa.utils.uuid.Z3FeatureIdGenerator;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.identity.FeatureId;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class GeoMesaFeatureWriter$
implements LazyLogging {
    public static final GeoMesaFeatureWriter$ MODULE$;
    private final AtomicLong org$locationtech$geomesa$index$geotools$GeoMesaFeatureWriter$$tempFeatureIds;
    private final Cache<String, Tuple2<Seq<Function1<Object, Seq<Object>>>, Seq<Function1<Object, Seq<Object>>>>> converterCache;
    private final FeatureIdGenerator idGenerator;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new GeoMesaFeatureWriter$();
    }

    private Logger logger$lzycompute() {
        GeoMesaFeatureWriter$ geoMesaFeatureWriter$ = this;
        synchronized (geoMesaFeatureWriter$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public AtomicLong org$locationtech$geomesa$index$geotools$GeoMesaFeatureWriter$$tempFeatureIds() {
        return this.org$locationtech$geomesa$index$geotools$GeoMesaFeatureWriter$$tempFeatureIds;
    }

    private Cache<String, Tuple2<Seq<Function1<Object, Seq<Object>>>, Seq<Function1<Object, Seq<Object>>>>> converterCache() {
        return this.converterCache;
    }

    private FeatureIdGenerator idGenerator() {
        return this.idGenerator;
    }

    public SimpleFeature featureWithFid(SimpleFeatureType sft, SimpleFeature feature) {
        return feature.getUserData().containsKey(Hints.PROVIDED_FID) ? this.withFid(sft, feature, feature.getUserData().get(Hints.PROVIDED_FID).toString()) : (feature.getUserData().containsKey(Hints.USE_PROVIDED_FID) && BoxesRunTime.unboxToBoolean(feature.getUserData().get(Hints.USE_PROVIDED_FID)) ? feature : this.withFid(sft, feature, this.idGenerator().createId(sft, feature)));
    }

    private SimpleFeature withFid(SimpleFeatureType sft, SimpleFeature feature, String fid) {
        SimpleFeature simpleFeature;
        FeatureId featureId = feature.getIdentifier();
        if (featureId instanceof FeatureIdImpl) {
            FeatureIdImpl featureIdImpl = (FeatureIdImpl)featureId;
            featureIdImpl.setID(fid);
            simpleFeature = feature;
        } else {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("Unknown FeatureID implementation found, rebuilding feature: {} '{}'", new Object[]{featureId, featureId.getClass().getName()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            simpleFeature = ScalaSimpleFeature$.MODULE$.copy(sft, feature);
        }
        return simpleFeature;
    }

    public <DS extends GeoMesaDataStore<DS, F, W>, F extends WrappedFeature, W> Tuple2<Seq<Function1<F, Seq<W>>>, Seq<Function1<F, Seq<W>>>> org$locationtech$geomesa$index$geotools$GeoMesaFeatureWriter$$getIndexConverters(SimpleFeatureType sft, DS ds, Seq<GeoMesaFeatureIndex<DS, F, W>> indices2) {
        String key = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ";", ";", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ds.config().catalog(), CacheKeyGenerator$.MODULE$.cacheKey(sft), ((TraversableOnce)indices2.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(GeoMesaFeatureIndex<DS, F, W> x$1) {
                return x$1.identifier();
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString(",")}));
        Function<String, Tuple2<Seq<Function1<Object, Seq<Object>>>, Seq<Function1<Object, Seq<Object>>>>> load2 = new Function<String, Tuple2<Seq<Function1<Object, Seq<Object>>>, Seq<Function1<Object, Seq<Object>>>>>(sft, ds, indices2){
            public final SimpleFeatureType sft$1;
            public final GeoMesaDataStore ds$1;
            private final Seq indices$1;

            public Tuple2<Seq<Function1<Object, Seq<Object>>>, Seq<Function1<Object, Seq<Object>>>> apply(String ignored) {
                Seq writers = (Seq)this.indices$1.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.1 $outer;

                    public final Function1<F, Seq<W>> apply(GeoMesaFeatureIndex<DS, F, W> x$2) {
                        return x$2.writer(this.$outer.sft$1, this.$outer.ds$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, Seq$.MODULE$.canBuildFrom());
                Seq removers = (Seq)this.indices$1.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.1 $outer;

                    public final Function1<F, Seq<W>> apply(GeoMesaFeatureIndex<DS, F, W> x$3) {
                        return x$3.remover(this.$outer.sft$1, this.$outer.ds$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, Seq$.MODULE$.canBuildFrom());
                return new Tuple2((Object)writers, (Object)removers);
            }
            {
                this.sft$1 = sft$1;
                this.ds$1 = ds$1;
                this.indices$1 = indices$1;
            }
        };
        return (Tuple2)this.converterCache().get((Object)key, (Function)load2);
    }

    public void expireConverterCache() {
        this.converterCache().invalidateAll();
    }

    private final FeatureIdGenerator liftedTree1$1() {
        Z3FeatureIdGenerator z3FeatureIdGenerator;
        try {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Using feature id generator '{}'", new Object[]{FeatureProperties$.MODULE$.FEATURE_ID_GENERATOR().get()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            z3FeatureIdGenerator = (FeatureIdGenerator)Class.forName(FeatureProperties$.MODULE$.FEATURE_ID_GENERATOR().get()).newInstance();
        }
        catch (Throwable throwable) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not load feature id generator class '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{FeatureProperties$.MODULE$.FEATURE_ID_GENERATOR().get()})), throwable);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            z3FeatureIdGenerator = new Z3FeatureIdGenerator();
        }
        return z3FeatureIdGenerator;
    }

    private GeoMesaFeatureWriter$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
        this.org$locationtech$geomesa$index$geotools$GeoMesaFeatureWriter$$tempFeatureIds = new AtomicLong(0L);
        this.converterCache = Caffeine.newBuilder().expireAfterWrite(60L, TimeUnit.MINUTES).build();
        this.idGenerator = this.liftedTree1$1();
    }
}

