/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.collect;

import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.Queue;

public class Iterators2 {
    private Iterators2() {
    }

    public static <T> Iterator<T> distinct(final Iterator<T> iterator) {
        Preconditions.checkNotNull(iterator);
        return new AbstractIterator<T>(){
            T current = null;

            protected T computeNext() {
                if (iterator.hasNext()) {
                    if (this.current == null) {
                        this.current = iterator.next();
                        return this.current;
                    }
                    Object next = iterator.next();
                    while (this.current.equals(next)) {
                        if (iterator.hasNext()) {
                            next = iterator.next();
                            continue;
                        }
                        return this.endOfData();
                    }
                    this.current = next;
                    return this.current;
                }
                return this.endOfData();
            }
        };
    }

    @Deprecated
    public static <T> Iterator<T> drainingIterator(Queue<T> queue) {
        Preconditions.checkNotNull(queue);
        return Iterators.consumingIterator(queue.iterator());
    }
}

