/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class BlockLocation {
    private String[] hosts;
    private String[] cachedHosts;
    private String[] names;
    private String[] topologyPaths;
    private long offset;
    private long length;
    private boolean corrupt;
    private static final String[] EMPTY_STR_ARRAY = new String[0];

    public BlockLocation() {
        this(EMPTY_STR_ARRAY, EMPTY_STR_ARRAY, 0L, 0L);
    }

    public BlockLocation(BlockLocation that) {
        this.hosts = that.hosts;
        this.cachedHosts = that.cachedHosts;
        this.names = that.names;
        this.topologyPaths = that.topologyPaths;
        this.offset = that.offset;
        this.length = that.length;
        this.corrupt = that.corrupt;
    }

    public BlockLocation(String[] names, String[] hosts, long offset, long length) {
        this(names, hosts, offset, length, false);
    }

    public BlockLocation(String[] names, String[] hosts, long offset, long length, boolean corrupt) {
        this(names, hosts, null, offset, length, corrupt);
    }

    public BlockLocation(String[] names, String[] hosts, String[] topologyPaths, long offset, long length) {
        this(names, hosts, topologyPaths, offset, length, false);
    }

    public BlockLocation(String[] names, String[] hosts, String[] topologyPaths, long offset, long length, boolean corrupt) {
        this(names, hosts, null, topologyPaths, offset, length, corrupt);
    }

    public BlockLocation(String[] names, String[] hosts, String[] cachedHosts, String[] topologyPaths, long offset, long length, boolean corrupt) {
        this.names = names == null ? EMPTY_STR_ARRAY : names;
        this.hosts = hosts == null ? EMPTY_STR_ARRAY : hosts;
        this.cachedHosts = cachedHosts == null ? EMPTY_STR_ARRAY : cachedHosts;
        this.topologyPaths = topologyPaths == null ? EMPTY_STR_ARRAY : topologyPaths;
        this.offset = offset;
        this.length = length;
        this.corrupt = corrupt;
    }

    public String[] getHosts() throws IOException {
        return this.hosts;
    }

    public String[] getCachedHosts() {
        return this.cachedHosts;
    }

    public String[] getNames() throws IOException {
        return this.names;
    }

    public String[] getTopologyPaths() throws IOException {
        return this.topologyPaths;
    }

    public long getOffset() {
        return this.offset;
    }

    public long getLength() {
        return this.length;
    }

    public boolean isCorrupt() {
        return this.corrupt;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public void setLength(long length) {
        this.length = length;
    }

    public void setCorrupt(boolean corrupt) {
        this.corrupt = corrupt;
    }

    public void setHosts(String[] hosts) throws IOException {
        this.hosts = hosts == null ? EMPTY_STR_ARRAY : hosts;
    }

    public void setCachedHosts(String[] cachedHosts) {
        this.cachedHosts = cachedHosts == null ? EMPTY_STR_ARRAY : cachedHosts;
    }

    public void setNames(String[] names) throws IOException {
        this.names = names == null ? EMPTY_STR_ARRAY : names;
    }

    public void setTopologyPaths(String[] topologyPaths) throws IOException {
        this.topologyPaths = topologyPaths == null ? EMPTY_STR_ARRAY : topologyPaths;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.offset);
        result.append(',');
        result.append(this.length);
        if (this.corrupt) {
            result.append("(corrupt)");
        }
        for (String h : this.hosts) {
            result.append(',');
            result.append(h);
        }
        return result.toString();
    }
}

