/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
@InterfaceStability.Unstable
public class NetgroupCache {
    private static boolean netgroupToUsersMapUpdated = true;
    private static Map<String, Set<String>> netgroupToUsersMap = new ConcurrentHashMap<String, Set<String>>();
    private static Map<String, Set<String>> userToNetgroupsMap = new ConcurrentHashMap<String, Set<String>>();

    public static void getNetgroups(String user, List<String> groups) {
        if (netgroupToUsersMapUpdated) {
            netgroupToUsersMapUpdated = false;
            for (String netgroup : netgroupToUsersMap.keySet()) {
                for (String netuser : netgroupToUsersMap.get(netgroup)) {
                    if (!userToNetgroupsMap.containsKey(netuser)) {
                        userToNetgroupsMap.put(netuser, new HashSet());
                    }
                    userToNetgroupsMap.get(netuser).add(netgroup);
                }
            }
        }
        if (userToNetgroupsMap.containsKey(user)) {
            groups.addAll((Collection<String>)userToNetgroupsMap.get(user));
        }
    }

    public static List<String> getNetgroupNames() {
        return new LinkedList<String>(netgroupToUsersMap.keySet());
    }

    public static boolean isCached(String group) {
        return netgroupToUsersMap.containsKey(group);
    }

    public static void clear() {
        netgroupToUsersMap.clear();
        userToNetgroupsMap.clear();
    }

    public static void add(String group, List<String> users) {
        netgroupToUsersMap.put(group, new HashSet<String>(users));
        netgroupToUsersMapUpdated = true;
    }
}

