/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.api.client.auth.oauth2;

import com.google.bigtable.repackaged.com.google.api.client.auth.oauth2.TokenRequest;
import com.google.bigtable.repackaged.com.google.api.client.http.GenericUrl;
import com.google.bigtable.repackaged.com.google.api.client.http.HttpExecuteInterceptor;
import com.google.bigtable.repackaged.com.google.api.client.http.HttpRequestInitializer;
import com.google.bigtable.repackaged.com.google.api.client.http.HttpTransport;
import com.google.bigtable.repackaged.com.google.api.client.json.JsonFactory;
import com.google.bigtable.repackaged.com.google.api.client.util.Key;
import com.google.bigtable.repackaged.com.google.api.client.util.Preconditions;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthorizationCodeTokenRequest
extends TokenRequest {
    @Key
    private String code;
    @Key(value="redirect_uri")
    private String redirectUri;

    public AuthorizationCodeTokenRequest(HttpTransport transport, JsonFactory jsonFactory, GenericUrl tokenServerUrl, String code) {
        super(transport, jsonFactory, tokenServerUrl, "authorization_code");
        this.setCode(code);
    }

    @Override
    public AuthorizationCodeTokenRequest setRequestInitializer(HttpRequestInitializer requestInitializer) {
        return (AuthorizationCodeTokenRequest)super.setRequestInitializer(requestInitializer);
    }

    @Override
    public AuthorizationCodeTokenRequest setTokenServerUrl(GenericUrl tokenServerUrl) {
        return (AuthorizationCodeTokenRequest)super.setTokenServerUrl(tokenServerUrl);
    }

    @Override
    public AuthorizationCodeTokenRequest setScopes(Collection<String> scopes) {
        return (AuthorizationCodeTokenRequest)super.setScopes(scopes);
    }

    @Override
    public AuthorizationCodeTokenRequest setGrantType(String grantType) {
        return (AuthorizationCodeTokenRequest)super.setGrantType(grantType);
    }

    @Override
    public AuthorizationCodeTokenRequest setClientAuthentication(HttpExecuteInterceptor clientAuthentication) {
        return (AuthorizationCodeTokenRequest)super.setClientAuthentication(clientAuthentication);
    }

    public final String getCode() {
        return this.code;
    }

    public AuthorizationCodeTokenRequest setCode(String code) {
        this.code = Preconditions.checkNotNull(code);
        return this;
    }

    public final String getRedirectUri() {
        return this.redirectUri;
    }

    public AuthorizationCodeTokenRequest setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
        return this;
    }

    @Override
    public AuthorizationCodeTokenRequest set(String fieldName, Object value) {
        return (AuthorizationCodeTokenRequest)super.set(fieldName, value);
    }
}

