/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.auth.oauth2;

import com.google.bigtable.repackaged.com.google.api.client.http.GenericUrl;
import com.google.bigtable.repackaged.com.google.api.client.http.HttpHeaders;
import com.google.bigtable.repackaged.com.google.api.client.http.HttpRequest;
import com.google.bigtable.repackaged.com.google.api.client.http.HttpResponse;
import com.google.bigtable.repackaged.com.google.api.client.json.JsonObjectParser;
import com.google.bigtable.repackaged.com.google.api.client.util.GenericData;
import com.google.bigtable.repackaged.com.google.auth.http.HttpTransportFactory;
import com.google.bigtable.repackaged.com.google.auth.oauth2.AccessToken;
import com.google.bigtable.repackaged.com.google.auth.oauth2.GoogleCredentials;
import com.google.bigtable.repackaged.com.google.auth.oauth2.OAuth2Utils;
import com.google.bigtable.repackaged.com.google.common.base.MoreObjects;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Objects;

public class ComputeEngineCredentials
extends GoogleCredentials {
    static final String TOKEN_SERVER_ENCODED_URL = "http://metadata/computeMetadata/v1/instance/service-accounts/default/token";
    static final String METADATA_SERVER_URL = "http://metadata.google.internal";
    private static final String PARSE_ERROR_PREFIX = "Error parsing token refresh response. ";
    private static final long serialVersionUID = -4113476462526554235L;
    private final String transportFactoryClassName;
    private transient HttpTransportFactory transportFactory;

    public ComputeEngineCredentials() {
        this((HttpTransportFactory)null);
    }

    public ComputeEngineCredentials(HttpTransportFactory transportFactory) {
        this.transportFactory = MoreObjects.firstNonNull(transportFactory, ComputeEngineCredentials.getFromServiceLoader(HttpTransportFactory.class, OAuth2Utils.HTTP_TRANSPORT_FACTORY));
        this.transportFactoryClassName = this.transportFactory.getClass().getName();
    }

    @Override
    public AccessToken refreshAccessToken() throws IOException {
        HttpResponse response;
        GenericUrl tokenUrl = new GenericUrl(TOKEN_SERVER_ENCODED_URL);
        HttpRequest request = this.transportFactory.create().createRequestFactory().buildGetRequest(tokenUrl);
        JsonObjectParser parser = new JsonObjectParser(OAuth2Utils.JSON_FACTORY);
        request.setParser(parser);
        request.getHeaders().set("Metadata-Flavor", "Google");
        request.setThrowExceptionOnExecuteError(false);
        try {
            response = request.execute();
        }
        catch (UnknownHostException exception) {
            throw new IOException("ComputeEngineCredentials cannot find the metadata server. This is likely because code is not running on Google Compute Engine.", exception);
        }
        int statusCode = response.getStatusCode();
        if (statusCode == 404) {
            throw new IOException(String.format("Error code %s trying to get security access token from Compute Engine metadata for the default service account. This may be because the virtual machine instance does not have permission scopes specified.", statusCode));
        }
        if (statusCode != 200) {
            throw new IOException(String.format("Unexpected Error code %s trying to get security access token from Compute Engine metadata for the default service account: %s", statusCode, response.parseAsString()));
        }
        InputStream content = response.getContent();
        if (content == null) {
            throw new IOException("Empty content from metadata token server request.");
        }
        GenericData responseData = response.parseAs(GenericData.class);
        String accessToken = OAuth2Utils.validateString(responseData, "access_token", PARSE_ERROR_PREFIX);
        int expiresInSeconds = OAuth2Utils.validateInt32(responseData, "expires_in", PARSE_ERROR_PREFIX);
        long expiresAtMilliseconds = this.clock.currentTimeMillis() + (long)(expiresInSeconds * 1000);
        return new AccessToken(accessToken, new Date(expiresAtMilliseconds));
    }

    static boolean runningOnComputeEngine(HttpTransportFactory transportFactory) {
        try {
            GenericUrl tokenUrl = new GenericUrl(METADATA_SERVER_URL);
            HttpRequest request = transportFactory.create().createRequestFactory().buildGetRequest(tokenUrl);
            HttpResponse response = request.execute();
            HttpHeaders headers = response.getHeaders();
            if (OAuth2Utils.headersContainValue(headers, "Metadata-Flavor", "Google")) {
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.transportFactoryClassName);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).add("transportFactoryClassName", this.transportFactoryClassName).toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ComputeEngineCredentials)) {
            return false;
        }
        ComputeEngineCredentials other = (ComputeEngineCredentials)obj;
        return Objects.equals(this.transportFactoryClassName, other.transportFactoryClassName);
    }

    private void readObject(ObjectInputStream input) throws IOException, ClassNotFoundException {
        input.defaultReadObject();
        this.transportFactory = (HttpTransportFactory)ComputeEngineCredentials.newInstance(this.transportFactoryClassName);
    }
}

