/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.instrumentation.stats;

import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.instrumentation.stats.BucketBoundaries;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public final class Distribution {
    private long count = 0L;
    private double sum = 0.0;
    private final Range range = Range.create();
    private final BucketBoundaries bucketBoundaries;
    private long[] bucketCounts;

    public static final Distribution create() {
        return new Distribution(null);
    }

    public static final Distribution create(BucketBoundaries bucketBoundaries) {
        Preconditions.checkNotNull(bucketBoundaries, "bucketBoundaries Object should not be null.");
        return new Distribution(bucketBoundaries);
    }

    private boolean hasBuckets() {
        return this.bucketBoundaries != null;
    }

    private Distribution(@Nullable BucketBoundaries bucketBoundaries) {
        this.bucketBoundaries = bucketBoundaries;
        if (this.hasBuckets()) {
            this.bucketCounts = new long[bucketBoundaries.getBoundaries().size() + 1];
        }
    }

    public long getCount() {
        return this.count;
    }

    public double getMean() {
        return this.sum / (double)this.count;
    }

    public double getSum() {
        return this.sum;
    }

    public Range getRange() {
        return this.range;
    }

    @Nullable
    public List<Long> getBucketCounts() {
        if (this.hasBuckets()) {
            ArrayList<Long> boxedBucketCounts = new ArrayList<Long>(this.bucketCounts.length);
            for (long bucketCount : this.bucketCounts) {
                boxedBucketCounts.add(bucketCount);
            }
            return boxedBucketCounts;
        }
        return null;
    }

    private void putIntoBucket(double value) {
        for (int i = 0; i < this.bucketBoundaries.getBoundaries().size(); ++i) {
            if (!(value < this.bucketBoundaries.getBoundaries().get(i))) continue;
            int n = i;
            this.bucketCounts[n] = this.bucketCounts[n] + 1L;
            return;
        }
        int n = this.bucketCounts.length - 1;
        this.bucketCounts[n] = this.bucketCounts[n] + 1L;
    }

    public void add(double value) {
        ++this.count;
        this.sum += value;
        this.range.add(value);
        if (this.hasBuckets()) {
            this.putIntoBucket(value);
        }
    }

    public static final class Range {
        private Double min = null;
        private Double max = null;

        public static final Range create() {
            return new Range();
        }

        public double getMin() {
            return this.min;
        }

        public double getMax() {
            return this.max;
        }

        public void add(double value) {
            if (this.min == null || value < this.min) {
                this.min = value;
            }
            if (this.max == null || value > this.max) {
                this.max = value;
            }
        }

        private Range() {
        }
    }
}

