/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.instrumentation.stats;

import com.google.bigtable.repackaged.com.google.instrumentation.stats.AutoValue_MeasurementDescriptor;
import com.google.bigtable.repackaged.com.google.instrumentation.stats.AutoValue_MeasurementDescriptor_MeasurementUnit;
import com.google.bigtable.repackaged.com.google.instrumentation.stats.AutoValue_MeasurementDescriptor_Name;
import com.google.bigtable.repackaged.com.google.instrumentation.stats.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class MeasurementDescriptor {
    public static final int MAX_LENGTH = 255;

    MeasurementDescriptor() {
    }

    public static MeasurementDescriptor create(String name, String description, MeasurementUnit unit) {
        return MeasurementDescriptor.create(Name.create(name), description, unit);
    }

    public static MeasurementDescriptor create(Name name, String description, MeasurementUnit unit) {
        return new AutoValue_MeasurementDescriptor(name, description, unit);
    }

    public abstract Name getMeasurementDescriptorName();

    public final String getName() {
        return this.getMeasurementDescriptorName().asString();
    }

    public abstract String getDescription();

    public abstract MeasurementUnit getUnit();

    public static abstract class MeasurementUnit {
        MeasurementUnit() {
        }

        public static MeasurementUnit create(int power10, List<BasicUnit> numerators, List<BasicUnit> denominators) {
            return new AutoValue_MeasurementDescriptor_MeasurementUnit(power10, Collections.unmodifiableList(new ArrayList<BasicUnit>(numerators)), Collections.unmodifiableList(new ArrayList<BasicUnit>(denominators)));
        }

        public static MeasurementUnit create(int power10, List<BasicUnit> numerators) {
            return new AutoValue_MeasurementDescriptor_MeasurementUnit(power10, numerators, Collections.<BasicUnit>emptyList());
        }

        public abstract int getPower10();

        public abstract List<BasicUnit> getNumerators();

        public abstract List<BasicUnit> getDenominators();
    }

    public static abstract class Name {
        Name() {
        }

        public abstract String asString();

        public static Name create(String name) {
            return new AutoValue_MeasurementDescriptor_Name(StringUtil.sanitize(name));
        }
    }

    public static enum BasicUnit {
        SCALAR,
        BITS,
        BYTES,
        SECONDS,
        CORES;

    }
}

