/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.instrumentation.stats;

import com.google.bigtable.repackaged.com.google.instrumentation.stats.MeasurementDescriptor;
import com.google.bigtable.repackaged.com.google.instrumentation.stats.MeasurementValue;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class MeasurementMap
implements Iterable<MeasurementValue> {
    private final ArrayList<MeasurementValue> measurements;

    public static MeasurementMap of(MeasurementDescriptor measurement, double value) {
        return MeasurementMap.builder().put(measurement, value).build();
    }

    public static MeasurementMap of(MeasurementDescriptor measurement1, double value1, MeasurementDescriptor measurement2, double value2) {
        return MeasurementMap.builder().put(measurement1, value1).put(measurement2, value2).build();
    }

    public static MeasurementMap of(MeasurementDescriptor measurement1, double value1, MeasurementDescriptor measurement2, double value2, MeasurementDescriptor measurement3, double value3) {
        return MeasurementMap.builder().put(measurement1, value1).put(measurement2, value2).put(measurement3, value3).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public int size() {
        return this.measurements.size();
    }

    @Override
    public Iterator<MeasurementValue> iterator() {
        return new MeasurementMapIterator();
    }

    private MeasurementMap(ArrayList<MeasurementValue> measurements) {
        this.measurements = measurements;
    }

    private final class MeasurementMapIterator
    implements Iterator<MeasurementValue> {
        private final int length;
        private int position;

        private MeasurementMapIterator() {
            this.length = MeasurementMap.this.measurements.size();
            this.position = 0;
        }

        @Override
        public boolean hasNext() {
            return this.position < this.length;
        }

        @Override
        public MeasurementValue next() {
            if (this.position >= MeasurementMap.this.measurements.size()) {
                throw new NoSuchElementException();
            }
            return (MeasurementValue)MeasurementMap.this.measurements.get(this.position++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static class Builder {
        private final ArrayList<MeasurementValue> measurements = new ArrayList();

        public Builder put(MeasurementDescriptor measurement, double value) {
            this.measurements.add(MeasurementValue.create(measurement, value));
            return this;
        }

        public MeasurementMap build() {
            for (int i = 0; i < this.measurements.size(); ++i) {
                MeasurementDescriptor.Name current = this.measurements.get(i).getMeasurement().getMeasurementDescriptorName();
                for (int j = i + 1; j < this.measurements.size(); ++j) {
                    if (!current.equals(this.measurements.get(j).getMeasurement().getMeasurementDescriptorName())) continue;
                    this.measurements.remove(j);
                    --j;
                }
            }
            return new MeasurementMap(this.measurements);
        }

        private Builder() {
        }
    }
}

