/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.instrumentation.stats;

import com.google.bigtable.repackaged.com.google.instrumentation.common.Function;
import com.google.bigtable.repackaged.com.google.instrumentation.stats.DistributionAggregationDescriptor;
import com.google.bigtable.repackaged.com.google.instrumentation.stats.IntervalAggregationDescriptor;
import com.google.bigtable.repackaged.com.google.instrumentation.stats.MeasurementDescriptor;
import com.google.bigtable.repackaged.com.google.instrumentation.stats.TagKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class ViewDescriptor {
    private final String name;
    private final String description;
    private final MeasurementDescriptor measurementDescriptor;
    private final List<TagKey> tagKeys;

    public final String getName() {
        return this.name;
    }

    public final String getDescription() {
        return this.description;
    }

    public final MeasurementDescriptor getMeasurementDescriptor() {
        return this.measurementDescriptor;
    }

    public final List<TagKey> getTagKeys() {
        return this.tagKeys;
    }

    public abstract <T> T match(Function<DistributionViewDescriptor, T> var1, Function<IntervalViewDescriptor, T> var2);

    private ViewDescriptor(String name, String description, MeasurementDescriptor measurementDescriptor, List<TagKey> tagKeys) {
        this.name = name;
        this.description = description;
        this.measurementDescriptor = measurementDescriptor;
        this.tagKeys = Collections.unmodifiableList(new ArrayList<TagKey>(tagKeys));
    }

    public static class IntervalViewDescriptor
    extends ViewDescriptor {
        private final IntervalAggregationDescriptor intervalAggregationDescriptor;

        public static IntervalViewDescriptor create(String name, String description, MeasurementDescriptor measurementDescriptor, IntervalAggregationDescriptor intervalAggregationDescriptor, List<TagKey> tagKeys) {
            return new IntervalViewDescriptor(name, description, measurementDescriptor, intervalAggregationDescriptor, tagKeys);
        }

        public IntervalAggregationDescriptor getIntervalAggregationDescriptor() {
            return this.intervalAggregationDescriptor;
        }

        @Override
        public <T> T match(Function<DistributionViewDescriptor, T> p0, Function<IntervalViewDescriptor, T> p1) {
            return p1.apply(this);
        }

        private IntervalViewDescriptor(String name, String description, MeasurementDescriptor measurementDescriptor, IntervalAggregationDescriptor intervalAggregationDescriptor, List<TagKey> tagKeys) {
            super(name, description, measurementDescriptor, tagKeys);
            this.intervalAggregationDescriptor = intervalAggregationDescriptor;
        }
    }

    public static class DistributionViewDescriptor
    extends ViewDescriptor {
        private final DistributionAggregationDescriptor distributionAggregationDescriptor;

        public static DistributionViewDescriptor create(String name, String description, MeasurementDescriptor measurementDescriptor, DistributionAggregationDescriptor distributionAggregationDescriptor, List<TagKey> tagKeys) {
            return new DistributionViewDescriptor(name, description, measurementDescriptor, distributionAggregationDescriptor, tagKeys);
        }

        public DistributionAggregationDescriptor getDistributionAggregationDescriptor() {
            return this.distributionAggregationDescriptor;
        }

        @Override
        public <T> T match(Function<DistributionViewDescriptor, T> p0, Function<IntervalViewDescriptor, T> p1) {
            return p0.apply(this);
        }

        private DistributionViewDescriptor(String name, String description, MeasurementDescriptor measurementDescriptor, DistributionAggregationDescriptor distributionAggregationDescriptor, List<TagKey> tagKeys) {
            super(name, description, measurementDescriptor, tagKeys);
            this.distributionAggregationDescriptor = distributionAggregationDescriptor;
        }
    }
}

