/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.instrumentation.trace;

import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.instrumentation.trace.SpanContext;
import java.text.ParseException;

public abstract class BinaryPropagationHandler {
    static final NoopBinaryPropagationHandler noopBinaryPropagationHandler = new NoopBinaryPropagationHandler();

    public abstract byte[] toBinaryValue(SpanContext var1);

    public abstract SpanContext fromBinaryValue(byte[] var1) throws ParseException;

    static BinaryPropagationHandler getNoopBinaryPropagationHandler() {
        return noopBinaryPropagationHandler;
    }

    private static final class NoopBinaryPropagationHandler
    extends BinaryPropagationHandler {
        @Override
        public byte[] toBinaryValue(SpanContext spanContext) {
            Preconditions.checkNotNull(spanContext, "spanContext");
            return new byte[0];
        }

        @Override
        public SpanContext fromBinaryValue(byte[] bytes) throws ParseException {
            Preconditions.checkNotNull(bytes, "bytes");
            return SpanContext.INVALID;
        }

        private NoopBinaryPropagationHandler() {
        }
    }
}

