/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.instrumentation.trace;

import com.google.bigtable.repackaged.com.google.instrumentation.common.NonThrowingCloseable;
import com.google.bigtable.repackaged.com.google.instrumentation.trace.Span;
import com.google.bigtable.repackaged.io.grpc.Context;

public final class ContextUtils {
    public static final Context.Key<Span> CONTEXT_SPAN_KEY = Context.key("instrumentation-trace-key");

    private ContextUtils() {
    }

    static Span getCurrentSpan() {
        return CONTEXT_SPAN_KEY.get(Context.current());
    }

    static NonThrowingCloseable withSpan(Span span) {
        return new WithSpan(span, CONTEXT_SPAN_KEY);
    }

    private static final class WithSpan
    implements NonThrowingCloseable {
        private final Context origContext;

        WithSpan(Span span, Context.Key<Span> contextKey) {
            this.origContext = Context.current().withValue(contextKey, span).attach();
        }

        @Override
        public void close() {
            Context.current().detach(this.origContext);
        }
    }
}

