/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc;

import com.google.bigtable.repackaged.com.google.common.base.MoreObjects;
import com.google.bigtable.repackaged.com.google.common.base.Objects;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.io.grpc.Attributes;
import com.google.bigtable.repackaged.io.grpc.CallOptions;
import com.google.bigtable.repackaged.io.grpc.ClientStreamTracer;
import com.google.bigtable.repackaged.io.grpc.ConnectivityStateInfo;
import com.google.bigtable.repackaged.io.grpc.EquivalentAddressGroup;
import com.google.bigtable.repackaged.io.grpc.ManagedChannel;
import com.google.bigtable.repackaged.io.grpc.Metadata;
import com.google.bigtable.repackaged.io.grpc.MethodDescriptor;
import com.google.bigtable.repackaged.io.grpc.NameResolver;
import com.google.bigtable.repackaged.io.grpc.ResolvedServerInfo;
import com.google.bigtable.repackaged.io.grpc.ResolvedServerInfoGroup;
import com.google.bigtable.repackaged.io.grpc.Status;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;

@NotThreadSafe
public abstract class LoadBalancer {
    @Deprecated
    public void handleResolvedAddresses(List<ResolvedServerInfoGroup> servers, Attributes attributes) {
        throw new UnsupportedOperationException("This is deprecated and should not be called");
    }

    public void handleResolvedAddressGroups(List<EquivalentAddressGroup> servers, Attributes attributes) {
        ArrayList<ResolvedServerInfoGroup> serverInfoGroups = new ArrayList<ResolvedServerInfoGroup>(servers.size());
        for (EquivalentAddressGroup eag : servers) {
            ResolvedServerInfoGroup.Builder serverInfoGroupBuilder = ResolvedServerInfoGroup.builder(eag.getAttributes());
            for (SocketAddress addr : eag.getAddresses()) {
                serverInfoGroupBuilder.add(new ResolvedServerInfo(addr));
            }
            serverInfoGroups.add(serverInfoGroupBuilder.build());
        }
        this.handleResolvedAddresses(serverInfoGroups, attributes);
    }

    public abstract void handleNameResolutionError(Status var1);

    public abstract void handleSubchannelState(Subchannel var1, ConnectivityStateInfo var2);

    public abstract void shutdown();

    @ThreadSafe
    public static abstract class Factory {
        public abstract LoadBalancer newLoadBalancer(Helper var1);
    }

    @ThreadSafe
    public static abstract class Subchannel {
        public abstract void shutdown();

        public abstract void requestConnection();

        public abstract EquivalentAddressGroup getAddresses();

        public abstract Attributes getAttributes();
    }

    @ThreadSafe
    public static abstract class Helper {
        public abstract Subchannel createSubchannel(EquivalentAddressGroup var1, Attributes var2);

        public abstract ManagedChannel createOobChannel(EquivalentAddressGroup var1, String var2);

        public abstract void updatePicker(SubchannelPicker var1);

        public abstract void runSerialized(Runnable var1);

        public abstract NameResolver.Factory getNameResolverFactory();

        public abstract String getAuthority();
    }

    @Immutable
    public static final class PickResult {
        private static final PickResult NO_RESULT = new PickResult(null, null, Status.OK);
        @Nullable
        private final Subchannel subchannel;
        @Nullable
        private final ClientStreamTracer.Factory streamTracerFactory;
        private final Status status;

        private PickResult(@Nullable Subchannel subchannel, @Nullable ClientStreamTracer.Factory streamTracerFactory, Status status) {
            this.subchannel = subchannel;
            this.streamTracerFactory = streamTracerFactory;
            this.status = Preconditions.checkNotNull(status, "status");
        }

        public static PickResult withSubchannel(Subchannel subchannel, @Nullable ClientStreamTracer.Factory streamTracerFactory) {
            return new PickResult(Preconditions.checkNotNull(subchannel, "subchannel"), streamTracerFactory, Status.OK);
        }

        public static PickResult withSubchannel(Subchannel subchannel) {
            return PickResult.withSubchannel(subchannel, null);
        }

        public static PickResult withError(Status error) {
            Preconditions.checkArgument(!error.isOk(), "error status shouldn't be OK");
            return new PickResult(null, null, error);
        }

        public static PickResult withNoResult() {
            return NO_RESULT;
        }

        @Nullable
        public Subchannel getSubchannel() {
            return this.subchannel;
        }

        @Nullable
        public ClientStreamTracer.Factory getStreamTracerFactory() {
            return this.streamTracerFactory;
        }

        public Status getStatus() {
            return this.status;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("subchannel", this.subchannel).add("streamTracerFactory", this.streamTracerFactory).add("status", this.status).toString();
        }

        public int hashCode() {
            return Objects.hashCode(this.subchannel, this.status);
        }

        public boolean equals(Object other) {
            if (!(other instanceof PickResult)) {
                return false;
            }
            PickResult that = (PickResult)other;
            return Objects.equal(this.subchannel, that.subchannel) && Objects.equal(this.status, that.status);
        }
    }

    public static abstract class PickSubchannelArgs {
        public abstract CallOptions getCallOptions();

        public abstract Metadata getHeaders();

        public abstract MethodDescriptor<?, ?> getMethodDescriptor();
    }

    @ThreadSafe
    public static abstract class SubchannelPicker {
        public abstract PickResult pickSubchannel(PickSubchannelArgs var1);
    }
}

