/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc.inprocess;

import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.io.grpc.inprocess.InProcessSocketAddress;
import com.google.bigtable.repackaged.io.grpc.inprocess.InProcessTransport;
import com.google.bigtable.repackaged.io.grpc.internal.AbstractManagedChannelImplBuilder;
import com.google.bigtable.repackaged.io.grpc.internal.ClientTransportFactory;
import com.google.bigtable.repackaged.io.grpc.internal.ConnectionClientTransport;
import java.net.SocketAddress;

public class InProcessChannelBuilder
extends AbstractManagedChannelImplBuilder<InProcessChannelBuilder> {
    private final String name;

    public static InProcessChannelBuilder forName(String name) {
        return new InProcessChannelBuilder(name);
    }

    private InProcessChannelBuilder(String name) {
        super(new InProcessSocketAddress(name), "localhost");
        this.name = Preconditions.checkNotNull(name, "name");
    }

    @Override
    public final InProcessChannelBuilder maxInboundMessageSize(int max) {
        return (InProcessChannelBuilder)super.maxInboundMessageSize(max);
    }

    @Override
    public InProcessChannelBuilder usePlaintext(boolean skipNegotiation) {
        return this;
    }

    @Override
    protected ClientTransportFactory buildTransportFactory() {
        return new InProcessClientTransportFactory(this.name);
    }

    @Override
    protected boolean recordsStats() {
        return false;
    }

    static final class InProcessClientTransportFactory
    implements ClientTransportFactory {
        private final String name;
        private boolean closed;

        private InProcessClientTransportFactory(String name) {
            this.name = name;
        }

        @Override
        public ConnectionClientTransport newClientTransport(SocketAddress addr, String authority, String userAgent) {
            if (this.closed) {
                throw new IllegalStateException("The transport factory is closed.");
            }
            return new InProcessTransport(this.name, authority);
        }

        @Override
        public void close() {
            this.closed = true;
        }
    }
}

