/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc.internal;

import com.google.bigtable.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.bigtable.repackaged.com.google.common.base.MoreObjects;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.MoreExecutors;
import com.google.bigtable.repackaged.com.google.instrumentation.stats.Stats;
import com.google.bigtable.repackaged.com.google.instrumentation.stats.StatsContextFactory;
import com.google.bigtable.repackaged.io.grpc.Attributes;
import com.google.bigtable.repackaged.io.grpc.ClientInterceptor;
import com.google.bigtable.repackaged.io.grpc.CompressorRegistry;
import com.google.bigtable.repackaged.io.grpc.DecompressorRegistry;
import com.google.bigtable.repackaged.io.grpc.EquivalentAddressGroup;
import com.google.bigtable.repackaged.io.grpc.LoadBalancer;
import com.google.bigtable.repackaged.io.grpc.ManagedChannel;
import com.google.bigtable.repackaged.io.grpc.ManagedChannelBuilder;
import com.google.bigtable.repackaged.io.grpc.NameResolver;
import com.google.bigtable.repackaged.io.grpc.NameResolverProvider;
import com.google.bigtable.repackaged.io.grpc.PickFirstBalancerFactory;
import com.google.bigtable.repackaged.io.grpc.internal.CensusStreamTracerModule;
import com.google.bigtable.repackaged.io.grpc.internal.ClientTransportFactory;
import com.google.bigtable.repackaged.io.grpc.internal.ConnectionClientTransport;
import com.google.bigtable.repackaged.io.grpc.internal.ExponentialBackoffPolicy;
import com.google.bigtable.repackaged.io.grpc.internal.GrpcUtil;
import com.google.bigtable.repackaged.io.grpc.internal.ManagedChannelImpl;
import com.google.bigtable.repackaged.io.grpc.internal.ObjectPool;
import com.google.bigtable.repackaged.io.grpc.internal.SharedResourcePool;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public abstract class AbstractManagedChannelImplBuilder<T extends AbstractManagedChannelImplBuilder<T>>
extends ManagedChannelBuilder<T> {
    private static final String DIRECT_ADDRESS_SCHEME = "directaddress";
    @VisibleForTesting
    static final long IDLE_MODE_MAX_TIMEOUT_DAYS = 30L;
    @VisibleForTesting
    static final long IDLE_MODE_DEFAULT_TIMEOUT_MILLIS = TimeUnit.MINUTES.toMillis(30L);
    @VisibleForTesting
    static final long IDLE_MODE_MIN_TIMEOUT_MILLIS = TimeUnit.SECONDS.toMillis(1L);
    @Nullable
    private Executor executor;
    private final List<ClientInterceptor> interceptors = new ArrayList<ClientInterceptor>();
    private final String target;
    @Nullable
    private final SocketAddress directServerAddress;
    @Nullable
    private String userAgent;
    @Nullable
    private String authorityOverride;
    @Nullable
    private NameResolver.Factory nameResolverFactory;
    private LoadBalancer.Factory loadBalancerFactory;
    @Nullable
    private DecompressorRegistry decompressorRegistry;
    @Nullable
    private CompressorRegistry compressorRegistry;
    private long idleTimeoutMillis = IDLE_MODE_DEFAULT_TIMEOUT_MILLIS;
    private int maxInboundMessageSize = 0x400000;
    @Nullable
    private StatsContextFactory statsFactory;

    @Override
    public T maxInboundMessageSize(int max) {
        Preconditions.checkArgument(max >= 0, "negative max");
        this.maxInboundMessageSize = max;
        return this.thisT();
    }

    protected final int maxInboundMessageSize() {
        return this.maxInboundMessageSize;
    }

    protected AbstractManagedChannelImplBuilder(String target) {
        this.target = Preconditions.checkNotNull(target, "target");
        this.directServerAddress = null;
    }

    @VisibleForTesting
    static String makeTargetStringForDirectAddress(SocketAddress address) {
        try {
            return new URI(DIRECT_ADDRESS_SCHEME, "", "/" + address, null).toString();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    protected AbstractManagedChannelImplBuilder(SocketAddress directServerAddress, String authority) {
        this.target = AbstractManagedChannelImplBuilder.makeTargetStringForDirectAddress(directServerAddress);
        this.directServerAddress = directServerAddress;
        this.nameResolverFactory = new DirectAddressNameResolverFactory(directServerAddress, authority);
    }

    @Override
    public final T directExecutor() {
        return (T)this.executor(MoreExecutors.directExecutor());
    }

    @Override
    public final T executor(Executor executor) {
        this.executor = executor;
        return this.thisT();
    }

    @Override
    public final T intercept(List<ClientInterceptor> interceptors) {
        this.interceptors.addAll(interceptors);
        return this.thisT();
    }

    @Override
    public final T intercept(ClientInterceptor ... interceptors) {
        return (T)this.intercept((List)Arrays.asList(interceptors));
    }

    @Override
    public final T nameResolverFactory(NameResolver.Factory resolverFactory) {
        Preconditions.checkState(this.directServerAddress == null, "directServerAddress is set (%s), which forbids the use of NameResolverFactory", this.directServerAddress);
        this.nameResolverFactory = resolverFactory;
        return this.thisT();
    }

    @Override
    public final T loadBalancerFactory(LoadBalancer.Factory loadBalancerFactory) {
        Preconditions.checkState(this.directServerAddress == null, "directServerAddress is set (%s), which forbids the use of LoadBalancer.Factory", this.directServerAddress);
        this.loadBalancerFactory = loadBalancerFactory;
        return this.thisT();
    }

    @Override
    public final T decompressorRegistry(DecompressorRegistry registry) {
        this.decompressorRegistry = registry;
        return this.thisT();
    }

    @Override
    public final T compressorRegistry(CompressorRegistry registry) {
        this.compressorRegistry = registry;
        return this.thisT();
    }

    @Override
    public final T userAgent(@Nullable String userAgent) {
        this.userAgent = userAgent;
        return this.thisT();
    }

    @Override
    public final T overrideAuthority(String authority) {
        this.authorityOverride = this.checkAuthority(authority);
        return this.thisT();
    }

    @Override
    public final T idleTimeout(long value, TimeUnit unit) {
        Preconditions.checkArgument(value > 0L, "idle timeout is %s, but must be positive", value);
        this.idleTimeoutMillis = unit.toDays(value) >= 30L ? -1L : Math.max(unit.toMillis(value), IDLE_MODE_MIN_TIMEOUT_MILLIS);
        return this.thisT();
    }

    @VisibleForTesting
    protected final T statsContextFactory(StatsContextFactory statsFactory) {
        this.statsFactory = statsFactory;
        return this.thisT();
    }

    protected boolean recordsStats() {
        return true;
    }

    @VisibleForTesting
    final long getIdleTimeoutMillis() {
        return this.idleTimeoutMillis;
    }

    protected String checkAuthority(String authority) {
        return GrpcUtil.checkAuthority(authority);
    }

    @Override
    public ManagedChannel build() {
        NameResolver.Factory nameResolverFactory;
        ClientTransportFactory transportFactory = this.buildTransportFactory();
        if (this.authorityOverride != null) {
            transportFactory = new AuthorityOverridingTransportFactory(transportFactory, this.authorityOverride);
        }
        if ((nameResolverFactory = this.nameResolverFactory) == null) {
            nameResolverFactory = NameResolverProvider.asFactory();
        }
        List<ClientInterceptor> interceptors = this.interceptors;
        if (this.recordsStats()) {
            StatsContextFactory statsCtxFactory;
            StatsContextFactory statsContextFactory = statsCtxFactory = this.statsFactory != null ? this.statsFactory : Stats.getStatsContextFactory();
            if (statsCtxFactory != null) {
                interceptors = new ArrayList<ClientInterceptor>(this.interceptors);
                CensusStreamTracerModule census = new CensusStreamTracerModule(statsCtxFactory, GrpcUtil.STOPWATCH_SUPPLIER);
                interceptors.add(0, census.getClientInterceptor());
            }
        }
        return new ManagedChannelImpl(this.target, new ExponentialBackoffPolicy.Provider(), nameResolverFactory, this.getNameResolverParams(), MoreObjects.firstNonNull(this.loadBalancerFactory, PickFirstBalancerFactory.getInstance()), transportFactory, MoreObjects.firstNonNull(this.decompressorRegistry, DecompressorRegistry.getDefaultInstance()), MoreObjects.firstNonNull(this.compressorRegistry, CompressorRegistry.getDefaultInstance()), SharedResourcePool.forResource(GrpcUtil.TIMER_SERVICE), AbstractManagedChannelImplBuilder.getExecutorPool(this.executor), SharedResourcePool.forResource(GrpcUtil.SHARED_CHANNEL_EXECUTOR), GrpcUtil.STOPWATCH_SUPPLIER, this.idleTimeoutMillis, this.userAgent, interceptors);
    }

    protected abstract ClientTransportFactory buildTransportFactory();

    protected Attributes getNameResolverParams() {
        return Attributes.EMPTY;
    }

    private static ObjectPool<? extends Executor> getExecutorPool(final @Nullable Executor executor) {
        if (executor != null) {
            return new ObjectPool<Executor>(){

                @Override
                public Executor getObject() {
                    return executor;
                }

                @Override
                public Executor returnObject(Object returned) {
                    return null;
                }
            };
        }
        return SharedResourcePool.forResource(GrpcUtil.SHARED_CHANNEL_EXECUTOR);
    }

    private T thisT() {
        AbstractManagedChannelImplBuilder thisT = this;
        return (T)thisT;
    }

    private static class DirectAddressNameResolverFactory
    extends NameResolver.Factory {
        final SocketAddress address;
        final String authority;

        DirectAddressNameResolverFactory(SocketAddress address, String authority) {
            this.address = address;
            this.authority = authority;
        }

        @Override
        public NameResolver newNameResolver(URI notUsedUri, Attributes params) {
            return new NameResolver(){

                @Override
                public String getServiceAuthority() {
                    return DirectAddressNameResolverFactory.this.authority;
                }

                @Override
                public void start(NameResolver.Listener listener) {
                    listener.onAddresses(Collections.singletonList(new EquivalentAddressGroup(DirectAddressNameResolverFactory.this.address)), Attributes.EMPTY);
                }

                @Override
                public void shutdown() {
                }
            };
        }

        @Override
        public String getDefaultScheme() {
            return AbstractManagedChannelImplBuilder.DIRECT_ADDRESS_SCHEME;
        }
    }

    private static class AuthorityOverridingTransportFactory
    implements ClientTransportFactory {
        final ClientTransportFactory factory;
        final String authorityOverride;

        AuthorityOverridingTransportFactory(ClientTransportFactory factory, String authorityOverride) {
            this.factory = Preconditions.checkNotNull(factory, "factory should not be null");
            this.authorityOverride = Preconditions.checkNotNull(authorityOverride, "authorityOverride should not be null");
        }

        @Override
        public ConnectionClientTransport newClientTransport(SocketAddress serverAddress, String authority, @Nullable String userAgent) {
            return this.factory.newClientTransport(serverAddress, this.authorityOverride, userAgent);
        }

        @Override
        public void close() {
            this.factory.close();
        }
    }
}

