/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc.internal;

import com.google.bigtable.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.bigtable.repackaged.com.google.common.base.MoreObjects;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.MoreExecutors;
import com.google.bigtable.repackaged.com.google.instrumentation.stats.Stats;
import com.google.bigtable.repackaged.com.google.instrumentation.stats.StatsContextFactory;
import com.google.bigtable.repackaged.io.grpc.BindableService;
import com.google.bigtable.repackaged.io.grpc.CompressorRegistry;
import com.google.bigtable.repackaged.io.grpc.Context;
import com.google.bigtable.repackaged.io.grpc.DecompressorRegistry;
import com.google.bigtable.repackaged.io.grpc.HandlerRegistry;
import com.google.bigtable.repackaged.io.grpc.InternalNotifyOnServerBuild;
import com.google.bigtable.repackaged.io.grpc.ServerBuilder;
import com.google.bigtable.repackaged.io.grpc.ServerMethodDefinition;
import com.google.bigtable.repackaged.io.grpc.ServerServiceDefinition;
import com.google.bigtable.repackaged.io.grpc.ServerStreamTracer;
import com.google.bigtable.repackaged.io.grpc.ServerTransportFilter;
import com.google.bigtable.repackaged.io.grpc.internal.CensusStreamTracerModule;
import com.google.bigtable.repackaged.io.grpc.internal.GrpcUtil;
import com.google.bigtable.repackaged.io.grpc.internal.InternalHandlerRegistry;
import com.google.bigtable.repackaged.io.grpc.internal.InternalServer;
import com.google.bigtable.repackaged.io.grpc.internal.ObjectPool;
import com.google.bigtable.repackaged.io.grpc.internal.ServerImpl;
import com.google.bigtable.repackaged.io.grpc.internal.SharedResourcePool;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;

public abstract class AbstractServerImplBuilder<T extends AbstractServerImplBuilder<T>>
extends ServerBuilder<T> {
    private static final HandlerRegistry EMPTY_FALLBACK_REGISTRY = new HandlerRegistry(){

        @Override
        public List<ServerServiceDefinition> getServices() {
            return Collections.emptyList();
        }

        @Override
        public ServerMethodDefinition<?, ?> lookupMethod(String methodName, @Nullable String authority) {
            return null;
        }
    };
    private final InternalHandlerRegistry.Builder registryBuilder = new InternalHandlerRegistry.Builder();
    private final ArrayList<ServerTransportFilter> transportFilters = new ArrayList();
    private final List<InternalNotifyOnServerBuild> notifyOnBuildList = new ArrayList<InternalNotifyOnServerBuild>();
    private final List<ServerStreamTracer.Factory> streamTracerFactories = new ArrayList<ServerStreamTracer.Factory>();
    @Nullable
    private HandlerRegistry fallbackRegistry;
    @Nullable
    private Executor executor;
    @Nullable
    private DecompressorRegistry decompressorRegistry;
    @Nullable
    private CompressorRegistry compressorRegistry;
    @Nullable
    private StatsContextFactory statsFactory;

    @Override
    public final T directExecutor() {
        return (T)this.executor(MoreExecutors.directExecutor());
    }

    @Override
    public final T executor(@Nullable Executor executor) {
        this.executor = executor;
        return this.thisT();
    }

    @Override
    public final T addService(ServerServiceDefinition service) {
        this.registryBuilder.addService(service);
        return this.thisT();
    }

    @Override
    public final T addService(BindableService bindableService) {
        if (bindableService instanceof InternalNotifyOnServerBuild) {
            this.notifyOnBuildList.add((InternalNotifyOnServerBuild)((Object)bindableService));
        }
        return (T)this.addService(bindableService.bindService());
    }

    @Override
    public final T addTransportFilter(ServerTransportFilter filter) {
        this.transportFilters.add(Preconditions.checkNotNull(filter, "filter"));
        return this.thisT();
    }

    @Override
    public final T addStreamTracerFactory(ServerStreamTracer.Factory factory) {
        this.streamTracerFactories.add(Preconditions.checkNotNull(factory, "factory"));
        return this.thisT();
    }

    @Override
    public final T fallbackHandlerRegistry(HandlerRegistry registry) {
        this.fallbackRegistry = registry;
        return this.thisT();
    }

    @Override
    public final T decompressorRegistry(DecompressorRegistry registry) {
        this.decompressorRegistry = registry;
        return this.thisT();
    }

    @Override
    public final T compressorRegistry(CompressorRegistry registry) {
        this.compressorRegistry = registry;
        return this.thisT();
    }

    @VisibleForTesting
    protected T statsContextFactory(StatsContextFactory statsFactory) {
        this.statsFactory = statsFactory;
        return this.thisT();
    }

    @Override
    public ServerImpl build() {
        StatsContextFactory statsFactory;
        ArrayList<ServerStreamTracer.Factory> tracerFactories = new ArrayList<ServerStreamTracer.Factory>();
        StatsContextFactory statsContextFactory = statsFactory = this.statsFactory != null ? this.statsFactory : Stats.getStatsContextFactory();
        if (statsFactory != null) {
            CensusStreamTracerModule census = new CensusStreamTracerModule(statsFactory, GrpcUtil.STOPWATCH_SUPPLIER);
            tracerFactories.add(census.getServerTracerFactory());
        }
        tracerFactories.addAll(this.streamTracerFactories);
        InternalServer transportServer = this.buildTransportServer(Collections.unmodifiableList(tracerFactories));
        ServerImpl server = new ServerImpl(this.getExecutorPool(), SharedResourcePool.forResource(GrpcUtil.TIMER_SERVICE), this.registryBuilder.build(), MoreObjects.firstNonNull(this.fallbackRegistry, EMPTY_FALLBACK_REGISTRY), transportServer, Context.ROOT, MoreObjects.firstNonNull(this.decompressorRegistry, DecompressorRegistry.getDefaultInstance()), MoreObjects.firstNonNull(this.compressorRegistry, CompressorRegistry.getDefaultInstance()), this.transportFilters);
        for (InternalNotifyOnServerBuild notifyTarget : this.notifyOnBuildList) {
            notifyTarget.notifyOnBuild(server);
        }
        return server;
    }

    private ObjectPool<? extends Executor> getExecutorPool() {
        final Executor savedExecutor = this.executor;
        if (savedExecutor == null) {
            return SharedResourcePool.forResource(GrpcUtil.SHARED_CHANNEL_EXECUTOR);
        }
        return new ObjectPool<Executor>(){

            @Override
            public Executor getObject() {
                return savedExecutor;
            }

            @Override
            public Executor returnObject(Object object) {
                return null;
            }
        };
    }

    protected abstract InternalServer buildTransportServer(List<ServerStreamTracer.Factory> var1);

    private T thisT() {
        AbstractServerImplBuilder thisT = this;
        return (T)thisT;
    }
}

