/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc.internal;

import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.io.grpc.Codec;
import com.google.bigtable.repackaged.io.grpc.Compressor;
import com.google.bigtable.repackaged.io.grpc.Decompressor;
import com.google.bigtable.repackaged.io.grpc.internal.Framer;
import com.google.bigtable.repackaged.io.grpc.internal.MessageDeframer;
import com.google.bigtable.repackaged.io.grpc.internal.ReadableBuffer;
import com.google.bigtable.repackaged.io.grpc.internal.StatsTraceContext;
import com.google.bigtable.repackaged.io.grpc.internal.Stream;
import com.google.bigtable.repackaged.io.grpc.internal.StreamListener;
import java.io.InputStream;
import javax.annotation.concurrent.GuardedBy;

public abstract class AbstractStream2
implements Stream {
    protected abstract Framer framer();

    protected abstract TransportState transportState();

    @Override
    public final void setMessageCompression(boolean enable) {
        this.framer().setMessageCompression(enable);
    }

    @Override
    public final void writeMessage(InputStream message) {
        Preconditions.checkNotNull(message, "message");
        if (!this.framer().isClosed()) {
            this.framer().writePayload(message);
        }
    }

    @Override
    public final void flush() {
        if (!this.framer().isClosed()) {
            this.framer().flush();
        }
    }

    protected final void endOfMessages() {
        this.framer().close();
    }

    @Override
    public final void setCompressor(Compressor compressor) {
        this.framer().setCompressor(Preconditions.checkNotNull(compressor, "compressor"));
    }

    @Override
    public final void setDecompressor(Decompressor decompressor) {
        this.transportState().setDecompressor(Preconditions.checkNotNull(decompressor, "decompressor"));
    }

    @Override
    public boolean isReady() {
        if (this.framer().isClosed()) {
            return false;
        }
        return this.transportState().isReady();
    }

    protected final void onSendingBytes(int numBytes) {
        this.transportState().onSendingBytes(numBytes);
    }

    public static abstract class TransportState
    implements MessageDeframer.Listener {
        private static final int DEFAULT_ONREADY_THRESHOLD = 32768;
        private final MessageDeframer deframer;
        private final Object onReadyLock = new Object();
        private final StatsTraceContext statsTraceCtx;
        @GuardedBy(value="onReadyLock")
        private int numSentBytesQueued;
        @GuardedBy(value="onReadyLock")
        private boolean allocated;
        @GuardedBy(value="onReadyLock")
        private boolean deallocated;

        protected TransportState(int maxMessageSize, StatsTraceContext statsTraceCtx) {
            this.statsTraceCtx = Preconditions.checkNotNull(statsTraceCtx, "statsTraceCtx");
            this.deframer = new MessageDeframer(this, Codec.Identity.NONE, maxMessageSize, statsTraceCtx, this.getClass().getName());
        }

        final void setMaxInboundMessageSize(int maxSize) {
            this.deframer.setMaxInboundMessageSize(maxSize);
        }

        protected abstract StreamListener listener();

        @Override
        public void messageRead(InputStream is) {
            this.listener().messageRead(is);
        }

        protected abstract void deframeFailed(Throwable var1);

        protected final void closeDeframer() {
            this.deframer.close();
        }

        protected final boolean isDeframerStalled() {
            return this.deframer.isStalled();
        }

        protected final void deframe(ReadableBuffer frame, boolean endOfStream) {
            if (this.deframer.isClosed()) {
                frame.close();
                return;
            }
            try {
                this.deframer.deframe(frame, endOfStream);
            }
            catch (Throwable t) {
                this.deframeFailed(t);
            }
        }

        public final void requestMessagesFromDeframer(int numMessages) {
            if (this.deframer.isClosed()) {
                return;
            }
            try {
                this.deframer.request(numMessages);
            }
            catch (Throwable t) {
                this.deframeFailed(t);
            }
        }

        public final StatsTraceContext getStatsTraceContext() {
            return this.statsTraceCtx;
        }

        private void setDecompressor(Decompressor decompressor) {
            if (this.deframer.isClosed()) {
                return;
            }
            this.deframer.setDecompressor(decompressor);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isReady() {
            Object object = this.onReadyLock;
            synchronized (object) {
                return this.allocated && this.numSentBytesQueued < 32768 && !this.deallocated;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void onStreamAllocated() {
            Preconditions.checkState(this.listener() != null);
            Object object = this.onReadyLock;
            synchronized (object) {
                Preconditions.checkState(!this.allocated, "Already allocated");
                this.allocated = true;
            }
            this.notifyIfReady();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void onStreamDeallocated() {
            Object object = this.onReadyLock;
            synchronized (object) {
                this.deallocated = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onSendingBytes(int numBytes) {
            Object object = this.onReadyLock;
            synchronized (object) {
                this.numSentBytesQueued += numBytes;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void onSentBytes(int numBytes) {
            boolean doNotify;
            Object object = this.onReadyLock;
            synchronized (object) {
                Preconditions.checkState(this.allocated, "onStreamAllocated was not called, but it seems the stream is active");
                boolean belowThresholdBefore = this.numSentBytesQueued < 32768;
                this.numSentBytesQueued -= numBytes;
                boolean belowThresholdAfter = this.numSentBytesQueued < 32768;
                doNotify = !belowThresholdBefore && belowThresholdAfter;
            }
            if (doNotify) {
                this.notifyIfReady();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyIfReady() {
            boolean doNotify;
            Object object = this.onReadyLock;
            synchronized (object) {
                doNotify = this.isReady();
            }
            if (doNotify) {
                this.listener().onReady();
            }
        }
    }
}

