/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc.internal;

import com.google.bigtable.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class ChannelExecutor {
    private static final Logger log = Logger.getLogger(ChannelExecutor.class.getName());
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    private final LinkedList<Runnable> queue = new LinkedList();
    @GuardedBy(value="lock")
    private boolean draining;

    ChannelExecutor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void drain() {
        boolean drainLeaseAcquired = false;
        while (true) {
            Runnable runnable;
            Object object = this.lock;
            synchronized (object) {
                if (!drainLeaseAcquired) {
                    if (this.draining) {
                        return;
                    }
                    this.draining = true;
                    drainLeaseAcquired = true;
                }
                if ((runnable = this.queue.poll()) == null) {
                    this.draining = false;
                    break;
                }
            }
            try {
                runnable.run();
            }
            catch (Throwable t) {
                log.log(Level.WARNING, "Runnable threw exception in ChannelExecutor", t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ChannelExecutor executeLater(Runnable runnable) {
        Object object = this.lock;
        synchronized (object) {
            this.queue.add(Preconditions.checkNotNull(runnable, "runnable is null"));
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    int numPendingTasks() {
        Object object = this.lock;
        synchronized (object) {
            return this.queue.size();
        }
    }
}

