/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc.internal;

import com.google.bigtable.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.MoreExecutors;
import com.google.bigtable.repackaged.io.grpc.Attributes;
import com.google.bigtable.repackaged.io.grpc.CallOptions;
import com.google.bigtable.repackaged.io.grpc.ClientCall;
import com.google.bigtable.repackaged.io.grpc.Codec;
import com.google.bigtable.repackaged.io.grpc.Compressor;
import com.google.bigtable.repackaged.io.grpc.CompressorRegistry;
import com.google.bigtable.repackaged.io.grpc.Context;
import com.google.bigtable.repackaged.io.grpc.Contexts;
import com.google.bigtable.repackaged.io.grpc.Deadline;
import com.google.bigtable.repackaged.io.grpc.Decompressor;
import com.google.bigtable.repackaged.io.grpc.DecompressorRegistry;
import com.google.bigtable.repackaged.io.grpc.InternalDecompressorRegistry;
import com.google.bigtable.repackaged.io.grpc.LoadBalancer;
import com.google.bigtable.repackaged.io.grpc.Metadata;
import com.google.bigtable.repackaged.io.grpc.MethodDescriptor;
import com.google.bigtable.repackaged.io.grpc.Status;
import com.google.bigtable.repackaged.io.grpc.internal.ClientStream;
import com.google.bigtable.repackaged.io.grpc.internal.ClientStreamListener;
import com.google.bigtable.repackaged.io.grpc.internal.ClientTransport;
import com.google.bigtable.repackaged.io.grpc.internal.ContextRunnable;
import com.google.bigtable.repackaged.io.grpc.internal.FailingClientStream;
import com.google.bigtable.repackaged.io.grpc.internal.GrpcUtil;
import com.google.bigtable.repackaged.io.grpc.internal.LogExceptionRunnable;
import com.google.bigtable.repackaged.io.grpc.internal.NoopClientStream;
import com.google.bigtable.repackaged.io.grpc.internal.PickSubchannelArgsImpl;
import com.google.bigtable.repackaged.io.grpc.internal.SerializeReentrantCallsDirectExecutor;
import com.google.bigtable.repackaged.io.grpc.internal.SerializingExecutor;
import java.io.InputStream;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

final class ClientCallImpl<ReqT, RespT>
extends ClientCall<ReqT, RespT>
implements Context.CancellationListener {
    private static final Logger log = Logger.getLogger(ClientCallImpl.class.getName());
    private final MethodDescriptor<ReqT, RespT> method;
    private final Executor callExecutor;
    private final Context context;
    private volatile ScheduledFuture<?> deadlineCancellationFuture;
    private final boolean unaryRequest;
    private final CallOptions callOptions;
    private ClientStream stream;
    private volatile boolean cancelListenersShouldBeRemoved;
    private boolean cancelCalled;
    private boolean halfCloseCalled;
    private final ClientTransportProvider clientTransportProvider;
    private ScheduledExecutorService deadlineCancellationExecutor;
    private DecompressorRegistry decompressorRegistry = DecompressorRegistry.getDefaultInstance();
    private CompressorRegistry compressorRegistry = CompressorRegistry.getDefaultInstance();

    ClientCallImpl(MethodDescriptor<ReqT, RespT> method, Executor executor, CallOptions callOptions, ClientTransportProvider clientTransportProvider, ScheduledExecutorService deadlineCancellationExecutor) {
        this.method = method;
        this.callExecutor = executor == MoreExecutors.directExecutor() ? new SerializeReentrantCallsDirectExecutor() : new SerializingExecutor(executor);
        this.context = Context.current();
        this.unaryRequest = method.getType() == MethodDescriptor.MethodType.UNARY || method.getType() == MethodDescriptor.MethodType.SERVER_STREAMING;
        this.callOptions = callOptions;
        this.clientTransportProvider = clientTransportProvider;
        this.deadlineCancellationExecutor = deadlineCancellationExecutor;
    }

    @Override
    public void cancelled(Context context) {
        this.stream.cancel(Contexts.statusFromCancelled(context));
    }

    ClientCallImpl<ReqT, RespT> setDecompressorRegistry(DecompressorRegistry decompressorRegistry) {
        this.decompressorRegistry = decompressorRegistry;
        return this;
    }

    ClientCallImpl<ReqT, RespT> setCompressorRegistry(CompressorRegistry compressorRegistry) {
        this.compressorRegistry = compressorRegistry;
        return this;
    }

    @VisibleForTesting
    static void prepareHeaders(Metadata headers, DecompressorRegistry decompressorRegistry, Compressor compressor) {
        headers.discardAll(GrpcUtil.MESSAGE_ENCODING_KEY);
        if (compressor != Codec.Identity.NONE) {
            headers.put(GrpcUtil.MESSAGE_ENCODING_KEY, compressor.getMessageEncoding());
        }
        headers.discardAll(GrpcUtil.MESSAGE_ACCEPT_ENCODING_KEY);
        byte[] advertisedEncodings = InternalDecompressorRegistry.getRawAdvertisedMessageEncodings(decompressorRegistry);
        if (advertisedEncodings.length != 0) {
            headers.put(GrpcUtil.MESSAGE_ACCEPT_ENCODING_KEY, advertisedEncodings);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(final ClientCall.Listener<RespT> observer, Metadata headers) {
        boolean deadlineExceeded;
        Preconditions.checkState(this.stream == null, "Already started");
        Preconditions.checkNotNull(observer, "observer");
        Preconditions.checkNotNull(headers, "headers");
        if (this.context.isCancelled()) {
            this.stream = NoopClientStream.INSTANCE;
            class ClosedByContext
            extends ContextRunnable {
                ClosedByContext() {
                    super(ClientCallImpl.this.context);
                }

                @Override
                public void runInContext() {
                    ClientCallImpl.this.closeObserver(observer, Contexts.statusFromCancelled(ClientCallImpl.this.context), new Metadata());
                }
            }
            this.callExecutor.execute(new ClosedByContext());
            return;
        }
        final String compressorName = this.callOptions.getCompressor();
        Compressor compressor = null;
        if (compressorName != null) {
            compressor = this.compressorRegistry.lookupCompressor(compressorName);
            if (compressor == null) {
                this.stream = NoopClientStream.INSTANCE;
                class ClosedByNotFoundCompressor
                extends ContextRunnable {
                    ClosedByNotFoundCompressor() {
                        super(ClientCallImpl.this.context);
                    }

                    @Override
                    public void runInContext() {
                        ClientCallImpl.this.closeObserver(observer, Status.INTERNAL.withDescription(String.format("Unable to find compressor by name %s", compressorName)), new Metadata());
                    }
                }
                this.callExecutor.execute(new ClosedByNotFoundCompressor());
                return;
            }
        } else {
            compressor = Codec.Identity.NONE;
        }
        ClientCallImpl.prepareHeaders(headers, this.decompressorRegistry, compressor);
        Deadline effectiveDeadline = this.effectiveDeadline();
        boolean bl = deadlineExceeded = effectiveDeadline != null && effectiveDeadline.isExpired();
        if (!deadlineExceeded) {
            ClientCallImpl.updateTimeoutHeaders(effectiveDeadline, this.callOptions.getDeadline(), this.context.getDeadline(), headers);
            ClientTransport transport = this.clientTransportProvider.get(new PickSubchannelArgsImpl(this.method, headers, this.callOptions));
            Context origContext = this.context.attach();
            try {
                this.stream = transport.newStream(this.method, headers, this.callOptions);
            }
            finally {
                this.context.detach(origContext);
            }
        } else {
            this.stream = new FailingClientStream(Status.DEADLINE_EXCEEDED);
        }
        if (this.callOptions.getAuthority() != null) {
            this.stream.setAuthority(this.callOptions.getAuthority());
        }
        if (this.callOptions.getMaxInboundMessageSize() != null) {
            this.stream.setMaxInboundMessageSize(this.callOptions.getMaxInboundMessageSize());
        }
        if (this.callOptions.getMaxOutboundMessageSize() != null) {
            this.stream.setMaxOutboundMessageSize(this.callOptions.getMaxOutboundMessageSize());
        }
        this.stream.setCompressor(compressor);
        this.stream.start(new ClientStreamListenerImpl(observer));
        this.context.addListener(this, MoreExecutors.directExecutor());
        if (effectiveDeadline != null && this.context.getDeadline() != effectiveDeadline && this.deadlineCancellationExecutor != null) {
            this.deadlineCancellationFuture = this.startDeadlineTimer(effectiveDeadline);
        }
        if (this.cancelListenersShouldBeRemoved) {
            this.removeContextListenerAndCancelDeadlineFuture();
        }
    }

    private static void updateTimeoutHeaders(@Nullable Deadline effectiveDeadline, @Nullable Deadline callDeadline, @Nullable Deadline outerCallDeadline, Metadata headers) {
        headers.discardAll(GrpcUtil.TIMEOUT_KEY);
        if (effectiveDeadline == null) {
            return;
        }
        long effectiveTimeout = Math.max(0L, effectiveDeadline.timeRemaining(TimeUnit.NANOSECONDS));
        headers.put(GrpcUtil.TIMEOUT_KEY, effectiveTimeout);
        ClientCallImpl.logIfContextNarrowedTimeout(effectiveTimeout, effectiveDeadline, outerCallDeadline, callDeadline);
    }

    private static void logIfContextNarrowedTimeout(long effectiveTimeout, Deadline effectiveDeadline, @Nullable Deadline outerCallDeadline, @Nullable Deadline callDeadline) {
        if (!log.isLoggable(Level.INFO) || outerCallDeadline != effectiveDeadline) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("Call timeout set to '%d' ns, due to context deadline.", effectiveTimeout));
        if (callDeadline == null) {
            builder.append(" Explicit call timeout was not set.");
        } else {
            long callTimeout = callDeadline.timeRemaining(TimeUnit.NANOSECONDS);
            builder.append(String.format(" Explicit call timeout was '%d' ns.", callTimeout));
        }
        log.info(builder.toString());
    }

    private void removeContextListenerAndCancelDeadlineFuture() {
        this.context.removeListener(this);
        ScheduledFuture<?> f = this.deadlineCancellationFuture;
        if (f != null) {
            f.cancel(false);
        }
    }

    private ScheduledFuture<?> startDeadlineTimer(Deadline deadline) {
        return this.deadlineCancellationExecutor.schedule(new LogExceptionRunnable(new DeadlineTimer()), deadline.timeRemaining(TimeUnit.NANOSECONDS), TimeUnit.NANOSECONDS);
    }

    @Nullable
    private Deadline effectiveDeadline() {
        return ClientCallImpl.min(this.callOptions.getDeadline(), this.context.getDeadline());
    }

    @Nullable
    private static Deadline min(@Nullable Deadline deadline0, @Nullable Deadline deadline1) {
        if (deadline0 == null) {
            return deadline1;
        }
        if (deadline1 == null) {
            return deadline0;
        }
        return deadline0.minimum(deadline1);
    }

    @Override
    public void request(int numMessages) {
        Preconditions.checkState(this.stream != null, "Not started");
        Preconditions.checkArgument(numMessages >= 0, "Number requested must be non-negative");
        this.stream.request(numMessages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel(@Nullable String message, @Nullable Throwable cause) {
        if (message == null && cause == null) {
            cause = new CancellationException("Cancelled without a message or cause");
            log.log(Level.WARNING, "Cancelling without a message or cause is suboptimal", cause);
        }
        if (this.cancelCalled) {
            return;
        }
        this.cancelCalled = true;
        try {
            if (this.stream != null) {
                Status status = Status.CANCELLED;
                if (message != null) {
                    status = status.withDescription(message);
                }
                if (cause != null) {
                    status = status.withCause(cause);
                }
                this.stream.cancel(status);
            }
        }
        finally {
            this.removeContextListenerAndCancelDeadlineFuture();
        }
    }

    @Override
    public void halfClose() {
        Preconditions.checkState(this.stream != null, "Not started");
        Preconditions.checkState(!this.cancelCalled, "call was cancelled");
        Preconditions.checkState(!this.halfCloseCalled, "call already half-closed");
        this.halfCloseCalled = true;
        this.stream.halfClose();
    }

    @Override
    public void sendMessage(ReqT message) {
        Preconditions.checkState(this.stream != null, "Not started");
        Preconditions.checkState(!this.cancelCalled, "call was cancelled");
        Preconditions.checkState(!this.halfCloseCalled, "call was half-closed");
        try {
            InputStream messageIs = this.method.streamRequest(message);
            this.stream.writeMessage(messageIs);
        }
        catch (Throwable e) {
            this.stream.cancel(Status.CANCELLED.withCause(e).withDescription("Failed to stream message"));
            return;
        }
        if (!this.unaryRequest) {
            this.stream.flush();
        }
    }

    @Override
    public void setMessageCompression(boolean enabled) {
        Preconditions.checkState(this.stream != null, "Not started");
        this.stream.setMessageCompression(enabled);
    }

    @Override
    public boolean isReady() {
        return this.stream.isReady();
    }

    @Override
    public Attributes getAttributes() {
        if (this.stream != null) {
            return this.stream.getAttributes();
        }
        return Attributes.EMPTY;
    }

    private void closeObserver(ClientCall.Listener<RespT> observer, Status status, Metadata trailers) {
        observer.onClose(status, trailers);
    }

    private class ClientStreamListenerImpl
    implements ClientStreamListener {
        private final ClientCall.Listener<RespT> observer;
        private boolean closed;

        public ClientStreamListenerImpl(ClientCall.Listener<RespT> observer) {
            this.observer = Preconditions.checkNotNull(observer, "observer");
        }

        @Override
        public void headersRead(final Metadata headers) {
            Decompressor decompressor = Codec.Identity.NONE;
            if (headers.containsKey(GrpcUtil.MESSAGE_ENCODING_KEY)) {
                String encoding = headers.get(GrpcUtil.MESSAGE_ENCODING_KEY);
                decompressor = ClientCallImpl.this.decompressorRegistry.lookupDecompressor(encoding);
                if (decompressor == null) {
                    ClientCallImpl.this.stream.cancel(Status.INTERNAL.withDescription(String.format("Can't find decompressor for %s", encoding)));
                    return;
                }
            }
            ClientCallImpl.this.stream.setDecompressor(decompressor);
            class HeadersRead
            extends ContextRunnable {
                HeadersRead() {
                    super(ClientCallImpl.this.context);
                }

                @Override
                public final void runInContext() {
                    try {
                        if (ClientStreamListenerImpl.this.closed) {
                            return;
                        }
                        ClientStreamListenerImpl.this.observer.onHeaders(headers);
                    }
                    catch (Throwable t) {
                        Status status = Status.CANCELLED.withCause(t).withDescription("Failed to read headers");
                        ClientCallImpl.this.stream.cancel(status);
                        ClientStreamListenerImpl.this.close(status, new Metadata());
                    }
                }
            }
            ClientCallImpl.this.callExecutor.execute(new HeadersRead());
        }

        @Override
        public void messageRead(final InputStream message) {
            class MessageRead
            extends ContextRunnable {
                MessageRead() {
                    super(ClientCallImpl.this.context);
                }

                @Override
                public final void runInContext() {
                    try {
                        if (ClientStreamListenerImpl.this.closed) {
                            return;
                        }
                        try {
                            ClientStreamListenerImpl.this.observer.onMessage(ClientCallImpl.this.method.parseResponse(message));
                        }
                        finally {
                            message.close();
                        }
                    }
                    catch (Throwable t) {
                        Status status = Status.CANCELLED.withCause(t).withDescription("Failed to read message.");
                        ClientCallImpl.this.stream.cancel(status);
                        ClientStreamListenerImpl.this.close(status, new Metadata());
                    }
                }
            }
            ClientCallImpl.this.callExecutor.execute(new MessageRead());
        }

        private void close(Status status, Metadata trailers) {
            this.closed = true;
            ClientCallImpl.this.cancelListenersShouldBeRemoved = true;
            try {
                ClientCallImpl.this.closeObserver(this.observer, status, trailers);
            }
            finally {
                ClientCallImpl.this.removeContextListenerAndCancelDeadlineFuture();
            }
        }

        @Override
        public void closed(Status status, Metadata trailers) {
            Deadline deadline = ClientCallImpl.this.effectiveDeadline();
            if (status.getCode() == Status.Code.CANCELLED && deadline != null && deadline.isExpired()) {
                status = Status.DEADLINE_EXCEEDED;
                trailers = new Metadata();
            }
            final Status savedStatus = status;
            final Metadata savedTrailers = trailers;
            class StreamClosed
            extends ContextRunnable {
                StreamClosed() {
                    super(ClientCallImpl.this.context);
                }

                @Override
                public final void runInContext() {
                    if (ClientStreamListenerImpl.this.closed) {
                        return;
                    }
                    ClientStreamListenerImpl.this.close(savedStatus, savedTrailers);
                }
            }
            ClientCallImpl.this.callExecutor.execute(new StreamClosed());
        }

        @Override
        public void onReady() {
            class StreamOnReady
            extends ContextRunnable {
                StreamOnReady() {
                    super(ClientCallImpl.this.context);
                }

                @Override
                public final void runInContext() {
                    try {
                        ClientStreamListenerImpl.this.observer.onReady();
                    }
                    catch (Throwable t) {
                        Status status = Status.CANCELLED.withCause(t).withDescription("Failed to call onReady.");
                        ClientCallImpl.this.stream.cancel(status);
                        ClientStreamListenerImpl.this.close(status, new Metadata());
                    }
                }
            }
            ClientCallImpl.this.callExecutor.execute(new StreamOnReady());
        }
    }

    private class DeadlineTimer
    implements Runnable {
        private DeadlineTimer() {
        }

        @Override
        public void run() {
            ClientCallImpl.this.stream.cancel(Status.DEADLINE_EXCEEDED);
        }
    }

    static interface ClientTransportProvider {
        public ClientTransport get(LoadBalancer.PickSubchannelArgs var1);
    }
}

