/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc.internal;

import com.google.bigtable.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.io.grpc.Attributes;
import com.google.bigtable.repackaged.io.grpc.NameResolver;
import com.google.bigtable.repackaged.io.grpc.internal.SharedResourceHolder;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

class DnsNameResolver
extends NameResolver {
    private final String authority;
    private final String host;
    private final int port;
    private final SharedResourceHolder.Resource<ScheduledExecutorService> timerServiceResource;
    private final SharedResourceHolder.Resource<ExecutorService> executorResource;
    @GuardedBy(value="this")
    private boolean shutdown;
    @GuardedBy(value="this")
    private ScheduledExecutorService timerService;
    @GuardedBy(value="this")
    private ExecutorService executor;
    @GuardedBy(value="this")
    private ScheduledFuture<?> resolutionTask;
    @GuardedBy(value="this")
    private boolean resolving;
    @GuardedBy(value="this")
    private NameResolver.Listener listener;
    private final Runnable resolutionRunnable = new Runnable(){

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    };
    private final Runnable resolutionRunnableOnExecutor = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            DnsNameResolver dnsNameResolver = DnsNameResolver.this;
            synchronized (dnsNameResolver) {
                if (!DnsNameResolver.this.shutdown) {
                    DnsNameResolver.this.executor.execute(DnsNameResolver.this.resolutionRunnable);
                }
            }
        }
    };

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    DnsNameResolver(@Nullable String nsAuthority, String name, Attributes params, SharedResourceHolder.Resource<ScheduledExecutorService> timerServiceResource, SharedResourceHolder.Resource<ExecutorService> executorResource) {
        this.timerServiceResource = timerServiceResource;
        this.executorResource = executorResource;
        URI nameUri = URI.create("//" + name);
        this.authority = Preconditions.checkNotNull(nameUri.getAuthority(), "nameUri (%s) doesn't have an authority", nameUri);
        this.host = Preconditions.checkNotNull(nameUri.getHost(), "host");
        if (nameUri.getPort() == -1) {
            Integer defaultPort = params.get(NameResolver.Factory.PARAMS_DEFAULT_PORT);
            if (defaultPort == null) throw new IllegalArgumentException("name '" + name + "' doesn't contain a port, and default port is not set in params");
            this.port = defaultPort;
            return;
        } else {
            this.port = nameUri.getPort();
        }
    }

    @Override
    public final String getServiceAuthority() {
        return this.authority;
    }

    @Override
    public final synchronized void start(NameResolver.Listener listener) {
        Preconditions.checkState(this.listener == null, "already started");
        this.timerService = SharedResourceHolder.get(this.timerServiceResource);
        this.executor = SharedResourceHolder.get(this.executorResource);
        this.listener = Preconditions.checkNotNull(listener, "listener");
        this.resolve();
    }

    @Override
    public final synchronized void refresh() {
        Preconditions.checkState(this.listener != null, "not started");
        this.resolve();
    }

    @VisibleForTesting
    InetAddress[] getAllByName(String host) throws UnknownHostException {
        return InetAddress.getAllByName(host);
    }

    @GuardedBy(value="this")
    private void resolve() {
        if (this.resolving || this.shutdown) {
            return;
        }
        this.executor.execute(this.resolutionRunnable);
    }

    @Override
    public final synchronized void shutdown() {
        if (this.shutdown) {
            return;
        }
        this.shutdown = true;
        if (this.resolutionTask != null) {
            this.resolutionTask.cancel(false);
        }
        if (this.timerService != null) {
            this.timerService = SharedResourceHolder.release(this.timerServiceResource, this.timerService);
        }
        if (this.executor != null) {
            this.executor = SharedResourceHolder.release(this.executorResource, this.executor);
        }
    }

    final int getPort() {
        return this.port;
    }

    static /* synthetic */ ScheduledFuture access$000(DnsNameResolver x0) {
        return x0.resolutionTask;
    }

    static /* synthetic */ ScheduledFuture access$002(DnsNameResolver x0, ScheduledFuture x1) {
        x0.resolutionTask = x1;
        return x0.resolutionTask;
    }

    static /* synthetic */ NameResolver.Listener access$200(DnsNameResolver x0) {
        return x0.listener;
    }

    static /* synthetic */ boolean access$302(DnsNameResolver x0, boolean x1) {
        x0.resolving = x1;
        return x0.resolving;
    }

    static /* synthetic */ String access$400(DnsNameResolver x0) {
        return x0.host;
    }

    static /* synthetic */ int access$500(DnsNameResolver x0) {
        return x0.port;
    }

    static /* synthetic */ Runnable access$600(DnsNameResolver x0) {
        return x0.resolutionRunnableOnExecutor;
    }

    static /* synthetic */ ScheduledExecutorService access$700(DnsNameResolver x0) {
        return x0.timerService;
    }
}

