/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc.netty;

import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.common.io.BaseEncoding;
import com.google.bigtable.repackaged.io.grpc.Attributes;
import com.google.bigtable.repackaged.io.grpc.InternalKnownTransport;
import com.google.bigtable.repackaged.io.grpc.InternalMethodDescriptor;
import com.google.bigtable.repackaged.io.grpc.Metadata;
import com.google.bigtable.repackaged.io.grpc.MethodDescriptor;
import com.google.bigtable.repackaged.io.grpc.Status;
import com.google.bigtable.repackaged.io.grpc.internal.AbstractClientStream2;
import com.google.bigtable.repackaged.io.grpc.internal.GrpcUtil;
import com.google.bigtable.repackaged.io.grpc.internal.Http2ClientStreamTransportState;
import com.google.bigtable.repackaged.io.grpc.internal.StatsTraceContext;
import com.google.bigtable.repackaged.io.grpc.internal.WritableBuffer;
import com.google.bigtable.repackaged.io.grpc.netty.CancelClientStreamCommand;
import com.google.bigtable.repackaged.io.grpc.netty.CreateStreamCommand;
import com.google.bigtable.repackaged.io.grpc.netty.NettyClientHandler;
import com.google.bigtable.repackaged.io.grpc.netty.NettyReadableBuffer;
import com.google.bigtable.repackaged.io.grpc.netty.NettyWritableBuffer;
import com.google.bigtable.repackaged.io.grpc.netty.NettyWritableBufferAllocator;
import com.google.bigtable.repackaged.io.grpc.netty.SendGrpcFrameCommand;
import com.google.bigtable.repackaged.io.grpc.netty.StreamIdHolder;
import com.google.bigtable.repackaged.io.grpc.netty.Utils;
import com.google.bigtable.repackaged.io.grpc.netty.WriteQueue;
import com.google.bigtable.repackaged.io.netty.buffer.ByteBuf;
import com.google.bigtable.repackaged.io.netty.buffer.Unpooled;
import com.google.bigtable.repackaged.io.netty.channel.Channel;
import com.google.bigtable.repackaged.io.netty.channel.ChannelFuture;
import com.google.bigtable.repackaged.io.netty.channel.ChannelFutureListener;
import com.google.bigtable.repackaged.io.netty.handler.codec.http2.Http2Headers;
import com.google.bigtable.repackaged.io.netty.handler.codec.http2.Http2Stream;
import com.google.bigtable.repackaged.io.netty.util.AsciiString;
import javax.annotation.Nullable;

class NettyClientStream
extends AbstractClientStream2 {
    private static final InternalMethodDescriptor methodDescriptorAccessor = new InternalMethodDescriptor(InternalKnownTransport.NETTY);
    private final Sink sink = new Sink();
    private final TransportState state;
    private final WriteQueue writeQueue;
    private final MethodDescriptor<?, ?> method;
    private final Channel channel;
    private AsciiString authority;
    private final AsciiString scheme;
    private final AsciiString userAgent;

    NettyClientStream(TransportState state, MethodDescriptor<?, ?> method, Metadata headers, Channel channel, AsciiString authority, AsciiString scheme, AsciiString userAgent, StatsTraceContext statsTraceCtx) {
        super(new NettyWritableBufferAllocator(channel.alloc()), statsTraceCtx, headers, NettyClientStream.useGet(method));
        this.state = Preconditions.checkNotNull(state, "transportState");
        this.writeQueue = state.handler.getWriteQueue();
        this.method = Preconditions.checkNotNull(method, "method");
        this.channel = Preconditions.checkNotNull(channel, "channel");
        this.authority = Preconditions.checkNotNull(authority, "authority");
        this.scheme = Preconditions.checkNotNull(scheme, "scheme");
        this.userAgent = userAgent;
    }

    @Override
    protected TransportState transportState() {
        return this.state;
    }

    @Override
    protected Sink abstractClientStreamSink() {
        return this.sink;
    }

    @Override
    public void setAuthority(String authority) {
        this.authority = AsciiString.of(Preconditions.checkNotNull(authority, "authority"));
    }

    @Override
    public Attributes getAttributes() {
        return this.state.handler.getAttributes();
    }

    private static boolean useGet(MethodDescriptor<?, ?> method) {
        return method.isSafe();
    }

    public static abstract class TransportState
    extends Http2ClientStreamTransportState
    implements StreamIdHolder {
        private final NettyClientHandler handler;
        private int id;
        private Http2Stream http2Stream;

        public TransportState(NettyClientHandler handler, int maxMessageSize, StatsTraceContext statsTraceCtx) {
            super(maxMessageSize, statsTraceCtx);
            this.handler = Preconditions.checkNotNull(handler, "handler");
        }

        @Override
        public int id() {
            return this.id;
        }

        public void setId(int id) {
            Preconditions.checkArgument(id > 0, "id must be positive");
            this.id = id;
        }

        public void setHttp2Stream(Http2Stream http2Stream) {
            Preconditions.checkNotNull(http2Stream, "http2Stream");
            Preconditions.checkState(this.http2Stream == null, "Can only set http2Stream once");
            this.http2Stream = http2Stream;
            this.onStreamAllocated();
        }

        @Nullable
        public Http2Stream http2Stream() {
            return this.http2Stream;
        }

        protected abstract Status statusFromFailedFuture(ChannelFuture var1);

        @Override
        protected void http2ProcessingFailed(Status status, Metadata trailers) {
            this.transportReportStatus(status, false, trailers);
            this.handler.getWriteQueue().enqueue(new CancelClientStreamCommand(this, status), true);
        }

        @Override
        public void bytesRead(int processedBytes) {
            this.handler.returnProcessedBytes(this.http2Stream, processedBytes);
            this.handler.getWriteQueue().scheduleFlush();
        }

        @Override
        protected void deframeFailed(Throwable cause) {
            this.http2ProcessingFailed(Status.fromThrowable(cause), new Metadata());
        }

        void transportHeadersReceived(Http2Headers headers, boolean endOfStream) {
            if (endOfStream) {
                this.transportTrailersReceived(Utils.convertTrailers(headers));
            } else {
                this.transportHeadersReceived(Utils.convertHeaders(headers));
            }
        }

        void transportDataReceived(ByteBuf frame, boolean endOfStream) {
            this.transportDataReceived(new NettyReadableBuffer(frame.retain()), endOfStream);
        }
    }

    private class Sink
    implements AbstractClientStream2.Sink {
        private Sink() {
        }

        @Override
        public void writeHeaders(Metadata headers, byte[] requestPayload) {
            AsciiString httpMethod;
            boolean get;
            AsciiString defaultPath = (AsciiString)methodDescriptorAccessor.geRawMethodName(NettyClientStream.this.method);
            if (defaultPath == null) {
                defaultPath = new AsciiString("/" + NettyClientStream.this.method.getFullMethodName());
                methodDescriptorAccessor.setRawMethodName(NettyClientStream.this.method, defaultPath);
            }
            boolean bl = get = requestPayload != null;
            if (get) {
                defaultPath = new AsciiString(defaultPath + "?" + "grpc-payload-bin" + "=" + BaseEncoding.base64().encode(requestPayload));
                httpMethod = Utils.HTTP_GET_METHOD;
            } else {
                httpMethod = Utils.HTTP_METHOD;
            }
            headers.discardAll(GrpcUtil.USER_AGENT_KEY);
            Http2Headers http2Headers = Utils.convertClientHeaders(headers, NettyClientStream.this.scheme, defaultPath, NettyClientStream.this.authority, httpMethod, NettyClientStream.this.userAgent);
            ChannelFutureListener failureListener = new ChannelFutureListener(){

                @Override
                public void operationComplete(ChannelFuture future) throws Exception {
                    if (!future.isSuccess()) {
                        Status s = NettyClientStream.this.transportState().statusFromFailedFuture(future);
                        NettyClientStream.this.transportState().transportReportStatus(s, true, new Metadata());
                    }
                }
            };
            NettyClientStream.this.writeQueue.enqueue(new CreateStreamCommand(http2Headers, NettyClientStream.this.transportState(), get), !NettyClientStream.this.method.getType().clientSendsOneMessage() || get).addListener(failureListener);
        }

        @Override
        public void writeFrame(WritableBuffer frame, boolean endOfStream, boolean flush) {
            ByteBuf bytebuf = frame == null ? Unpooled.EMPTY_BUFFER : ((NettyWritableBuffer)frame).bytebuf();
            final int numBytes = bytebuf.readableBytes();
            if (numBytes > 0) {
                NettyClientStream.this.onSendingBytes(numBytes);
                NettyClientStream.this.writeQueue.enqueue(new SendGrpcFrameCommand(NettyClientStream.this.transportState(), bytebuf, endOfStream), NettyClientStream.this.channel.newPromise().addListener(new ChannelFutureListener(){

                    @Override
                    public void operationComplete(ChannelFuture future) throws Exception {
                        if (future.isSuccess()) {
                            NettyClientStream.this.transportState().onSentBytes(numBytes);
                        }
                    }
                }), flush);
            } else {
                NettyClientStream.this.writeQueue.enqueue(new SendGrpcFrameCommand(NettyClientStream.this.transportState(), bytebuf, endOfStream), flush);
            }
        }

        @Override
        public void request(final int numMessages) {
            if (NettyClientStream.this.channel.eventLoop().inEventLoop()) {
                NettyClientStream.this.transportState().requestMessagesFromDeframer(numMessages);
            } else {
                NettyClientStream.this.channel.eventLoop().execute(new Runnable(){

                    @Override
                    public void run() {
                        NettyClientStream.this.transportState().requestMessagesFromDeframer(numMessages);
                    }
                });
            }
        }

        @Override
        public void cancel(Status status) {
            NettyClientStream.this.writeQueue.enqueue(new CancelClientStreamCommand(NettyClientStream.this.transportState(), status), true);
        }
    }
}

