/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc.netty;

import com.google.bigtable.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.common.base.Ticker;
import com.google.bigtable.repackaged.io.grpc.Attributes;
import com.google.bigtable.repackaged.io.grpc.CallOptions;
import com.google.bigtable.repackaged.io.grpc.Metadata;
import com.google.bigtable.repackaged.io.grpc.MethodDescriptor;
import com.google.bigtable.repackaged.io.grpc.Status;
import com.google.bigtable.repackaged.io.grpc.internal.ClientStream;
import com.google.bigtable.repackaged.io.grpc.internal.ClientTransport;
import com.google.bigtable.repackaged.io.grpc.internal.ConnectionClientTransport;
import com.google.bigtable.repackaged.io.grpc.internal.FailingClientStream;
import com.google.bigtable.repackaged.io.grpc.internal.GrpcUtil;
import com.google.bigtable.repackaged.io.grpc.internal.Http2Ping;
import com.google.bigtable.repackaged.io.grpc.internal.KeepAliveManager;
import com.google.bigtable.repackaged.io.grpc.internal.LogId;
import com.google.bigtable.repackaged.io.grpc.internal.ManagedClientTransport;
import com.google.bigtable.repackaged.io.grpc.internal.StatsTraceContext;
import com.google.bigtable.repackaged.io.grpc.netty.ClientTransportLifecycleManager;
import com.google.bigtable.repackaged.io.grpc.netty.ForcefulCloseCommand;
import com.google.bigtable.repackaged.io.grpc.netty.GracefulCloseCommand;
import com.google.bigtable.repackaged.io.grpc.netty.HandlerSettings;
import com.google.bigtable.repackaged.io.grpc.netty.NettyClientHandler;
import com.google.bigtable.repackaged.io.grpc.netty.NettyClientStream;
import com.google.bigtable.repackaged.io.grpc.netty.ProtocolNegotiator;
import com.google.bigtable.repackaged.io.grpc.netty.SendPingCommand;
import com.google.bigtable.repackaged.io.grpc.netty.Utils;
import com.google.bigtable.repackaged.io.netty.bootstrap.Bootstrap;
import com.google.bigtable.repackaged.io.netty.channel.Channel;
import com.google.bigtable.repackaged.io.netty.channel.ChannelFuture;
import com.google.bigtable.repackaged.io.netty.channel.ChannelFutureListener;
import com.google.bigtable.repackaged.io.netty.channel.ChannelHandlerContext;
import com.google.bigtable.repackaged.io.netty.channel.ChannelOption;
import com.google.bigtable.repackaged.io.netty.channel.EventLoop;
import com.google.bigtable.repackaged.io.netty.channel.EventLoopGroup;
import com.google.bigtable.repackaged.io.netty.channel.socket.nio.NioSocketChannel;
import com.google.bigtable.repackaged.io.netty.handler.codec.http2.StreamBufferingEncoder;
import com.google.bigtable.repackaged.io.netty.util.AsciiString;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;

class NettyClientTransport
implements ConnectionClientTransport {
    private final LogId logId = LogId.allocate(this.getClass().getName());
    private final Map<ChannelOption<?>, ?> channelOptions;
    private final SocketAddress address;
    private final Class<? extends Channel> channelType;
    private final EventLoopGroup group;
    private final ProtocolNegotiator negotiator;
    private final AsciiString authority;
    private final AsciiString userAgent;
    private final int flowControlWindow;
    private final int maxMessageSize;
    private final int maxHeaderListSize;
    private KeepAliveManager keepAliveManager;
    private final long keepAliveTimeNanos;
    private final long keepAliveTimeoutNanos;
    private final boolean keepAliveWithoutCalls;
    private final Runnable tooManyPingsRunnable;
    private ProtocolNegotiator.Handler negotiationHandler;
    private NettyClientHandler handler;
    private Channel channel;
    private Status statusExplainingWhyTheChannelIsNull;
    private ClientTransportLifecycleManager lifecycleManager;

    NettyClientTransport(SocketAddress address, Class<? extends Channel> channelType, Map<ChannelOption<?>, ?> channelOptions, EventLoopGroup group, ProtocolNegotiator negotiator, int flowControlWindow, int maxMessageSize, int maxHeaderListSize, long keepAliveTimeNanos, long keepAliveTimeoutNanos, boolean keepAliveWithoutCalls, String authority, @Nullable String userAgent, Runnable tooManyPingsRunnable) {
        this.negotiator = Preconditions.checkNotNull(negotiator, "negotiator");
        this.address = Preconditions.checkNotNull(address, "address");
        this.group = Preconditions.checkNotNull(group, "group");
        this.channelType = Preconditions.checkNotNull(channelType, "channelType");
        this.channelOptions = Preconditions.checkNotNull(channelOptions, "channelOptions");
        this.flowControlWindow = flowControlWindow;
        this.maxMessageSize = maxMessageSize;
        this.maxHeaderListSize = maxHeaderListSize;
        this.keepAliveTimeNanos = keepAliveTimeNanos;
        this.keepAliveTimeoutNanos = keepAliveTimeoutNanos;
        this.keepAliveWithoutCalls = keepAliveWithoutCalls;
        this.authority = new AsciiString(authority);
        this.userAgent = new AsciiString(GrpcUtil.getGrpcUserAgent("netty", userAgent));
        this.tooManyPingsRunnable = Preconditions.checkNotNull(tooManyPingsRunnable, "tooManyPingsRunnable");
    }

    @Override
    public void ping(final ClientTransport.PingCallback callback, final Executor executor) {
        if (this.channel == null) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    callback.onFailure(NettyClientTransport.this.statusExplainingWhyTheChannelIsNull.asException());
                }
            });
            return;
        }
        ChannelFutureListener failureListener = new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) throws Exception {
                if (!future.isSuccess()) {
                    Status s = NettyClientTransport.this.statusFromFailedFuture(future);
                    Http2Ping.notifyFailed(callback, executor, s.asException());
                }
            }
        };
        this.handler.getWriteQueue().enqueue(new SendPingCommand(callback, executor), true).addListener(failureListener);
    }

    @Override
    public ClientStream newStream(MethodDescriptor<?, ?> method, Metadata headers, CallOptions callOptions) {
        Preconditions.checkNotNull(method, "method");
        Preconditions.checkNotNull(headers, "headers");
        if (this.channel == null) {
            return new FailingClientStream(this.statusExplainingWhyTheChannelIsNull);
        }
        StatsTraceContext statsTraceCtx = StatsTraceContext.newClientContext(callOptions, headers);
        return new NettyClientStream(new NettyClientStream.TransportState(this.handler, this.maxMessageSize, statsTraceCtx){

            @Override
            protected Status statusFromFailedFuture(ChannelFuture f) {
                return NettyClientTransport.this.statusFromFailedFuture(f);
            }
        }, method, headers, this.channel, this.authority, this.negotiationHandler.scheme(), this.userAgent, statsTraceCtx);
    }

    @Override
    public ClientStream newStream(MethodDescriptor<?, ?> method, Metadata headers) {
        return this.newStream(method, headers, CallOptions.DEFAULT);
    }

    @Override
    public Runnable start(ManagedClientTransport.Listener transportListener) {
        this.lifecycleManager = new ClientTransportLifecycleManager(Preconditions.checkNotNull(transportListener, "listener"));
        EventLoop eventLoop = this.group.next();
        if (this.keepAliveTimeNanos != Long.MAX_VALUE) {
            this.keepAliveManager = new KeepAliveManager(new KeepAliveManager.ClientKeepAlivePinger(this), eventLoop, this.keepAliveTimeNanos, this.keepAliveTimeoutNanos, this.keepAliveWithoutCalls);
        }
        this.handler = NettyClientHandler.newHandler(this.lifecycleManager, this.keepAliveManager, this.flowControlWindow, this.maxHeaderListSize, Ticker.systemTicker(), this.tooManyPingsRunnable);
        HandlerSettings.setAutoWindow(this.handler);
        this.negotiationHandler = this.negotiator.newHandler(this.handler);
        Bootstrap b = new Bootstrap();
        b.group(eventLoop);
        b.channel(this.channelType);
        if (NioSocketChannel.class.isAssignableFrom(this.channelType)) {
            b.option(ChannelOption.SO_KEEPALIVE, true);
        }
        for (Map.Entry<ChannelOption<?>, ?> entry : this.channelOptions.entrySet()) {
            b.option(entry.getKey(), entry.getValue());
        }
        b.handler(this.negotiationHandler);
        ChannelFuture regFuture = b.register();
        this.channel = regFuture.channel();
        if (this.channel == null) {
            Throwable t = regFuture.cause();
            if (t == null) {
                t = new IllegalStateException("Channel is null, but future doesn't have a cause");
            }
            this.statusExplainingWhyTheChannelIsNull = Utils.statusFromThrowable(t);
            return new Runnable(){

                @Override
                public void run() {
                    NettyClientTransport.this.lifecycleManager.notifyTerminated(NettyClientTransport.this.statusExplainingWhyTheChannelIsNull);
                }
            };
        }
        this.handler.startWriteQueue(this.channel);
        this.channel.connect(this.address).addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) throws Exception {
                if (!future.isSuccess()) {
                    ChannelHandlerContext ctx = future.channel().pipeline().context(NettyClientTransport.this.handler);
                    if (ctx != null) {
                        ctx.fireExceptionCaught(future.cause());
                    }
                    future.channel().pipeline().fireExceptionCaught(future.cause());
                }
            }
        });
        this.channel.write(NettyClientHandler.NOOP_MESSAGE).addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) throws Exception {
                if (!future.isSuccess()) {
                    NettyClientTransport.this.lifecycleManager.notifyTerminated(Utils.statusFromThrowable(future.cause()));
                }
            }
        });
        this.channel.closeFuture().addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) throws Exception {
                NettyClientTransport.this.lifecycleManager.notifyTerminated(Status.INTERNAL.withDescription("Connection closed with unknown cause"));
            }
        });
        if (this.keepAliveManager != null) {
            this.keepAliveManager.onTransportStarted();
        }
        return null;
    }

    @Override
    public void shutdown() {
        if (this.channel == null) {
            return;
        }
        if (this.channel.isOpen()) {
            Status status = Status.UNAVAILABLE.withDescription("Channel requested transport to shut down");
            this.handler.getWriteQueue().enqueue(new GracefulCloseCommand(status), true);
        }
    }

    @Override
    public void shutdownNow(Status reason) {
        if (this.channel != null && this.channel.isOpen()) {
            this.handler.getWriteQueue().enqueue(new ForcefulCloseCommand(reason), true);
        }
    }

    public String toString() {
        return this.getLogId() + "(" + this.address + ")";
    }

    @Override
    public LogId getLogId() {
        return this.logId;
    }

    @Override
    public Attributes getAttributes() {
        return Attributes.EMPTY;
    }

    @VisibleForTesting
    Channel channel() {
        return this.channel;
    }

    @VisibleForTesting
    KeepAliveManager keepAliveManager() {
        return this.keepAliveManager;
    }

    private Status statusFromFailedFuture(ChannelFuture f) {
        Throwable t = f.cause();
        if (t instanceof ClosedChannelException || t instanceof StreamBufferingEncoder.Http2ChannelClosedException) {
            Status shutdownStatus = this.lifecycleManager.getShutdownStatus();
            if (shutdownStatus == null) {
                return Status.UNKNOWN.withDescription("Channel closed but for unknown reason");
            }
            return shutdownStatus;
        }
        return Utils.statusFromThrowable(t);
    }
}

