/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc.netty;

import com.google.bigtable.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.io.grpc.Attributes;
import com.google.bigtable.repackaged.io.grpc.Metadata;
import com.google.bigtable.repackaged.io.grpc.ServerStreamTracer;
import com.google.bigtable.repackaged.io.grpc.Status;
import com.google.bigtable.repackaged.io.grpc.internal.GrpcUtil;
import com.google.bigtable.repackaged.io.grpc.internal.KeepAliveManager;
import com.google.bigtable.repackaged.io.grpc.internal.LogExceptionRunnable;
import com.google.bigtable.repackaged.io.grpc.internal.ServerTransportListener;
import com.google.bigtable.repackaged.io.grpc.internal.StatsTraceContext;
import com.google.bigtable.repackaged.io.grpc.netty.AbstractNettyHandler;
import com.google.bigtable.repackaged.io.grpc.netty.CancelServerStreamCommand;
import com.google.bigtable.repackaged.io.grpc.netty.FixedHttp2ConnectionDecoder;
import com.google.bigtable.repackaged.io.grpc.netty.ForcefulCloseCommand;
import com.google.bigtable.repackaged.io.grpc.netty.GrpcHttp2HeadersDecoder;
import com.google.bigtable.repackaged.io.grpc.netty.KeepAliveEnforcer;
import com.google.bigtable.repackaged.io.grpc.netty.NettyServerStream;
import com.google.bigtable.repackaged.io.grpc.netty.SendGrpcFrameCommand;
import com.google.bigtable.repackaged.io.grpc.netty.SendResponseHeadersCommand;
import com.google.bigtable.repackaged.io.grpc.netty.Utils;
import com.google.bigtable.repackaged.io.grpc.netty.WriteQueue;
import com.google.bigtable.repackaged.io.netty.buffer.ByteBuf;
import com.google.bigtable.repackaged.io.netty.buffer.ByteBufUtil;
import com.google.bigtable.repackaged.io.netty.buffer.Unpooled;
import com.google.bigtable.repackaged.io.netty.channel.ChannelFuture;
import com.google.bigtable.repackaged.io.netty.channel.ChannelFutureListener;
import com.google.bigtable.repackaged.io.netty.channel.ChannelHandlerContext;
import com.google.bigtable.repackaged.io.netty.channel.ChannelPromise;
import com.google.bigtable.repackaged.io.netty.handler.codec.http2.DecoratingHttp2FrameWriter;
import com.google.bigtable.repackaged.io.netty.handler.codec.http2.DefaultHttp2Connection;
import com.google.bigtable.repackaged.io.netty.handler.codec.http2.DefaultHttp2ConnectionEncoder;
import com.google.bigtable.repackaged.io.netty.handler.codec.http2.DefaultHttp2FrameReader;
import com.google.bigtable.repackaged.io.netty.handler.codec.http2.DefaultHttp2FrameWriter;
import com.google.bigtable.repackaged.io.netty.handler.codec.http2.DefaultHttp2LocalFlowController;
import com.google.bigtable.repackaged.io.netty.handler.codec.http2.Http2Connection;
import com.google.bigtable.repackaged.io.netty.handler.codec.http2.Http2ConnectionAdapter;
import com.google.bigtable.repackaged.io.netty.handler.codec.http2.Http2ConnectionDecoder;
import com.google.bigtable.repackaged.io.netty.handler.codec.http2.Http2ConnectionEncoder;
import com.google.bigtable.repackaged.io.netty.handler.codec.http2.Http2Error;
import com.google.bigtable.repackaged.io.netty.handler.codec.http2.Http2Exception;
import com.google.bigtable.repackaged.io.netty.handler.codec.http2.Http2FrameAdapter;
import com.google.bigtable.repackaged.io.netty.handler.codec.http2.Http2FrameLogger;
import com.google.bigtable.repackaged.io.netty.handler.codec.http2.Http2FrameReader;
import com.google.bigtable.repackaged.io.netty.handler.codec.http2.Http2FrameWriter;
import com.google.bigtable.repackaged.io.netty.handler.codec.http2.Http2Headers;
import com.google.bigtable.repackaged.io.netty.handler.codec.http2.Http2InboundFrameLogger;
import com.google.bigtable.repackaged.io.netty.handler.codec.http2.Http2OutboundFrameLogger;
import com.google.bigtable.repackaged.io.netty.handler.codec.http2.Http2Settings;
import com.google.bigtable.repackaged.io.netty.handler.codec.http2.Http2Stream;
import com.google.bigtable.repackaged.io.netty.handler.codec.http2.Http2StreamVisitor;
import com.google.bigtable.repackaged.io.netty.handler.logging.LogLevel;
import com.google.bigtable.repackaged.io.netty.util.AsciiString;
import com.google.bigtable.repackaged.io.netty.util.ReferenceCountUtil;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

class NettyServerHandler
extends AbstractNettyHandler {
    private static final Logger logger = Logger.getLogger(NettyServerHandler.class.getName());
    private static final ByteBuf KEEPALIVE_PING_BUF = Unpooled.unreleasableBuffer(Unpooled.directBuffer(8).writeLong(57005L));
    private final Http2Connection.PropertyKey streamKey;
    private final ServerTransportListener transportListener;
    private final int maxMessageSize;
    private final long keepAliveTimeInNanos;
    private final long keepAliveTimeoutInNanos;
    private final long maxConnectionAgeInNanos;
    private final long maxConnectionAgeGraceInNanos;
    private final List<ServerStreamTracer.Factory> streamTracerFactories;
    private final KeepAliveEnforcer keepAliveEnforcer;
    private Attributes attributes;
    private Throwable connectionError;
    private boolean teWarningLogged;
    private WriteQueue serverWriteQueue;
    private AsciiString lastKnownAuthority;
    private KeepAliveManager keepAliveManager;
    private ScheduledFuture<?> maxConnectionAgeMonitor;

    static NettyServerHandler newHandler(ServerTransportListener transportListener, List<ServerStreamTracer.Factory> streamTracerFactories, int maxStreams, int flowControlWindow, int maxHeaderListSize, int maxMessageSize, long keepAliveTimeInNanos, long keepAliveTimeoutInNanos, long maxConnectionAgeInNanos, long maxConnectionAgeGraceInNanos, boolean permitKeepAliveWithoutCalls, long permitKeepAliveTimeInNanos) {
        Preconditions.checkArgument(maxHeaderListSize > 0, "maxHeaderListSize must be positive");
        Http2FrameLogger frameLogger = new Http2FrameLogger(LogLevel.DEBUG, NettyServerHandler.class);
        GrpcHttp2HeadersDecoder.GrpcHttp2ServerHeadersDecoder headersDecoder = new GrpcHttp2HeadersDecoder.GrpcHttp2ServerHeadersDecoder(maxHeaderListSize);
        Http2InboundFrameLogger frameReader = new Http2InboundFrameLogger(new DefaultHttp2FrameReader(headersDecoder), frameLogger);
        Http2OutboundFrameLogger frameWriter = new Http2OutboundFrameLogger(new DefaultHttp2FrameWriter(), frameLogger);
        return NettyServerHandler.newHandler(frameReader, frameWriter, transportListener, streamTracerFactories, maxStreams, flowControlWindow, maxHeaderListSize, maxMessageSize, keepAliveTimeInNanos, keepAliveTimeoutInNanos, maxConnectionAgeInNanos, maxConnectionAgeGraceInNanos, permitKeepAliveWithoutCalls, permitKeepAliveTimeInNanos);
    }

    @VisibleForTesting
    static NettyServerHandler newHandler(Http2FrameReader frameReader, Http2FrameWriter frameWriter, ServerTransportListener transportListener, List<ServerStreamTracer.Factory> streamTracerFactories, int maxStreams, int flowControlWindow, int maxHeaderListSize, int maxMessageSize, long keepAliveTimeInNanos, long keepAliveTimeoutInNanos, long maxConnectionAgeInNanos, long maxConnectionAgeGraceInNanos, boolean permitKeepAliveWithoutCalls, long permitKeepAliveTimeInNanos) {
        Preconditions.checkArgument(maxStreams > 0, "maxStreams must be positive");
        Preconditions.checkArgument(flowControlWindow > 0, "flowControlWindow must be positive");
        Preconditions.checkArgument(maxHeaderListSize > 0, "maxHeaderListSize must be positive");
        Preconditions.checkArgument(maxMessageSize > 0, "maxMessageSize must be positive");
        final DefaultHttp2Connection connection = new DefaultHttp2Connection(true);
        final KeepAliveEnforcer keepAliveEnforcer = new KeepAliveEnforcer(permitKeepAliveWithoutCalls, permitKeepAliveTimeInNanos, TimeUnit.NANOSECONDS);
        connection.addListener(new Http2ConnectionAdapter(){

            @Override
            public void onStreamActive(Http2Stream stream) {
                if (connection.numActiveStreams() == 1) {
                    keepAliveEnforcer.onTransportActive();
                }
            }

            @Override
            public void onStreamClosed(Http2Stream stream) {
                if (connection.numActiveStreams() == 0) {
                    keepAliveEnforcer.onTransportIdle();
                }
            }
        });
        connection.local().flowController(new DefaultHttp2LocalFlowController(connection, 0.5f, true));
        frameWriter = new WriteMonitoringFrameWriter(frameWriter, keepAliveEnforcer);
        DefaultHttp2ConnectionEncoder encoder = new DefaultHttp2ConnectionEncoder(connection, frameWriter);
        FixedHttp2ConnectionDecoder decoder = new FixedHttp2ConnectionDecoder(connection, encoder, frameReader);
        Http2Settings settings = new Http2Settings();
        settings.initialWindowSize(flowControlWindow);
        settings.maxConcurrentStreams(maxStreams);
        settings.maxHeaderListSize(maxHeaderListSize);
        return new NettyServerHandler(transportListener, streamTracerFactories, decoder, encoder, settings, maxMessageSize, keepAliveTimeInNanos, keepAliveTimeoutInNanos, maxConnectionAgeInNanos, maxConnectionAgeGraceInNanos, keepAliveEnforcer);
    }

    private NettyServerHandler(ServerTransportListener transportListener, List<ServerStreamTracer.Factory> streamTracerFactories, Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder, Http2Settings settings, int maxMessageSize, long keepAliveTimeInNanos, long keepAliveTimeoutInNanos, long maxConnectionAgeInNanos, long maxConnectionAgeGraceInNanos, KeepAliveEnforcer keepAliveEnforcer) {
        super(decoder, encoder, settings);
        Preconditions.checkArgument(maxMessageSize >= 0, "maxMessageSize must be >= 0");
        this.maxMessageSize = maxMessageSize;
        this.keepAliveTimeInNanos = keepAliveTimeInNanos;
        this.keepAliveTimeoutInNanos = keepAliveTimeoutInNanos;
        this.maxConnectionAgeInNanos = maxConnectionAgeInNanos;
        this.maxConnectionAgeGraceInNanos = maxConnectionAgeGraceInNanos;
        this.keepAliveEnforcer = Preconditions.checkNotNull(keepAliveEnforcer, "keepAliveEnforcer");
        this.streamKey = encoder.connection().newKey();
        this.transportListener = Preconditions.checkNotNull(transportListener, "transportListener");
        this.streamTracerFactories = Preconditions.checkNotNull(streamTracerFactories, "streamTracerFactories");
        this.decoder().frameListener(new FrameListener());
    }

    @Nullable
    Throwable connectionError() {
        return this.connectionError;
    }

    @Override
    public void handlerAdded(final ChannelHandlerContext ctx) throws Exception {
        this.serverWriteQueue = new WriteQueue(ctx.channel());
        if (this.maxConnectionAgeInNanos != Long.MAX_VALUE) {
            this.maxConnectionAgeMonitor = ctx.executor().schedule(new LogExceptionRunnable(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    ByteBuf debugData = ByteBufUtil.writeAscii(ctx.alloc(), (CharSequence)"max_age");
                    NettyServerHandler.this.goAway(ctx, Integer.MAX_VALUE, Http2Error.NO_ERROR.code(), debugData, ctx.newPromise());
                    long savedGracefulShutdownTime = NettyServerHandler.this.gracefulShutdownTimeoutMillis();
                    try {
                        NettyServerHandler.this.gracefulShutdownTimeoutMillis(TimeUnit.NANOSECONDS.toMillis(NettyServerHandler.this.maxConnectionAgeGraceInNanos));
                        NettyServerHandler.this.close(ctx, ctx.newPromise());
                    }
                    catch (Exception e) {
                        NettyServerHandler.this.onError(ctx, e);
                    }
                    finally {
                        NettyServerHandler.this.gracefulShutdownTimeoutMillis(savedGracefulShutdownTime);
                    }
                }
            }), this.maxConnectionAgeInNanos, TimeUnit.NANOSECONDS);
        }
        if (this.keepAliveTimeInNanos != Long.MAX_VALUE) {
            this.keepAliveManager = new KeepAliveManager(new KeepAlivePinger(ctx), ctx.executor(), this.keepAliveTimeInNanos, this.keepAliveTimeoutInNanos, true);
        }
        super.handlerAdded(ctx);
    }

    private void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers) throws Http2Exception {
        if (!this.teWarningLogged && !Utils.TE_TRAILERS.equals(headers.get(Utils.TE_HEADER))) {
            logger.warning(String.format("Expected header TE: %s, but %s is received. This means some intermediate proxy may not support trailers", Utils.TE_TRAILERS, headers.get(Utils.TE_HEADER)));
            this.teWarningLogged = true;
        }
        try {
            this.verifyContentType(streamId, headers);
            String method = this.determineMethod(streamId, headers);
            Http2Stream http2Stream = this.requireHttp2Stream(streamId);
            Metadata metadata = Utils.convertHeaders(headers);
            StatsTraceContext statsTraceCtx = StatsTraceContext.newServerContext(this.streamTracerFactories, method, metadata);
            NettyServerStream.TransportState state = new NettyServerStream.TransportState(this, http2Stream, this.maxMessageSize, statsTraceCtx);
            String authority = this.getOrUpdateAuthority((AsciiString)headers.authority());
            NettyServerStream stream = new NettyServerStream(ctx.channel(), state, this.attributes, authority, statsTraceCtx);
            this.transportListener.streamCreated(stream, method, metadata);
            state.onStreamAllocated();
            http2Stream.setProperty(this.streamKey, state);
        }
        catch (Http2Exception e) {
            throw e;
        }
        catch (Throwable e) {
            logger.log(Level.WARNING, "Exception in onHeadersRead()", e);
            throw this.newStreamException(streamId, e);
        }
    }

    private String getOrUpdateAuthority(AsciiString authority) {
        if (authority == null) {
            return null;
        }
        if (!authority.equals(this.lastKnownAuthority)) {
            this.lastKnownAuthority = authority;
        }
        return this.lastKnownAuthority.toString();
    }

    private void onDataRead(int streamId, ByteBuf data, int padding, boolean endOfStream) throws Http2Exception {
        this.flowControlPing().onDataRead(data.readableBytes(), padding);
        try {
            NettyServerStream.TransportState stream = this.serverStream(this.requireHttp2Stream(streamId));
            stream.inboundDataReceived(data, endOfStream);
        }
        catch (Throwable e) {
            logger.log(Level.WARNING, "Exception in onDataRead()", e);
            throw this.newStreamException(streamId, e);
        }
    }

    private void onRstStreamRead(int streamId) throws Http2Exception {
        try {
            NettyServerStream.TransportState stream = this.serverStream(this.connection().stream(streamId));
            if (stream != null) {
                stream.transportReportStatus(Status.CANCELLED);
            }
        }
        catch (Throwable e) {
            logger.log(Level.WARNING, "Exception in onRstStreamRead()", e);
            throw this.newStreamException(streamId, e);
        }
    }

    @Override
    protected void onConnectionError(ChannelHandlerContext ctx, Throwable cause, Http2Exception http2Ex) {
        logger.log(Level.WARNING, "Connection Error", cause);
        this.connectionError = cause;
        super.onConnectionError(ctx, cause, http2Ex);
    }

    @Override
    protected void onStreamError(ChannelHandlerContext ctx, Throwable cause, Http2Exception.StreamException http2Ex) {
        logger.log(Level.WARNING, "Stream Error", cause);
        NettyServerStream.TransportState serverStream = this.serverStream(this.connection().stream(Http2Exception.streamId(http2Ex)));
        if (serverStream != null) {
            serverStream.transportReportStatus(Utils.statusFromThrowable(cause));
        }
        super.onStreamError(ctx, cause, http2Ex);
    }

    @Override
    public void handleProtocolNegotiationCompleted(Attributes attrs) {
        this.attributes = this.transportListener.transportReady(attrs);
        if (this.keepAliveManager != null) {
            this.keepAliveManager.onTransportStarted();
        }
    }

    @VisibleForTesting
    KeepAliveManager getKeepAliveManagerForTest() {
        return this.keepAliveManager;
    }

    @VisibleForTesting
    void setKeepAliveManagerForTest(KeepAliveManager keepAliveManager) {
        this.keepAliveManager = keepAliveManager;
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        try {
            if (this.keepAliveManager != null) {
                this.keepAliveManager.onTransportTermination();
            }
            if (this.maxConnectionAgeMonitor != null) {
                this.maxConnectionAgeMonitor.cancel(false);
            }
            final Status status = Status.UNAVAILABLE.withDescription("connection terminated for unknown reason");
            this.connection().forEachActiveStream(new Http2StreamVisitor(){

                @Override
                public boolean visit(Http2Stream stream) throws Http2Exception {
                    NettyServerStream.TransportState serverStream = NettyServerHandler.this.serverStream(stream);
                    if (serverStream != null) {
                        serverStream.transportReportStatus(status);
                    }
                    return true;
                }
            });
        }
        finally {
            super.channelInactive(ctx);
        }
    }

    WriteQueue getWriteQueue() {
        return this.serverWriteQueue;
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof SendGrpcFrameCommand) {
            this.sendGrpcFrame(ctx, (SendGrpcFrameCommand)msg, promise);
        } else if (msg instanceof SendResponseHeadersCommand) {
            this.sendResponseHeaders(ctx, (SendResponseHeadersCommand)msg, promise);
        } else if (msg instanceof CancelServerStreamCommand) {
            this.cancelStream(ctx, (CancelServerStreamCommand)msg, promise);
        } else if (msg instanceof ForcefulCloseCommand) {
            this.forcefulClose(ctx, (ForcefulCloseCommand)msg, promise);
        } else {
            AssertionError e = new AssertionError((Object)("Write called for unexpected type: " + msg.getClass().getName()));
            ReferenceCountUtil.release(msg);
            promise.setFailure((Throwable)((Object)e));
            throw e;
        }
    }

    void returnProcessedBytes(Http2Stream http2Stream, int bytes) {
        try {
            this.decoder().flowController().consumeBytes(http2Stream, bytes);
        }
        catch (Http2Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void closeStreamWhenDone(ChannelPromise promise, int streamId) throws Http2Exception {
        final NettyServerStream.TransportState stream = this.serverStream(this.requireHttp2Stream(streamId));
        promise.addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) {
                stream.complete();
            }
        });
    }

    private void sendGrpcFrame(ChannelHandlerContext ctx, SendGrpcFrameCommand cmd, ChannelPromise promise) throws Http2Exception {
        if (cmd.endStream()) {
            this.closeStreamWhenDone(promise, cmd.streamId());
        }
        this.encoder().writeData(ctx, cmd.streamId(), cmd.content(), 0, cmd.endStream(), promise);
    }

    private void sendResponseHeaders(ChannelHandlerContext ctx, SendResponseHeadersCommand cmd, ChannelPromise promise) throws Http2Exception {
        int streamId = cmd.stream().id();
        Http2Stream stream = this.connection().stream(streamId);
        if (stream == null) {
            this.resetStream(ctx, streamId, Http2Error.CANCEL.code(), promise);
            return;
        }
        if (cmd.endOfStream()) {
            this.closeStreamWhenDone(promise, streamId);
        }
        this.encoder().writeHeaders(ctx, streamId, cmd.headers(), 0, cmd.endOfStream(), promise);
    }

    private void cancelStream(ChannelHandlerContext ctx, CancelServerStreamCommand cmd, ChannelPromise promise) {
        cmd.stream().transportReportStatus(cmd.reason());
        this.encoder().writeRstStream(ctx, cmd.stream().id(), Http2Error.CANCEL.code(), promise);
    }

    private void forcefulClose(final ChannelHandlerContext ctx, final ForcefulCloseCommand msg, ChannelPromise promise) throws Exception {
        this.close(ctx, promise);
        this.connection().forEachActiveStream(new Http2StreamVisitor(){

            @Override
            public boolean visit(Http2Stream stream) throws Http2Exception {
                NettyServerStream.TransportState serverStream = NettyServerHandler.this.serverStream(stream);
                if (serverStream != null) {
                    serverStream.transportReportStatus(msg.getStatus());
                    NettyServerHandler.this.resetStream(ctx, stream.id(), Http2Error.CANCEL.code(), ctx.newPromise());
                }
                stream.close();
                return true;
            }
        });
    }

    private void verifyContentType(int streamId, Http2Headers headers) throws Http2Exception {
        CharSequence contentType = (CharSequence)headers.get(Utils.CONTENT_TYPE_HEADER);
        if (contentType == null) {
            throw Http2Exception.streamError(streamId, Http2Error.REFUSED_STREAM, "Content-Type is missing from the request", new Object[0]);
        }
        String contentTypeString = contentType.toString();
        if (!GrpcUtil.isGrpcContentType(contentTypeString)) {
            throw Http2Exception.streamError(streamId, Http2Error.REFUSED_STREAM, "Content-Type '%s' is not supported", contentTypeString);
        }
    }

    private Http2Stream requireHttp2Stream(int streamId) {
        Http2Stream stream = this.connection().stream(streamId);
        if (stream == null) {
            throw new AssertionError((Object)("Stream does not exist: " + streamId));
        }
        return stream;
    }

    private String determineMethod(int streamId, Http2Headers headers) throws Http2Exception {
        if (!Utils.HTTP_METHOD.equals(headers.method())) {
            throw Http2Exception.streamError(streamId, Http2Error.REFUSED_STREAM, "Method '%s' is not supported", headers.method());
        }
        CharSequence path = headers.path();
        if (path.charAt(0) != '/') {
            throw Http2Exception.streamError(streamId, Http2Error.REFUSED_STREAM, "Malformatted path: %s", path);
        }
        return path.subSequence(1, path.length()).toString();
    }

    private NettyServerStream.TransportState serverStream(Http2Stream stream) {
        return stream == null ? null : (NettyServerStream.TransportState)stream.getProperty(this.streamKey);
    }

    private Http2Exception newStreamException(int streamId, Throwable cause) {
        return Http2Exception.streamError(streamId, Http2Error.INTERNAL_ERROR, cause, cause.getMessage(), new Object[0]);
    }

    private static class WriteMonitoringFrameWriter
    extends DecoratingHttp2FrameWriter {
        private final KeepAliveEnforcer keepAliveEnforcer;

        public WriteMonitoringFrameWriter(Http2FrameWriter delegate, KeepAliveEnforcer keepAliveEnforcer) {
            super(delegate);
            this.keepAliveEnforcer = keepAliveEnforcer;
        }

        @Override
        public ChannelFuture writeData(ChannelHandlerContext ctx, int streamId, ByteBuf data, int padding, boolean endStream, ChannelPromise promise) {
            this.keepAliveEnforcer.resetCounters();
            return super.writeData(ctx, streamId, data, padding, endStream, promise);
        }

        @Override
        public ChannelFuture writeHeaders(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int padding, boolean endStream, ChannelPromise promise) {
            this.keepAliveEnforcer.resetCounters();
            return super.writeHeaders(ctx, streamId, headers, padding, endStream, promise);
        }

        @Override
        public ChannelFuture writeHeaders(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endStream, ChannelPromise promise) {
            this.keepAliveEnforcer.resetCounters();
            return super.writeHeaders(ctx, streamId, headers, streamDependency, weight, exclusive, padding, endStream, promise);
        }
    }

    private final class KeepAlivePinger
    implements KeepAliveManager.KeepAlivePinger {
        final ChannelHandlerContext ctx;

        KeepAlivePinger(ChannelHandlerContext ctx) {
            this.ctx = ctx;
        }

        @Override
        public void ping() {
            NettyServerHandler.this.encoder().writePing(this.ctx, false, KEEPALIVE_PING_BUF, this.ctx.newPromise());
            this.ctx.flush();
        }

        @Override
        public void onPingTimeout() {
            try {
                NettyServerHandler.this.forcefulClose(this.ctx, new ForcefulCloseCommand(Status.UNAVAILABLE.withDescription("Keepalive failed. The connection is likely gone")), this.ctx.newPromise());
            }
            catch (Exception ex) {
                try {
                    NettyServerHandler.this.exceptionCaught(this.ctx, ex);
                }
                catch (Exception ex2) {
                    logger.log(Level.WARNING, "Exception while propagating exception", ex2);
                    logger.log(Level.WARNING, "Original failure", ex);
                }
            }
        }
    }

    private class FrameListener
    extends Http2FrameAdapter {
        private FrameListener() {
        }

        @Override
        public int onDataRead(ChannelHandlerContext ctx, int streamId, ByteBuf data, int padding, boolean endOfStream) throws Http2Exception {
            if (NettyServerHandler.this.keepAliveManager != null) {
                NettyServerHandler.this.keepAliveManager.onDataReceived();
            }
            NettyServerHandler.this.onDataRead(streamId, data, padding, endOfStream);
            return padding;
        }

        @Override
        public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endStream) throws Http2Exception {
            if (NettyServerHandler.this.keepAliveManager != null) {
                NettyServerHandler.this.keepAliveManager.onDataReceived();
            }
            NettyServerHandler.this.onHeadersRead(ctx, streamId, headers);
        }

        @Override
        public void onRstStreamRead(ChannelHandlerContext ctx, int streamId, long errorCode) throws Http2Exception {
            if (NettyServerHandler.this.keepAliveManager != null) {
                NettyServerHandler.this.keepAliveManager.onDataReceived();
            }
            NettyServerHandler.this.onRstStreamRead(streamId);
        }

        @Override
        public void onPingRead(ChannelHandlerContext ctx, ByteBuf data) throws Http2Exception {
            if (NettyServerHandler.this.keepAliveManager != null) {
                NettyServerHandler.this.keepAliveManager.onDataReceived();
            }
            if (!NettyServerHandler.this.keepAliveEnforcer.pingAcceptable()) {
                ByteBuf debugData = ByteBufUtil.writeAscii(ctx.alloc(), (CharSequence)"too_many_pings");
                NettyServerHandler.this.goAway(ctx, NettyServerHandler.this.connection().remote().lastStreamCreated(), Http2Error.ENHANCE_YOUR_CALM.code(), debugData, ctx.newPromise());
                Status status = Status.RESOURCE_EXHAUSTED.withDescription("Too many pings from client");
                try {
                    NettyServerHandler.this.forcefulClose(ctx, new ForcefulCloseCommand(status), ctx.newPromise());
                }
                catch (Exception ex) {
                    NettyServerHandler.this.onError(ctx, ex);
                }
            }
        }

        @Override
        public void onPingAckRead(ChannelHandlerContext ctx, ByteBuf data) throws Http2Exception {
            if (NettyServerHandler.this.keepAliveManager != null) {
                NettyServerHandler.this.keepAliveManager.onDataReceived();
            }
            if (data.getLong(data.readerIndex()) == (long)NettyServerHandler.this.flowControlPing().payload()) {
                NettyServerHandler.this.flowControlPing().updateWindow();
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, String.format("Window: %d", NettyServerHandler.this.decoder().flowController().initialWindowSize(NettyServerHandler.this.connection().connectionStream())));
                }
            } else {
                logger.warning("Received unexpected ping ack. No ping outstanding");
            }
        }
    }
}

