/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.config;

import com.google.bigtable.repackaged.com.google.common.base.MoreObjects;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import java.io.Serializable;

public class CallOptionsConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final boolean USE_TIMEOUT_DEFAULT = false;
    public static final int SHORT_TIMEOUT_MS_DEFAULT = 60000;
    public static final int LONG_TIMEOUT_MS_DEFAULT = 600000;
    private final boolean useTimeout;
    private final int shortRpcTimeoutMs;
    private final int longRpcTimeoutMs;

    public CallOptionsConfig(boolean useTimeout, int unaryRpcTimeoutMs, int longRpcTimeoutMs) {
        this.useTimeout = useTimeout;
        this.shortRpcTimeoutMs = unaryRpcTimeoutMs;
        this.longRpcTimeoutMs = longRpcTimeoutMs;
    }

    public boolean isUseTimeout() {
        return this.useTimeout;
    }

    @Deprecated
    public int getTimeoutMs() {
        return this.getShortRpcTimeoutMs();
    }

    public int getShortRpcTimeoutMs() {
        return this.shortRpcTimeoutMs;
    }

    public int getLongRpcTimeoutMs() {
        return this.longRpcTimeoutMs;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != CallOptionsConfig.class) {
            return false;
        }
        CallOptionsConfig other = (CallOptionsConfig)obj;
        return this.useTimeout == other.useTimeout && this.shortRpcTimeoutMs == other.shortRpcTimeoutMs && this.longRpcTimeoutMs == other.longRpcTimeoutMs;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("useTimeout", this.useTimeout).add("shortRpcTimeoutMs", this.shortRpcTimeoutMs).add("longRpcTimeoutMs", this.longRpcTimeoutMs).toString();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static class Builder {
        private boolean useTimeout = false;
        private int shortRpcTimeoutMs = 60000;
        private int longRpcTimeoutMs = 600000;

        public Builder() {
        }

        private Builder(CallOptionsConfig original) {
            this.useTimeout = original.useTimeout;
            this.shortRpcTimeoutMs = original.shortRpcTimeoutMs;
            this.longRpcTimeoutMs = original.longRpcTimeoutMs;
        }

        public Builder setUseTimeout(boolean useTimeout) {
            this.useTimeout = useTimeout;
            return this;
        }

        @Deprecated
        public Builder setTimeoutMs(int timeoutMs) {
            return this.setShortRpcTimeoutMs(timeoutMs);
        }

        public Builder setShortRpcTimeoutMs(int shortRpcTimeoutMs) {
            Preconditions.checkArgument(shortRpcTimeoutMs > 0, "Short Timeout ms has to be greater than 0.");
            this.shortRpcTimeoutMs = shortRpcTimeoutMs;
            return this;
        }

        public Builder setLongRpcTimeoutMs(int longRpcTimeoutMs) {
            Preconditions.checkArgument(longRpcTimeoutMs > 0, "Long Timeout ms has to be greater than 0");
            this.longRpcTimeoutMs = longRpcTimeoutMs;
            return this;
        }

        public CallOptionsConfig build() {
            return new CallOptionsConfig(this.useTimeout, this.shortRpcTimeoutMs, this.longRpcTimeoutMs);
        }
    }
}

