/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.grpc;

import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BigtableClusterName {
    private static final Pattern PATTERN = Pattern.compile("projects/[^/]+/instances/([^/]+)/clusters/([^/]+)");
    private final String clusterName;
    private final String instanceId;
    private final String clusterId;

    public BigtableClusterName(String clusterName) {
        this.clusterName = clusterName;
        Matcher matcher = PATTERN.matcher(clusterName);
        Preconditions.checkArgument(matcher.matches(), "Malformed cluster name");
        this.instanceId = matcher.group(1);
        this.clusterId = matcher.group(2);
    }

    public String toString() {
        return this.clusterName;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public String toSnapshotName(String snapshotId) {
        return this.clusterName + "/snapshots/" + snapshotId;
    }
}

