/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.grpc;

import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BigtableTableName {
    private static final Pattern PATTERN = Pattern.compile("projects/[^/]+/instances/([^/]+)/tables/([^/]+)");
    private final String tableName;
    private final String instanceId;
    private final String tableId;

    public BigtableTableName(String tableName) {
        this.tableName = tableName;
        Matcher matcher = PATTERN.matcher(tableName);
        Preconditions.checkArgument(matcher.matches(), "Malformed snapshot name");
        this.instanceId = matcher.group(1);
        this.tableId = matcher.group(2);
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getTableId() {
        return this.tableId;
    }

    public String toString() {
        return this.tableName;
    }
}

