/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.grpc.async;

import com.google.bigtable.repackaged.com.google.common.base.Predicate;
import com.google.bigtable.repackaged.com.google.common.base.Throwables;
import com.google.bigtable.repackaged.io.grpc.CallOptions;
import com.google.bigtable.repackaged.io.grpc.Channel;
import com.google.bigtable.repackaged.io.grpc.ClientCall;
import com.google.bigtable.repackaged.io.grpc.Metadata;
import com.google.bigtable.repackaged.io.grpc.MethodDescriptor;
import com.google.cloud.bigtable.grpc.async.BigtableAsyncRpc;

public interface BigtableAsyncUtilities {
    public <RequestT, ResponseT> BigtableAsyncRpc<RequestT, ResponseT> createAsyncRpc(MethodDescriptor<RequestT, ResponseT> var1, Predicate<RequestT> var2);

    public static class Default
    implements BigtableAsyncUtilities {
        private final Channel channel;

        public Default(Channel channel) {
            this.channel = channel;
        }

        @Override
        public <RequestT, ResponseT> BigtableAsyncRpc<RequestT, ResponseT> createAsyncRpc(final MethodDescriptor<RequestT, ResponseT> method, final Predicate<RequestT> isRetryable) {
            final BigtableAsyncRpc.RpcMetrics metrics = BigtableAsyncRpc.RpcMetrics.createRpcMetrics(method);
            return new BigtableAsyncRpc<RequestT, ResponseT>(){

                @Override
                public boolean isRetryable(RequestT request) {
                    return isRetryable.apply(request);
                }

                @Override
                public MethodDescriptor<RequestT, ResponseT> getMethodDescriptor() {
                    return method;
                }

                @Override
                public BigtableAsyncRpc.RpcMetrics getRpcMetrics() {
                    return metrics;
                }

                @Override
                public ClientCall<RequestT, ResponseT> startNewCall(CallOptions callOptions, RequestT request, ClientCall.Listener<ResponseT> listener, Metadata metadata) {
                    ClientCall call = Default.this.channel.newCall(method, callOptions);
                    call.start(listener, metadata);
                    call.request(1);
                    try {
                        call.sendMessage(request);
                    }
                    catch (Throwable t) {
                        call.cancel("Exception in sendMessage.", t);
                        throw Throwables.propagate(t);
                    }
                    try {
                        call.halfClose();
                    }
                    catch (Throwable t) {
                        call.cancel("Exception in halfClose.", t);
                        throw Throwables.propagate(t);
                    }
                    return call;
                }
            };
        }
    }
}

