/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.grpc.async;

import com.google.bigtable.repackaged.com.google.api.client.util.BackOff;
import com.google.bigtable.repackaged.com.google.api.client.util.NanoClock;
import com.google.bigtable.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.FutureCallback;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.Futures;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.ListenableFuture;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.SettableFuture;
import com.google.bigtable.repackaged.com.google.protobuf.Any;
import com.google.bigtable.repackaged.io.grpc.Status;
import com.google.bigtable.repackaged.io.grpc.StatusRuntimeException;
import com.google.bigtable.v2.MutateRowRequest;
import com.google.bigtable.v2.MutateRowResponse;
import com.google.bigtable.v2.MutateRowsRequest;
import com.google.bigtable.v2.MutateRowsResponse;
import com.google.cloud.bigtable.config.BulkOptions;
import com.google.cloud.bigtable.config.Logger;
import com.google.cloud.bigtable.config.RetryOptions;
import com.google.cloud.bigtable.grpc.BigtableTableName;
import com.google.cloud.bigtable.grpc.async.AsyncExecutor;
import com.google.cloud.bigtable.grpc.async.BulkMutationsStats;
import com.google.cloud.bigtable.grpc.async.OperationAccountant;
import com.google.cloud.bigtable.grpc.scanner.BigtableRetriesExhaustedException;
import com.google.cloud.bigtable.metrics.BigtableClientMetrics;
import com.google.cloud.bigtable.metrics.Meter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public class BulkMutation {
    private static final StatusRuntimeException MISSING_ENTRY_EXCEPTION = Status.UNKNOWN.withDescription("Mutation does not have a status").asRuntimeException();
    @VisibleForTesting
    static Logger LOG = new Logger(BulkMutation.class);
    public static final long MAX_RPC_WAIT_TIME_NANOS = TimeUnit.MINUTES.toNanos(7L);
    private final AtomicLong batchIdGenerator = new AtomicLong();
    @VisibleForTesting
    Batch currentBatch = null;
    private ScheduledFuture<?> scheduledFlush = null;
    private final String tableName;
    private final AsyncExecutor asyncExecutor;
    private final RetryOptions retryOptions;
    private final ScheduledExecutorService retryExecutorService;
    private final int maxRowKeyCount;
    private final long maxRequestSize;
    private final long autoflushMs;
    private final Meter batchMeter = BigtableClientMetrics.meter(BigtableClientMetrics.MetricLevel.Info, "bulk-mutator.batch.meter");
    @VisibleForTesting
    NanoClock clock = NanoClock.SYSTEM;

    private static StatusRuntimeException toException(com.google.bigtable.repackaged.com.google.rpc.Status status) {
        Status grpcStatus = Status.fromCodeValue(status.getCode()).withDescription(status.getMessage());
        for (Any detail : status.getDetailsList()) {
            grpcStatus = grpcStatus.augmentDescription(detail.toString());
        }
        return grpcStatus.asRuntimeException();
    }

    @VisibleForTesting
    static MutateRowsRequest.Entry convert(MutateRowRequest request) {
        if (request == null) {
            return null;
        }
        return MutateRowsRequest.Entry.newBuilder().setRowKey(request.getRowKey()).addAllMutations(request.getMutationsList()).build();
    }

    public BulkMutation(BigtableTableName tableName, AsyncExecutor asyncExecutor, RetryOptions retryOptions, ScheduledExecutorService retryExecutorService, BulkOptions bulkOptions) {
        this.tableName = tableName.toString();
        this.asyncExecutor = asyncExecutor;
        this.retryOptions = retryOptions;
        this.retryExecutorService = retryExecutorService;
        this.maxRowKeyCount = bulkOptions.getBulkMaxRowKeyCount();
        this.maxRequestSize = bulkOptions.getBulkMaxRequestSize();
        this.autoflushMs = bulkOptions.getAutoflushMs();
    }

    public ListenableFuture<MutateRowResponse> add(MutateRowRequest request) {
        return this.add(BulkMutation.convert(request));
    }

    public synchronized ListenableFuture<MutateRowResponse> add(MutateRowsRequest.Entry entry) {
        Preconditions.checkNotNull(entry, "Request null");
        Preconditions.checkArgument(!entry.getRowKey().isEmpty(), "Request has an empty rowkey");
        if (this.currentBatch == null) {
            this.batchMeter.mark();
            this.currentBatch = new Batch();
        }
        ListenableFuture future = this.currentBatch.add(entry);
        if (this.currentBatch.isFull()) {
            this.flush();
        }
        if (this.autoflushMs > 0L && this.currentBatch != null && this.scheduledFlush == null) {
            this.scheduledFlush = this.retryExecutorService.schedule(new Runnable(){

                @Override
                public void run() {
                    BulkMutation.this.scheduledFlush = null;
                    BulkMutation.this.flush();
                }
            }, this.autoflushMs, TimeUnit.MILLISECONDS);
        }
        return future;
    }

    public synchronized void flush() {
        if (this.currentBatch != null) {
            this.currentBatch.run();
            this.currentBatch = null;
        }
    }

    public boolean isFlushed() {
        return this.currentBatch == null;
    }

    @VisibleForTesting
    AsyncExecutor getAsyncExecutor() {
        return this.asyncExecutor;
    }

    @VisibleForTesting
    class Batch
    implements Runnable {
        private final Meter mutationMeter = BigtableClientMetrics.meter(BigtableClientMetrics.MetricLevel.Info, "bulk-mutator.mutations.added");
        private final Meter mutationRetryMeter = BigtableClientMetrics.meter(BigtableClientMetrics.MetricLevel.Info, "bulk-mutator.mutations.retried");
        private Long batchId;
        private RequestManager currentRequestManager;
        private BackOff currentBackoff;
        private int failedCount;
        private ListenableFuture<List<MutateRowsResponse>> mutateRowsFuture;

        private Batch() {
            this.currentRequestManager = new RequestManager(BulkMutation.this.tableName, this.mutationMeter, BulkMutation.this.clock);
        }

        private ListenableFuture<MutateRowResponse> add(MutateRowsRequest.Entry entry) {
            Preconditions.checkNotNull(entry);
            SettableFuture<MutateRowResponse> future = SettableFuture.create();
            this.currentRequestManager.add(future, entry);
            return future;
        }

        private boolean isFull() {
            Preconditions.checkNotNull(this.currentRequestManager);
            return this.getRequestCount() >= BulkMutation.this.maxRowKeyCount || this.currentRequestManager.approximateByteSize >= BulkMutation.this.maxRequestSize;
        }

        private void addCallback(ListenableFuture<List<MutateRowsResponse>> bulkFuture, final Long rpcId) {
            Futures.addCallback(bulkFuture, new FutureCallback<List<MutateRowsResponse>>(){

                @Override
                public void onSuccess(List<MutateRowsResponse> result) {
                    this.markCompletion();
                    Batch.this.handleResult(result);
                }

                @Override
                public void onFailure(Throwable t) {
                    this.markCompletion();
                    Batch.this.performFullRetry((AtomicReference<Long>)new AtomicReference(), t);
                }

                protected void markCompletion() {
                    if (rpcId != null) {
                        BulkMutation.this.asyncExecutor.getResourceLimiter().markCanBeCompleted(rpcId);
                    }
                    BulkMutationsStats.getInstance().markMutationsRpcCompletion(BulkMutation.this.clock.nanoTime() - ((Batch)Batch.this).currentRequestManager.lastRpcSentTimeNanos);
                }
            });
        }

        @VisibleForTesting
        synchronized void handleResult(List<MutateRowsResponse> results) {
            this.mutateRowsFuture = null;
            AtomicReference<Long> backoffTime = new AtomicReference<Long>();
            try {
                if (this.operationsAreComplete()) {
                    LOG.warn("Got duplicate responses for bulk mutation.", new Object[0]);
                    this.setRetryComplete();
                    return;
                }
                if (results == null || results.isEmpty()) {
                    this.performFullRetry(backoffTime, Status.INTERNAL.withDescription("No MutateRowResponses were found."));
                    return;
                }
                ArrayList<MutateRowsResponse.Entry> entries = new ArrayList<MutateRowsResponse.Entry>();
                for (MutateRowsResponse response : results) {
                    entries.addAll(response.getEntriesList());
                }
                if (entries.isEmpty()) {
                    this.performFullRetry(backoffTime, Status.INTERNAL.withDescription("No MutateRowsResponses entries were found."));
                    return;
                }
                String tableName = this.currentRequestManager.request.getTableName();
                RequestManager retryRequestManager = new RequestManager(tableName, this.mutationRetryMeter, BulkMutation.this.clock);
                this.handleResponses(backoffTime, entries, retryRequestManager);
                this.handleExtraFutures(backoffTime, retryRequestManager, entries);
                this.completeOrRetry(backoffTime, retryRequestManager);
            }
            catch (Throwable e) {
                LOG.error("Unexpected Exception occurred. Treating this issue as a temporary issue and retrying.", e, new Object[0]);
                this.performFullRetry(backoffTime, Status.INTERNAL.withCause(e));
            }
        }

        @VisibleForTesting
        void performFullRetry(AtomicReference<Long> backoff, Status status) {
            this.performFullRetry(backoff, status.asRuntimeException());
        }

        private synchronized void performFullRetry(AtomicReference<Long> backoff, Throwable t) {
            this.mutateRowsFuture = null;
            if (this.currentRequestManager == null) {
                this.setRetryComplete();
                return;
            }
            long backoffMs = this.getCurrentBackoff(backoff);
            ++this.failedCount;
            if (backoffMs == -1L) {
                this.setFailure(new BigtableRetriesExhaustedException("Batch #" + this.batchId + " Exhausted retries.", t));
            } else {
                LOG.info("Retrying failed call for batch #%d. Failure #%d, got: %s", t, this.batchId, this.failedCount, Status.fromThrowable(t));
                this.mutationRetryMeter.mark(this.getRequestCount());
                BulkMutation.this.retryExecutorService.schedule(this, backoffMs, TimeUnit.MILLISECONDS);
            }
        }

        private long getCurrentBackoff(AtomicReference<Long> backOffTime) {
            if (backOffTime.get() == null) {
                try {
                    if (this.currentBackoff == null) {
                        this.currentBackoff = BulkMutation.this.retryOptions.createBackoff();
                    }
                    backOffTime.set(this.currentBackoff.nextBackOffMillis());
                }
                catch (IOException e) {
                    LOG.warn("Could not get the next backoff.", e, new Object[0]);
                    backOffTime.set(-1L);
                }
            }
            return backOffTime.get();
        }

        private void handleResponses(AtomicReference<Long> backoffTime, Iterable<MutateRowsResponse.Entry> entries, RequestManager retryRequestManager) {
            for (MutateRowsResponse.Entry entry : entries) {
                int index = (int)entry.getIndex();
                if (index >= this.getRequestCount()) {
                    LOG.error("Got extra status: %s", entry);
                    break;
                }
                SettableFuture future = (SettableFuture)this.currentRequestManager.futures.get(index);
                if (future == null) {
                    LOG.warn("Could not find a future for index %d.", index);
                    return;
                }
                com.google.bigtable.repackaged.com.google.rpc.Status status = entry.getStatus();
                int statusCode = status.getCode();
                if (statusCode == Status.Code.OK.value()) {
                    future.set(MutateRowResponse.getDefaultInstance());
                    continue;
                }
                if (!this.isRetryable(statusCode) || this.getCurrentBackoff(backoffTime) == -1L) {
                    future.setException(BulkMutation.toException(status));
                    continue;
                }
                retryRequestManager.add(future, this.currentRequestManager.request.getEntries(index));
            }
        }

        private void handleExtraFutures(AtomicReference<Long> backoffTime, RequestManager retryRequestManager, List<MutateRowsResponse.Entry> entries) {
            Set<Integer> indexes = this.getIndexes(entries);
            long missingEntriesCount = 0L;
            this.getCurrentBackoff(backoffTime);
            for (int i = 0; i < this.getRequestCount(); ++i) {
                if (indexes.remove(i)) continue;
                ++missingEntriesCount;
                if (backoffTime.get() == -1L) {
                    ((SettableFuture)this.currentRequestManager.futures.get(i)).setException(MISSING_ENTRY_EXCEPTION);
                    continue;
                }
                retryRequestManager.add((SettableFuture)this.currentRequestManager.futures.get(i), this.currentRequestManager.request.getEntries(i));
            }
            if (missingEntriesCount > 0L) {
                String handling = backoffTime.get() == -1L ? "Setting exceptions on the futures" : "Retrying";
                LOG.error("Missing %d responses for bulkWrite. %s.", missingEntriesCount, handling);
            }
        }

        private Set<Integer> getIndexes(List<MutateRowsResponse.Entry> entries) {
            HashSet<Integer> indexes = new HashSet<Integer>(entries.size());
            for (MutateRowsResponse.Entry entry : entries) {
                indexes.add((int)entry.getIndex());
            }
            return indexes;
        }

        private void completeOrRetry(AtomicReference<Long> backoffTime, RequestManager retryRequestManager) {
            BulkMutationsStats.getInstance().markMutationsSuccess(this.currentRequestManager.futures.size() - retryRequestManager.futures.size());
            if (retryRequestManager == null || retryRequestManager.isEmpty()) {
                this.setRetryComplete();
            } else {
                this.currentRequestManager = retryRequestManager;
                ++this.failedCount;
                this.mutationRetryMeter.mark(this.getRequestCount());
                LOG.info("Retrying failed call. Failure #%d, got #%d failures", this.failedCount, this.getRequestCount());
                BulkMutation.this.retryExecutorService.schedule(this, this.getCurrentBackoff(backoffTime), TimeUnit.MILLISECONDS);
            }
        }

        private boolean isRetryable(int codeId) {
            Status.Code code = Status.fromCodeValue(codeId).getCode();
            return BulkMutation.this.retryOptions.isRetryable(code);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public synchronized void run() {
            block9: {
                if (this.operationsAreComplete()) {
                    this.setRetryComplete();
                    return;
                }
                Long operationId = null;
                try {
                    if (this.batchId == null) {
                        this.batchId = BulkMutation.this.batchIdGenerator.incrementAndGet();
                        BulkMutation.this.asyncExecutor.getOperationAccountant().registerComplexOperation(this.batchId, this.createRetryHandler());
                    }
                    MutateRowsRequest request = this.currentRequestManager.build();
                    long start = BulkMutation.this.clock.nanoTime();
                    operationId = BulkMutation.this.asyncExecutor.getResourceLimiter().registerOperationWithHeapSize(request.getSerializedSize());
                    long now = BulkMutation.this.clock.nanoTime();
                    BulkMutationsStats.getInstance().markThrottling(now - start);
                    this.mutateRowsFuture = BulkMutation.this.asyncExecutor.getClient().mutateRowsAsync(request);
                    this.currentRequestManager.lastRpcSentTimeNanos = now;
                    this.addCallback(this.mutateRowsFuture, operationId);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    this.mutateRowsFuture = Futures.immediateFailedFuture(e);
                }
                catch (Throwable e2) {
                    this.mutateRowsFuture = Futures.immediateFailedFuture(e2);
                    this.addCallback(this.mutateRowsFuture, operationId);
                    break block9;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    this.addCallback(this.mutateRowsFuture, operationId);
                }
            }
        }

        private OperationAccountant.ComplexOperationStalenessHandler createRetryHandler() {
            return new OperationAccountant.ComplexOperationStalenessHandler(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void performRetryIfStale() {
                    Batch batch = Batch.this;
                    synchronized (batch) {
                        if (Batch.this.currentRequestManager == null || Batch.this.currentRequestManager.isEmpty()) {
                            Batch.this.setRetryComplete();
                        } else if (Batch.this.currentRequestManager.isStale()) {
                            Batch.this.setFailure(Status.UNKNOWN.withDescription("Stale requests.").asRuntimeException());
                        }
                    }
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setFailure(Throwable t) {
            try {
                if (this.currentRequestManager != null) {
                    for (SettableFuture future : this.currentRequestManager.futures) {
                        future.setException(t);
                    }
                }
            }
            finally {
                this.setRetryComplete();
            }
        }

        private synchronized void setRetryComplete() {
            if (this.mutateRowsFuture != null && !this.mutateRowsFuture.isDone()) {
                this.mutateRowsFuture.cancel(true);
            }
            this.mutateRowsFuture = null;
            if (this.batchId != null) {
                BulkMutation.this.asyncExecutor.getOperationAccountant().onComplexOperationCompletion(this.batchId);
                if (this.failedCount > 0) {
                    LOG.info("Batch #%d recovered from the failure and completed.", this.batchId);
                }
                this.batchId = null;
            }
            this.currentRequestManager = null;
        }

        @VisibleForTesting
        int getRequestCount() {
            return this.currentRequestManager == null ? 0 : this.currentRequestManager.getRequestCount();
        }

        boolean operationsAreComplete() {
            return this.currentRequestManager == null || this.currentRequestManager.isEmpty();
        }
    }

    @VisibleForTesting
    static class RequestManager {
        private final List<SettableFuture<MutateRowResponse>> futures = new ArrayList<SettableFuture<MutateRowResponse>>();
        private final MutateRowsRequest.Builder builder;
        private final Meter addMeter;
        private MutateRowsRequest request;
        private long approximateByteSize = 0L;
        @VisibleForTesting
        Long lastRpcSentTimeNanos;
        private NanoClock clock;

        RequestManager(String tableName, Meter addMeter, NanoClock clock) {
            this.builder = MutateRowsRequest.newBuilder().setTableName(tableName);
            this.approximateByteSize = tableName.length() + 2;
            this.addMeter = addMeter;
            this.clock = clock;
        }

        void add(SettableFuture<MutateRowResponse> future, MutateRowsRequest.Entry entry) {
            this.addMeter.mark();
            this.futures.add(future);
            this.builder.addEntries(entry);
            this.approximateByteSize += (long)entry.getSerializedSize();
        }

        MutateRowsRequest build() {
            this.request = this.builder.build();
            return this.request;
        }

        public boolean isEmpty() {
            return this.futures.isEmpty();
        }

        public int getRequestCount() {
            return this.futures.size();
        }

        public boolean isStale() {
            return this.lastRpcSentTimeNanos != null && this.lastRpcSentTimeNanos < this.clock.nanoTime() - MAX_RPC_WAIT_TIME_NANOS;
        }

        public boolean wasSent() {
            return this.lastRpcSentTimeNanos != null;
        }
    }
}

