/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.grpc.async;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.bigtable.repackaged.com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class BulkMutationsStats {
    private static BulkMutationsStats instance = new BulkMutationsStats();
    private final MetricRegistry registry = new MetricRegistry();
    private final Timer mutationTimer = this.registry.timer("MutationStats.mutation.timer");
    private final Meter mutationMeter = this.registry.meter("MutationStats.mutation.meter");
    private final Timer throttlingTimer = this.registry.timer("MutationStats.throttling.timer");
    private final AtomicLong cumulativeThrottlingTimeNanos = new AtomicLong();

    public static BulkMutationsStats getInstance() {
        return instance;
    }

    @VisibleForTesting
    static void reset() {
        instance = new BulkMutationsStats();
    }

    void markMutationsRpcCompletion(long rpcDurationInNanos) {
        this.mutationTimer.update(rpcDurationInNanos, TimeUnit.NANOSECONDS);
    }

    void markMutationsSuccess(long mutationCount) {
        this.mutationMeter.mark(mutationCount);
    }

    void markThrottling(long throttlingDurationInNanos) {
        this.throttlingTimer.update(throttlingDurationInNanos, TimeUnit.NANOSECONDS);
        this.cumulativeThrottlingTimeNanos.addAndGet(throttlingDurationInNanos);
    }

    public Timer getMutationTimer() {
        return this.mutationTimer;
    }

    public Meter getMutationMeter() {
        return this.mutationMeter;
    }

    public Timer getThrottlingTimer() {
        return this.throttlingTimer;
    }

    public long getCumulativeThrottlingTimeNanos() {
        return this.cumulativeThrottlingTimeNanos.get();
    }
}

