/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.grpc.async;

import com.google.bigtable.repackaged.com.google.api.client.util.NanoClock;
import com.google.bigtable.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableList;
import com.google.cloud.bigtable.config.Logger;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.concurrent.GuardedBy;

public class OperationAccountant {
    @VisibleForTesting
    static Logger LOG = new Logger(OperationAccountant.class);
    @VisibleForTesting
    static final long DEFAULT_FINISH_WAIT_MILLIS = 250L;
    private static final long INTERVAL_NO_SUCCESS_WARNING_NANOS = TimeUnit.SECONDS.toNanos(30L);
    private final NanoClock clock;
    private final long finishWaitMillis;
    private ReentrantLock lock = new ReentrantLock();
    private Condition flushedCondition = this.lock.newCondition();
    @GuardedBy(value="lock")
    private Set<Long> operations = new HashSet<Long>();
    @GuardedBy(value="lock")
    private Map<Long, ComplexOperationStalenessHandler> complexOperations = new HashMap<Long, ComplexOperationStalenessHandler>();
    private long noSuccessCheckDeadlineNanos;
    private int noSuccessWarningCount;

    public OperationAccountant() {
        this(NanoClock.SYSTEM, 250L);
    }

    @VisibleForTesting
    OperationAccountant(NanoClock clock, long finishWaitMillis) {
        this.clock = clock;
        this.finishWaitMillis = finishWaitMillis;
        this.resetNoSuccessWarningDeadline();
    }

    public void registerOperation(long id) throws InterruptedException {
        this.lock.lock();
        try {
            this.operations.add(id);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void registerComplexOperation(long id, ComplexOperationStalenessHandler handler) {
        this.lock.lock();
        try {
            this.complexOperations.put(id, handler);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitCompletion() throws InterruptedException {
        boolean performedWarning = false;
        this.lock.lock();
        try {
            while (!this.isFlushed()) {
                this.flushedCondition.await(this.finishWaitMillis, TimeUnit.MILLISECONDS);
                long now = this.clock.nanoTime();
                if (now < this.noSuccessCheckDeadlineNanos) continue;
                ImmutableList<ComplexOperationStalenessHandler> toCheck = ImmutableList.copyOf(this.complexOperations.values());
                this.lock.unlock();
                try {
                    for (ComplexOperationStalenessHandler stalenessHandler : toCheck) {
                        stalenessHandler.performRetryIfStale();
                    }
                }
                finally {
                    this.lock.lock();
                }
                if (this.isFlushed()) break;
                this.logNoSuccessWarning(now);
                this.resetNoSuccessWarningDeadline();
                performedWarning = true;
            }
            if (performedWarning) {
                LOG.info("awaitCompletion() completed", new Object[0]);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void logNoSuccessWarning(long now) {
        long lastUpdateNanos = now - this.noSuccessCheckDeadlineNanos + INTERVAL_NO_SUCCESS_WARNING_NANOS;
        long lastUpdated = TimeUnit.NANOSECONDS.toSeconds(lastUpdateNanos);
        LOG.warn("No operations completed within the last %d seconds. There are still %d simple operations and %d complex operations in progress.", lastUpdated, this.operations.size(), this.complexOperations.size());
        ++this.noSuccessWarningCount;
    }

    public boolean hasInflightOperations() {
        this.lock.lock();
        try {
            boolean bl = !this.isFlushed();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    private boolean isFlushed() {
        return this.operations.isEmpty() && this.complexOperations.isEmpty();
    }

    private void resetNoSuccessWarningDeadline() {
        this.noSuccessCheckDeadlineNanos = this.clock.nanoTime() + INTERVAL_NO_SUCCESS_WARNING_NANOS;
    }

    @VisibleForTesting
    int getNoSuccessWarningCount() {
        return this.noSuccessWarningCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    boolean onOperationCompletion(long id) {
        boolean response = false;
        this.lock.lock();
        try {
            response = this.operations.remove(id);
            if (this.isFlushed()) {
                this.flushedCondition.signal();
            }
        }
        finally {
            this.lock.unlock();
        }
        this.resetNoSuccessWarningDeadline();
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean onComplexOperationCompletion(long id) {
        boolean response = false;
        this.lock.lock();
        try {
            boolean bl = response = this.complexOperations.remove(id) != null;
            if (this.isFlushed()) {
                this.flushedCondition.signal();
            }
        }
        finally {
            this.lock.unlock();
        }
        this.resetNoSuccessWarningDeadline();
        return response;
    }

    @VisibleForTesting
    void awaitCompletionPing() {
        this.lock.lock();
        try {
            this.flushedCondition.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    public static interface ComplexOperationStalenessHandler {
        public void performRetryIfStale();
    }
}

